/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.QuantSignalsEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.QuantSignalsLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.QuantSignalsTableComparator;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;

public class QuantSignalsListUI
extends ExtendedTableViewer {
    private String[] titles = QuantSignalsLabelProvider.TITLES;
    private int[] bounds = QuantSignalsLabelProvider.BOUNDS;
    private IBaseLabelProvider labelProvider = new QuantSignalsLabelProvider();
    private ViewerComparator tableComparator = new QuantSignalsTableComparator();

    public QuantSignalsListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void clear() {
        this.setInput(null);
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider(this.labelProvider);
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator(this.tableComparator);
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals("Relative Response")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new QuantSignalsEditingSupport(this, label));
            } else if (label.equals("Uncertainty")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new QuantSignalsEditingSupport(this, label));
            } else if (label.equals("Use")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new QuantSignalsEditingSupport(this, label));
            }
            ++i;
        }
    }
}

