/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.IonListContentProviderLazy;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ScanLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ScanSignalEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ScanSignalListFilter;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ScanTableComparator;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class ScanTableUI
extends ExtendedTableViewer {
    private static final Logger logger = Logger.getLogger(ScanTableUI.class);
    private Map<DataType, ITableLabelProvider> labelProviderMap = new HashMap<DataType, ITableLabelProvider>();
    private Map<DataType, ViewerComparator> viewerComparatorMap = new HashMap<DataType, ViewerComparator>();
    private Map<DataType, IContentProvider> contentProviderMap = new HashMap<DataType, IContentProvider>();
    private ScanSignalListFilter scanSignalListFilter;
    private IScan scan = null;

    public ScanTableUI(Composite parent, int style) {
        super(parent, style);
        this.setLabelAndContentProviders(DataType.MSD_NOMINAL);
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.scanSignalListFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void updateScan() {
        this.setInput(this.scan);
    }

    public void setInput(IScan scan) {
        this.scan = scan;
        if (scan instanceof IScanMSD) {
            super.setInput(null);
            IScanMSD scanMSD = (IScanMSD)scan;
            List ions = scanMSD.getIons();
            int size = ions.size();
            DataType dataType = DataType.MSD_NOMINAL;
            if (scanMSD.isTandemMS()) {
                dataType = DataType.MSD_TANDEM;
            } else if (scanMSD.isHighResolutionMS()) {
                dataType = DataType.MSD_HIGHRES;
            }
            this.setLabelAndContentProviders(dataType);
            super.setInput((Object)ions);
            this.setItemCount(size);
        } else if (scan instanceof IScanCSD) {
            super.setInput(null);
            IScanCSD scanCSD = (IScanCSD)scan;
            this.setLabelAndContentProviders(DataType.CSD);
            ArrayList<IScanCSD> list = new ArrayList<IScanCSD>();
            list.add(scanCSD);
            super.setInput(list);
        } else if (scan instanceof IScanWSD) {
            super.setInput(null);
            IScanWSD scanWSD = (IScanWSD)scan;
            this.setLabelAndContentProviders(DataType.WSD);
            super.setInput((Object)scanWSD.getScanSignals());
        } else {
            this.getTable().removeAll();
            super.setInput(null);
        }
    }

    private void setLabelAndContentProviders(DataType dataType) {
        this.setComparator(null);
        this.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider(DataType.NONE));
        String[] titles = this.getTitles(dataType);
        int[] bounds = this.getBounds(dataType);
        this.createColumns(titles, bounds);
        ITableLabelProvider labelProvider = this.getTableLabelProvider(dataType);
        this.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (labelProvider instanceof ScanLabelProvider) {
            ScanLabelProvider scanLabelProvider = (ScanLabelProvider)labelProvider;
            float totalIntensity = this.scan != null ? this.scan.getTotalSignal() : 0.0f;
            scanLabelProvider.setTotalIntensity(totalIntensity);
        }
        IContentProvider contentProvider = this.getContentProvider(dataType);
        if (this.useVirtualTableSettings(this.scan, dataType)) {
            logger.trace((Object)"Lazy (Virtual) Modus");
            this.setContentProvider(contentProvider);
            this.setUseHashlookup(true);
            this.setComparator(null);
        } else {
            logger.trace((Object)"Normal Modus");
            this.setContentProvider(contentProvider);
            this.setUseHashlookup(false);
            ViewerComparator viewerComparator = this.getViewerComparator(dataType);
            this.setComparator(viewerComparator);
        }
        this.scanSignalListFilter = new ScanSignalListFilter();
        this.setFilters(new ViewerFilter[]{this.scanSignalListFilter});
        this.setEditingSupport();
    }

    private String[] getTitles(DataType dataType) {
        String[] titles;
        switch (dataType) {
            case MSD_NOMINAL: {
                titles = ScanLabelProvider.TITLES_MSD_NOMINAL;
                break;
            }
            case MSD_TANDEM: {
                titles = ScanLabelProvider.TITLES_MSD_TANDEM;
                break;
            }
            case MSD_HIGHRES: {
                titles = ScanLabelProvider.TITLES_MSD_HIGHRES;
                break;
            }
            case CSD: {
                titles = ScanLabelProvider.TITLES_CSD;
                break;
            }
            case WSD: {
                titles = ScanLabelProvider.TITLES_WSD;
                break;
            }
            default: {
                titles = ScanLabelProvider.TITLES_EMPTY;
            }
        }
        return titles;
    }

    private int[] getBounds(DataType dataType) {
        int[] bounds;
        switch (dataType) {
            case MSD_NOMINAL: {
                bounds = ScanLabelProvider.BOUNDS_MSD_NOMINAL;
                break;
            }
            case MSD_TANDEM: {
                bounds = ScanLabelProvider.BOUNDS_MSD_TANDEM;
                break;
            }
            case MSD_HIGHRES: {
                bounds = ScanLabelProvider.BOUNDS_MSD_HIGHRES;
                break;
            }
            case CSD: {
                bounds = ScanLabelProvider.BOUNDS_CSD;
                break;
            }
            case WSD: {
                bounds = ScanLabelProvider.BOUNDS_WSD;
                break;
            }
            default: {
                bounds = ScanLabelProvider.BOUNDS_EMPTY;
            }
        }
        return bounds;
    }

    private ITableLabelProvider getTableLabelProvider(DataType dataType) {
        ITableLabelProvider tableLableProvider = this.labelProviderMap.get(dataType);
        if (tableLableProvider == null) {
            tableLableProvider = new ScanLabelProvider(dataType);
            this.labelProviderMap.put(dataType, tableLableProvider);
        }
        return tableLableProvider;
    }

    private ViewerComparator getViewerComparator(DataType dataType) {
        Object viewerComparator = this.viewerComparatorMap.get(dataType);
        if (viewerComparator == null) {
            viewerComparator = new ScanTableComparator(dataType);
            this.viewerComparatorMap.put(dataType, (ViewerComparator)viewerComparator);
        }
        return viewerComparator;
    }

    private IContentProvider getContentProvider(DataType dataType) {
        Object contentProvider = this.contentProviderMap.get(dataType);
        if (contentProvider == null) {
            contentProvider = this.useVirtualTableSettings(this.scan, dataType) ? new IonListContentProviderLazy((TableViewer)this) : new ListContentProvider();
            this.contentProviderMap.put(dataType, (IContentProvider)contentProvider);
        }
        return contentProvider;
    }

    private boolean useVirtualTableSettings(IScan scan, DataType dataType) {
        IScanMSD scanMSD;
        int numberIons;
        return this.isVirtualTable() && scan != null && scan instanceof IScanMSD && dataType.equals((Object)DataType.MSD_HIGHRES) && (numberIons = (scanMSD = (IScanMSD)scan).getNumberOfIons()) > 5000;
    }

    private boolean isVirtualTable() {
        return (this.getTable().getStyle() & 0x10000000) == 0x10000000;
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals(ScanLabelProvider.INTENSITY)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new ScanSignalEditingSupport(this, label));
            }
            ++i;
        }
    }
}

