/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.chemclipse.converter.methods.MethodConverter;
import org.eclipse.chemclipse.model.handler.IModificationHandler;
import org.eclipse.chemclipse.model.methods.ListProcessEntryContainer;
import org.eclipse.chemclipse.model.methods.ProcessEntry;
import org.eclipse.chemclipse.model.methods.ProcessMethod;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.MethodListLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.TableConfigSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.MethodSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.ProcessingWizard;
import org.eclipse.chemclipse.ux.extension.xxd.ui.methods.SettingsWizard;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ConfigurableUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.MethodUIConfig;
import org.eclipse.chemclipse.xxd.process.ui.preferences.PreferencePageReportExport;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ExtendedMethodUI
extends Composite
implements ConfigurableUI<MethodUIConfig> {
    private Composite toolbarHeader;
    private Label labelDataInfo;
    private Text textName;
    private Text textCategory;
    private Text textOperator;
    private Text textDescription;
    private ToolItem buttonAdd;
    private ToolItem buttonCopy;
    private ToolItem buttonRemove;
    private ToolItem buttonMoveUp;
    private ToolItem buttonMoveDown;
    private ToolItem buttonModifySettings;
    private StructuredViewer listUI;
    private ProcessMethod processMethod;
    private IModificationHandler modificationHandler;
    private Composite toolbarMain;
    private Composite buttons;
    protected boolean showSettingsOnAdd;
    private final ProcessSupplierContext processingSupport;
    private Button buttonFinalize;
    private Collection<ProcessEntryContainer> postActions;
    private final TreeViewerColumn[] columns = new TreeViewerColumn[MethodListLabelProvider.TITLES.length];
    private final DataCategory[] dataCategories;
    private final BiFunction<IProcessEntry, ProcessSupplierContext, ProcessorPreferences<?>> preferencesSupplier;
    private final boolean readonly;
    private String[] knownCategories;

    public ExtendedMethodUI(Composite parent, int style, ProcessSupplierContext processingSupport, DataCategory[] dataCategories) {
        this(parent, style, processingSupport, (entry, context) -> entry.getPreferences(context), dataCategories);
    }

    public ExtendedMethodUI(Composite parent, int style, ProcessSupplierContext processingSupport, BiFunction<IProcessEntry, ProcessSupplierContext, ProcessorPreferences<?>> preferencesSupplier, DataCategory[] dataCategories) {
        super(parent, style);
        this.readonly = (style & 8) != 0;
        this.processingSupport = processingSupport;
        this.preferencesSupplier = preferencesSupplier;
        this.dataCategories = dataCategories;
        this.createControl();
    }

    public void setProcessMethod(IProcessMethod processMethod) {
        this.setInputs(processMethod, Collections.emptyList());
    }

    public void setInputs(IProcessMethod processMethod, Collection<ProcessEntryContainer> postActions) {
        this.postActions = postActions;
        this.processMethod = new ProcessMethod(processMethod);
        this.updateProcessMethod();
    }

    public IProcessMethod getProcessMethod() {
        return this.processMethod;
    }

    public String getMethodName() {
        if (!this.textName.isDisposed()) {
            return this.textName.getText();
        }
        return "";
    }

    public void setModificationHandler(IModificationHandler modificationHandler) {
        this.modificationHandler = modificationHandler;
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(composite);
        this.toolbarHeader = this.createToolbarHeader(composite);
        this.createTable(composite);
        this.buttons = this.createToolbarBottom(composite);
        PartSupport.setCompositeVisibility((Composite)this.toolbarHeader, (boolean)false);
        this.updateTableButtons();
    }

    public void setHeaderToolbarVisible(boolean visible) {
        PartSupport.setCompositeVisibility((Composite)this.toolbarHeader, (boolean)visible);
    }

    public Composite getToolbarMain() {
        return this.toolbarMain;
    }

    private void createToolbarMain(Composite parent) {
        this.toolbarMain = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        this.toolbarMain.setLayoutData((Object)gridData);
        this.toolbarMain.setLayout((Layout)new GridLayout(3, false));
        this.createDataInfoLabel(this.toolbarMain);
        this.createButtonToggleToolbarHeader(this.toolbarMain);
        this.createSettingsButton(this.toolbarMain);
    }

    private void createDataInfoLabel(Composite parent) {
        this.labelDataInfo = new Label(parent, 0);
        this.labelDataInfo.setText("");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.labelDataInfo.setLayoutData((Object)gridData);
    }

    private Button createButtonToggleToolbarHeader(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the header toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/headerdata.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedMethodUI.this.toolbarHeader);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/headerdata.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/headerdata.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createSettingsButton(final Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferencePage[] preferencePages = ExtendedMethodUI.this.getConfig().getPreferencePages();
                PreferenceManager preferenceManager = new PreferenceManager();
                int i = 0;
                while (i < preferencePages.length) {
                    preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(String.valueOf(i + 1), preferencePages[i]));
                    ++i;
                }
                PreferenceDialog preferenceDialog = new PreferenceDialog(parent.getShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedMethodUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        this.setDirty(true);
    }

    private Text createNameSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Name:");
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("The name of this method that is used for display");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExtendedMethodUI.this.processMethod != null) {
                    ExtendedMethodUI.this.processMethod.setName(text.getText().trim());
                    ExtendedMethodUI.this.setDirty(true);
                }
            }
        });
        return text;
    }

    private Text createCategorySection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Category:");
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("The category groups similar methods under a common name");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExtendedMethodUI.this.processMethod != null) {
                    ExtendedMethodUI.this.processMethod.setCategory(text.getText().trim());
                    ExtendedMethodUI.this.setDirty(true);
                }
            }
        });
        ControlBuilder.autoComplete((Text)text, (IContentProposalProvider)new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
                if (contents != null) {
                    String[] items;
                    String[] stringArray = items = this.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (item.toLowerCase().contains(contents.toLowerCase())) {
                            list.add(new ContentProposal(item));
                        }
                        ++n2;
                    }
                }
                return list.toArray(new IContentProposal[0]);
            }

            private String[] getItems() {
                if (ExtendedMethodUI.this.knownCategories == null) {
                    final TreeSet categories = new TreeSet();
                    ExtendedMethodUI.this.processingSupport.visitSupplier(new Consumer<IProcessSupplier<?>>(){

                        @Override
                        public void accept(IProcessSupplier<?> supplier) {
                            String category = supplier.getCategory();
                            if (category != null && !category.isEmpty()) {
                                categories.add(category);
                            }
                        }
                    });
                    ExtendedMethodUI.this.knownCategories = categories.toArray(new String[0]);
                }
                return ExtendedMethodUI.this.knownCategories;
            }
        });
        return text;
    }

    private Text createOperatorSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Operator:");
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("The operator is the person who has created / currently manages this method");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExtendedMethodUI.this.processMethod != null) {
                    ExtendedMethodUI.this.processMethod.setOperator(text.getText().trim());
                    ExtendedMethodUI.this.setDirty(true);
                }
            }
        });
        return text;
    }

    private Text createDescriptionSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Description:");
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Description");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExtendedMethodUI.this.processMethod != null) {
                    ExtendedMethodUI.this.processMethod.setDescription(text.getText().trim());
                    ExtendedMethodUI.this.setDirty(true);
                }
            }
        });
        return text;
    }

    private Composite createToolbarHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.textName = this.createNameSection(composite);
        this.textOperator = this.createOperatorSection(composite);
        this.textDescription = this.createDescriptionSection(composite);
        this.textCategory = this.createCategorySection(composite);
        this.buttonFinalize = this.createFinalize(composite);
        return composite;
    }

    private Button createFinalize(final Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Finalized:");
        final Button button = new Button(parent, 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Finalize Process Method", (String)"Finalize a method prevents further modifications to this method, are you sure?")) {
                    ExtendedMethodUI.this.updateProcessMethod();
                } else {
                    button.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    private void createTable(Composite parent) {
        final TreeViewer treeViewer = ControlBuilder.createTreeTable((Composite)parent, (boolean)false);
        int i = 0;
        while (i < MethodListLabelProvider.TITLES.length) {
            this.columns[i] = ControlBuilder.createColumn((TreeViewer)treeViewer, (String)MethodListLabelProvider.TITLES[i], (int)MethodListLabelProvider.BOUNDS[i], null);
            ++i;
        }
        treeViewer.setLabelProvider((IBaseLabelProvider)new MethodListLabelProvider(this.processingSupport, this.preferencesSupplier));
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof IProcessEntry) {
                    IProcessEntry entry = (IProcessEntry)element;
                    IProcessSupplier supplier = ExtendedMethodUI.this.processingSupport.getSupplier(entry.getProcessorId());
                    if (supplier instanceof ProcessEntryContainer) {
                        return ((ProcessEntryContainer)supplier).getNumberOfEntries() > 0;
                    }
                }
                if (element instanceof ProcessEntryContainer) {
                    return ((ProcessEntryContainer)element).getNumberOfEntries() > 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof IProcessEntry) {
                    return ((IProcessEntry)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ProcessEntryContainer) {
                    ProcessEntryContainer container = (ProcessEntryContainer)inputElement;
                    return this.entryList((Iterable<? extends IProcessEntry>)container, false);
                }
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            private Object[] entryList(Iterable<? extends IProcessEntry> iterable, boolean detatch) {
                final ArrayList list = new ArrayList();
                if (detatch) {
                    iterable.forEach((Consumer<? extends IProcessEntry>)new Consumer<IProcessEntry>(){

                        @Override
                        public void accept(IProcessEntry entry) {
                            list.add(new ProcessEntry(entry, null));
                        }
                    });
                } else {
                    iterable.forEach(list::add);
                }
                return list.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IProcessEntry) {
                    IProcessEntry entry = (IProcessEntry)parentElement;
                    IProcessSupplier supplier = ExtendedMethodUI.this.processingSupport.getSupplier(entry.getProcessorId());
                    if (supplier instanceof ProcessEntryContainer) {
                        return this.entryList((Iterable<? extends IProcessEntry>)((ProcessEntryContainer)supplier), true);
                    }
                }
                if (parentElement instanceof ProcessEntryContainer) {
                    return this.entryList((Iterable<? extends IProcessEntry>)((ProcessEntryContainer)parentElement), false);
                }
                return new Object[0];
            }
        });
        treeViewer.getTree();
        treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        treeViewer.addSelectionChangedListener(event -> this.updateTableButtons());
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ExtendedMethodUI.this.preferencesSupplier == null) {
                    return;
                }
                Object firstElement = treeViewer.getStructuredSelection().getFirstElement();
                if (firstElement instanceof IProcessEntry) {
                    IProcessEntry entry = (IProcessEntry)firstElement;
                    if (ExtendedMethodUI.this.modifyProcessEntry(treeViewer.getControl().getShell(), entry, IProcessEntry.getContext((IProcessEntry)entry, (ProcessSupplierContext)ExtendedMethodUI.this.processingSupport), true)) {
                        ExtendedMethodUI.this.updateProcessMethod();
                    }
                }
            }
        });
        this.listUI = treeViewer;
    }

    private ToolBar createToolbarBottom(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        toolBar.setLayoutData((Object)gridData);
        this.buttonAdd = this.createAddButton(toolBar);
        this.buttonRemove = this.createRemoveButton(toolBar);
        this.buttonCopy = this.createCopyButton(toolBar);
        this.buttonMoveUp = this.createMoveUpButton(toolBar);
        this.buttonMoveDown = this.createMoveDownButton(toolBar);
        this.buttonModifySettings = this.createModifySettingsButton(toolBar);
        return toolBar;
    }

    private ToolItem createAddButton(final ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 4);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        item.setToolTipText("Add a process method.");
        final Menu menu = new Menu((Decorations)toolBar.getShell(), 8);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
            }
        });
        item.addListener(13, event -> {
            if (event.detail == 4) {
                Rectangle rect = item.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.dispose();
                    ++n2;
                }
                Collection userMethods = MethodConverter.getUserMethods();
                for (final IProcessMethod method : userMethods) {
                    MenuItem menuItem = new MenuItem(menu, 0);
                    menuItem.setText(method.getName());
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            ExtendedMethodUI.this.loadMethodFile(method);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
                if (!userMethods.isEmpty()) {
                    new MenuItem(menu, 2);
                }
                MenuItem loadItem = new MenuItem(menu, 0);
                loadItem.setText("Load from file...");
                loadItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog fileDialog = new FileDialog(toolBar.getShell(), 4096);
                        fileDialog.setText("Select Process Method file");
                        fileDialog.setFileName("ProcessMethod.ocm");
                        fileDialog.setFilterExtensions(MethodConverter.DEFAULT_METHOD_FILE_EXTENSIONS);
                        fileDialog.setFilterNames(MethodConverter.DEFAULT_METHOD_FILE_NAMES);
                        String filePath = fileDialog.open();
                        if (filePath != null) {
                            File file = new File(filePath);
                            ExtendedMethodUI.this.loadMethodFile((IProcessMethod)Adapters.adapt((Object)file, IProcessMethod.class));
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            } else if (this.processMethod != null) {
                String id;
                IProcessSupplier supplier;
                LinkedHashMap<ProcessSupplierContext, String> contextList = new LinkedHashMap<ProcessSupplierContext, String>();
                Object element = this.listUI.getStructuredSelection().getFirstElement();
                ProcessEntry selectedEntry = null;
                if (element instanceof ProcessEntry && (supplier = this.processingSupport.getSupplier(id = (selectedEntry = (ProcessEntry)element).getProcessorId())) instanceof ProcessSupplierContext) {
                    contextList.put((ProcessSupplierContext)supplier, supplier.getName());
                }
                contextList.put(this.processingSupport, this.processMethod.getName());
                Map<ProcessSupplierContext, IProcessEntry> map = ProcessingWizard.open(this.getShell(), contextList, this.dataCategories);
                if (map != null) {
                    for (Map.Entry<ProcessSupplierContext, IProcessEntry> entry : map.entrySet()) {
                        ProcessSupplierContext supplierContext = entry.getKey();
                        IProcessEntry editedEntry = entry.getValue();
                        boolean edit = this.modifyProcessEntry(this.getShell(), editedEntry, supplierContext, false);
                        if (!edit) continue;
                        IProcessEntry newEntry = supplierContext == this.processingSupport ? this.processMethod.addProcessEntry(editedEntry) : selectedEntry.addProcessEntry(editedEntry);
                        this.updateProcessMethod();
                        this.select(Collections.singletonList(newEntry));
                    }
                }
            }
        });
        return item;
    }

    public void loadMethodFile(IProcessMethod method) {
        if (method != null) {
            ArrayList copied = new ArrayList();
            method.forEach(entry -> copied.add(this.processMethod.addProcessEntry(entry)));
            this.updateProcessMethod();
            this.select(copied);
        }
    }

    private void select(Iterable<? extends IProcessEntry> entries) {
        ArrayList list = new ArrayList();
        entries.forEach(list::add);
        StructuredSelection structuredSelection = new StructuredSelection(list);
        this.listUI.setSelection((ISelection)structuredSelection);
        Object firstElement = structuredSelection.getFirstElement();
        if (firstElement != null) {
            this.listUI.reveal(firstElement);
        }
    }

    private ToolItem createCopyButton(ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/copy.png", "16x16"));
        item.setToolTipText("Copy a process method.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object object : ExtendedMethodUI.this.listUI.getStructuredSelection()) {
                    List entries;
                    int index;
                    ListProcessEntryContainer container = MethodSupport.getContainer(object);
                    if (container == null || (index = (entries = container.getEntries()).indexOf(object)) <= -1) continue;
                    IProcessEntry processEntry = (IProcessEntry)entries.get(index);
                    ProcessEntry processEntryCopy = new ProcessEntry(processEntry, (ProcessEntryContainer)container);
                    entries.add(index, processEntryCopy);
                }
                ExtendedMethodUI.this.updateProcessMethod();
            }
        });
        return item;
    }

    private ToolItem createRemoveButton(final ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        item.setToolTipText("Remove the selected process method(s).");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)toolBar.getShell(), (String)"Delete Process Method(s)", (String)"Would you like to delete the selected processor(s)?")) {
                    Object[] objectArray = ExtendedMethodUI.this.listUI.getStructuredSelection().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ListProcessEntryContainer container = MethodSupport.getContainer(object);
                        if (container != null) {
                            container.removeProcessEntry((IProcessEntry)object);
                        }
                        ++n2;
                    }
                    ExtendedMethodUI.this.updateProcessMethod();
                    ExtendedMethodUI.this.select(Collections.emptyList());
                }
            }
        });
        return item;
    }

    private ToolItem createMoveUpButton(ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_up_2.gif", "16x16"));
        item.setToolTipText("Move the process method(s) up.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = ExtendedMethodUI.this.listUI.getStructuredSelection();
                for (Object object : selection) {
                    List entries;
                    int index;
                    ListProcessEntryContainer container = MethodSupport.getContainer(object);
                    if (container == null || (index = (entries = container.getEntries()).indexOf(object)) <= 0) continue;
                    Collections.swap(entries, index, index - 1);
                }
                ExtendedMethodUI.this.updateProcessMethod();
                ExtendedMethodUI.this.listUI.setSelection((ISelection)selection);
            }
        });
        return item;
    }

    private ToolItem createMoveDownButton(ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_down_2.gif", "16x16"));
        item.setToolTipText("Move the process method(s) down.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = ExtendedMethodUI.this.listUI.getStructuredSelection();
                for (Object object : selection) {
                    List entries;
                    int index;
                    ListProcessEntryContainer container = MethodSupport.getContainer(object);
                    if (container == null || (index = (entries = container.getEntries()).indexOf(object)) <= -1 || index >= entries.size() - 1) continue;
                    Collections.swap(entries, index, index + 1);
                }
                ExtendedMethodUI.this.updateProcessMethod();
                ExtendedMethodUI.this.listUI.setSelection((ISelection)selection);
            }
        });
        return item;
    }

    private ToolItem createModifySettingsButton(final ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        item.setToolTipText("Modify the process method settings.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object;
                if (ExtendedMethodUI.this.processMethod != null && (object = ExtendedMethodUI.this.listUI.getStructuredSelection().getFirstElement()) instanceof IProcessEntry) {
                    IProcessEntry processEntry = (IProcessEntry)object;
                    ExtendedMethodUI.this.modifyProcessEntry(toolBar.getShell(), processEntry, IProcessEntry.getContext((IProcessEntry)processEntry, (ProcessSupplierContext)ExtendedMethodUI.this.processingSupport), true);
                    ExtendedMethodUI.this.updateProcessMethod();
                }
            }
        });
        return item;
    }

    private void updateProcessMethod() {
        if (this.processMethod != null) {
            this.textOperator.setText(this.processMethod.getOperator());
            this.textDescription.setText(this.processMethod.getDescription());
            this.textCategory.setText(this.processMethod.getCategory());
            this.textName.setText(this.processMethod.getName());
            boolean readOnly = this.buttonFinalize.getSelection();
            if (readOnly) {
                this.processMethod.setReadOnly(readOnly);
                this.textOperator.setEnabled(false);
                this.textDescription.setEnabled(false);
                this.textCategory.setEnabled(false);
                this.textName.setEnabled(false);
                this.buttonFinalize.setEnabled(false);
            }
        } else {
            this.textOperator.setText("");
            this.textDescription.setText("");
            this.textCategory.setText("");
            this.textName.setText("");
        }
        boolean expand = false;
        if (this.postActions == null || this.postActions.isEmpty()) {
            this.listUI.setInput((Object)this.processMethod);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.processMethod);
            list.addAll(this.postActions);
            this.listUI.setInput((Object)list.toArray());
            expand = true;
        }
        this.listUI.refresh();
        if (this.listUI instanceof TreeViewer && expand) {
            ((TreeViewer)this.listUI).expandToLevel(1);
        }
        this.updateTableButtons();
        this.setDirty(true);
    }

    private void updateTableButtons() {
        this.buttonAdd.setEnabled(this.processMethod != null && !this.processMethod.isFinal() && !this.readonly);
        IStructuredSelection selection = this.listUI.getStructuredSelection();
        boolean writeable = this.processMethod != null && !this.processMethod.isFinal() && !selection.isEmpty();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext() && writeable) {
            Object object = iterator.next();
            ListProcessEntryContainer container = MethodSupport.getContainer(object);
            if (container != null) continue;
            writeable = false;
        }
        this.buttonCopy.setEnabled(writeable && !this.readonly);
        this.buttonRemove.setEnabled(writeable && !this.readonly);
        this.buttonMoveUp.setEnabled(writeable && !this.readonly);
        this.buttonMoveDown.setEnabled(writeable && !this.readonly);
        this.buttonModifySettings.setEnabled(writeable && this.preferencesSupplier != null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.listUI.getControl().setEnabled(enabled);
        PartSupport.setCompositeVisibility((Composite)this.buttons, (boolean)enabled);
    }

    private void setDirty(boolean dirty) {
        if (this.modificationHandler != null) {
            this.modificationHandler.setDirty(dirty);
        }
    }

    @Override
    public MethodUIConfig getConfig() {
        return new MethodUIConfig(){
            TableConfigSupport support;
            {
                this.support = new TableConfigSupport(Arrays.asList(ExtendedMethodUI.this.columns));
            }

            @Override
            public void setToolbarVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedMethodUI.this.toolbarMain, (boolean)visible);
            }

            @Override
            public boolean isToolbarVisible() {
                return ExtendedMethodUI.this.toolbarMain.isVisible();
            }

            @Override
            public void setVisibleColumns(Set<String> visibleColumns) {
                this.support.setVisibleColumns(visibleColumns);
            }

            @Override
            public Set<String> getColumns() {
                return new HashSet<String>(Arrays.asList(MethodListLabelProvider.TITLES));
            }

            @Override
            public void setShowSettingsOnAdd(boolean showSettingsOnAdd) {
                ExtendedMethodUI.this.showSettingsOnAdd = showSettingsOnAdd;
            }

            @Override
            public IPreferencePage[] getPreferencePages() {
                PreferencePageReportExport preferencePageProcessing = new PreferencePageReportExport();
                preferencePageProcessing.setTitle("Processing");
                return new IPreferencePage[]{preferencePageProcessing};
            }

            @Override
            public void applySettings() {
                ExtendedMethodUI.this.applySettings();
            }

            @Override
            public int getColumWidth(String column) {
                return this.support.getColumWidth(column);
            }

            @Override
            public void setColumWidth(String column, int width) {
                this.support.setColumWidth(column, width);
            }
        };
    }

    private boolean modifyProcessEntry(Shell shell, IProcessEntry processEntry, ProcessSupplierContext supplierContext, boolean showHint) {
        ProcessorPreferences<?> preferences = this.preferencesSupplier.apply(processEntry, supplierContext);
        if (preferences == null) {
            return false;
        }
        if (preferences.getSupplier().getSettingsParser().getInputValues().isEmpty()) {
            if (showHint) {
                MessageDialog.openInformation((Shell)shell, (String)"No Settings avaiable", (String)"This processor does not offer any options");
            }
            return true;
        }
        try {
            return SettingsWizard.openEditPreferencesWizard(shell, preferences);
        }
        catch (IOException e) {
            return false;
        }
    }
}

