/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.util.ArrayList;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.preferences.PreferencePageSWT;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartXIR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageChromatogram;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.chemclipse.xir.model.core.ISignalXIR;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ExtendedXIRScanUI {
    private ChartXIR chartXIR;
    private IScanXIR scanXIR;
    private Label labelDataInfo;
    private boolean showRawData = false;

    public ExtendedXIRScanUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(IScanXIR scanXIR) {
        this.scanXIR = scanXIR;
        if (scanXIR != null) {
            this.showRawData = scanXIR.getProcessedSignals().size() <= 0;
        }
        this.chartXIR.modifyChart(this.showRawData);
        this.updateScan();
    }

    private void updateScan() {
        String dataInfo;
        this.chartXIR.deleteSeries();
        String string = dataInfo = this.showRawData ? "Raw Data" : "Processed Data";
        if (this.scanXIR != null) {
            dataInfo = String.valueOf(dataInfo) + " | Rotation Angle: " + this.scanXIR.getRotationAngle() + "\u00b0";
            ArrayList<LineSeriesData> lineSeriesDataList = new ArrayList<LineSeriesData>();
            if (this.showRawData) {
                LineSeriesData lineSeriesData = new LineSeriesData(this.getSeriesData(this.scanXIR, "Raw Signals", true));
                ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                lineSeriesSettings.setLineColor(Colors.RED);
                lineSeriesSettings.setEnableArea(false);
                lineSeriesDataList.add(lineSeriesData);
                lineSeriesData = new LineSeriesData(this.getSeriesData(this.scanXIR, "Background Signals", false));
                lineSeriesSettings = lineSeriesData.getSettings();
                lineSeriesSettings.setLineColor(Colors.BLACK);
                lineSeriesSettings.setEnableArea(false);
                lineSeriesDataList.add(lineSeriesData);
            } else {
                LineSeriesData lineSeriesData = new LineSeriesData(this.getSeriesDataProcessed(this.scanXIR, "Processed Data"));
                ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                lineSeriesSettings.setLineColor(Colors.RED);
                lineSeriesSettings.setEnableArea(false);
                lineSeriesDataList.add(lineSeriesData);
            }
            this.chartXIR.addSeriesData(lineSeriesDataList);
        }
        this.labelDataInfo.setText(dataInfo);
    }

    private ISeriesData getSeriesDataProcessed(IScanXIR scanXIR, String id) {
        double[] ySeries;
        double[] xSeries;
        if (scanXIR != null) {
            int size = scanXIR.getProcessedSignals().size();
            xSeries = new double[size];
            ySeries = new double[size];
            int index = 0;
            for (ISignalXIR scanSignal : scanXIR.getProcessedSignals()) {
                xSeries[index] = scanSignal.getWavelength();
                ySeries[index] = scanSignal.getIntensity();
                ++index;
            }
        } else {
            xSeries = new double[]{};
            ySeries = new double[]{};
        }
        return new SeriesData(xSeries, ySeries, id);
    }

    private ISeriesData getSeriesData(IScanXIR scanXIR, String id, boolean raw) {
        double[] ySeries = scanXIR != null ? (raw ? (double[])scanXIR.getRawSignals().clone() : (double[])scanXIR.getBackgroundSignals().clone()) : new double[]{};
        return new SeriesData(ySeries, id);
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.createScanChart(parent);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.createDataInfoLabel(composite);
        this.createRawProcessedButton(composite);
        this.createToggleChartSeriesLegendButton(composite);
        this.createToggleLegendMarkerButton(composite);
        this.createToggleRangeSelectorButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private void createDataInfoLabel(Composite parent) {
        this.labelDataInfo = new Label(parent, 0);
        this.labelDataInfo.setText("");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.labelDataInfo.setLayoutData((Object)gridData);
    }

    private void createRawProcessedButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the raw/processed modus");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/scan-xir.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedXIRScanUI.this.showRawData = !ExtendedXIRScanUI.this.showRawData;
                ExtendedXIRScanUI.this.chartXIR.modifyChart(ExtendedXIRScanUI.this.showRawData);
                ExtendedXIRScanUI.this.updateScan();
            }
        });
    }

    private void createToggleChartSeriesLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart series legend.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedXIRScanUI.this.chartXIR.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createToggleLegendMarkerButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend marker.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chartLegendMarker.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedXIRScanUI.this.chartXIR.togglePositionLegendVisibility();
                ExtendedXIRScanUI.this.chartXIR.redraw();
            }
        });
    }

    private void createToggleRangeSelectorButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart range selector.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chartRangeSelector.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedXIRScanUI.this.chartXIR.toggleRangeSelectorVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the scan");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedXIRScanUI.this.reset();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageChromatogram preferencePageChromatogram = new PreferencePageChromatogram(Activator.getDefault().getPreferenceStore());
                preferencePageChromatogram.setTitle("Scan Settings ");
                PreferencePageSWT preferencePageSWT = new PreferencePageSWT();
                preferencePageSWT.setTitle("Settings (SWT)");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePageChromatogram));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageSWT));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedXIRScanUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        this.updateScan();
    }

    private void reset() {
        this.updateScan();
    }

    private void createScanChart(Composite parent) {
        this.chartXIR = new ChartXIR(parent, 2048);
        this.chartXIR.setLayoutData(new GridData(1808));
        IChartSettings chartSettings = this.chartXIR.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableRangeSelector(true);
        chartSettings.setShowRangeSelectorInitially(false);
        this.chartXIR.applySettings(chartSettings);
    }
}

