/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import java.util.Objects;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignal;

public class ExtractedSingleWavelengthSignal
implements IExtractedSingleWavelengthSignal {
    private static final Logger logger = Logger.getLogger(ExtractedSingleWavelengthSignal.class);
    private float abundanceValue;
    private double wavelength;
    private int retentionTime;
    private float retentionIndex;

    public ExtractedSingleWavelengthSignal(double wavelength, float abundanceValue, int retentionTime, float retentionIndex) {
        this.wavelength = wavelength;
        this.abundanceValue = abundanceValue;
        this.retentionTime = retentionTime;
        this.retentionIndex = retentionIndex;
    }

    private ExtractedSingleWavelengthSignal() {
    }

    public ExtractedSingleWavelengthSignal(IScanSignalWSD scanSignalWSD, int retentionTime, float retentionIndex) {
        this(scanSignalWSD.getWavelength(), scanSignalWSD.getAbundance(), retentionTime, retentionIndex);
    }

    public void setTotalSignal(float abundance) {
        this.abundanceValue = abundance;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int retentionTime) {
        if (retentionTime >= 0) {
            this.retentionTime = retentionTime;
        }
    }

    public float getRetentionIndex() {
        return this.retentionIndex;
    }

    public void setRetentionIndex(float retentionIndex) {
        if (retentionIndex >= 0.0f) {
            this.retentionIndex = retentionIndex;
        }
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ExtractedSingleWavelengthSignal extractedWavelengthSignal = (ExtractedSingleWavelengthSignal)otherObject;
        return this.wavelength == extractedWavelengthSignal.wavelength && this.abundanceValue == extractedWavelengthSignal.abundanceValue && this.retentionTime == extractedWavelengthSignal.retentionTime && this.retentionIndex == extractedWavelengthSignal.retentionIndex;
    }

    public int hashCode() {
        return Objects.hash(this.wavelength, Float.valueOf(this.abundanceValue), this.retentionTime, Float.valueOf(this.retentionIndex));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("wavelength=" + this.wavelength);
        builder.append(",");
        builder.append("abundanceValue=" + this.abundanceValue);
        builder.append(",");
        builder.append("retentionTime=" + this.retentionTime);
        builder.append(",");
        builder.append("retentionIndex=" + this.retentionIndex);
        builder.append("]");
        return builder.toString();
    }

    public float getTotalSignal() {
        return this.abundanceValue;
    }

    @Override
    public double getWavelength() {
        return this.wavelength;
    }

    public void setTotalSignal(float totalSignal, boolean validatePositive) {
        if (validatePositive && totalSignal < 0.0f) {
            return;
        }
        this.setTotalSignal(totalSignal);
    }

    @Override
    public IExtractedSingleWavelengthSignal makeDeepCopy() {
        ExtractedSingleWavelengthSignal extractedSingleWavelengthSignal = new ExtractedSingleWavelengthSignal();
        extractedSingleWavelengthSignal.abundanceValue = this.abundanceValue;
        extractedSingleWavelengthSignal.wavelength = this.wavelength;
        extractedSingleWavelengthSignal.retentionTime = this.retentionTime;
        extractedSingleWavelengthSignal.retentionIndex = this.retentionIndex;
        return extractedSingleWavelengthSignal;
    }
}

