/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.theme;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfigAttributes;
import org.eclipse.nebula.widgets.nattable.freeze.IFreezeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.theme.IThemeExtension;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.swt.graphics.Color;

public abstract class ThemeConfiguration
extends AbstractRegistryConfiguration {
    protected boolean styleCornerLikeColumnHeader = false;
    protected final List<IThemeExtension> extensions = new ArrayList<IThemeExtension>();

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        this.configureDefaultStyle(configRegistry);
        this.configureColumnHeaderStyle(configRegistry);
        this.configureRowHeaderStyle(configRegistry);
        this.configureCornerStyle(configRegistry);
        this.configureHoverStyle(configRegistry);
        this.configureHoverSelectionStyle(configRegistry);
        this.configureDefaultSelectionStyle(configRegistry);
        this.configureColumnHeaderSelectionStyle(configRegistry);
        this.configureRowHeaderSelectionStyle(configRegistry);
        this.configureCornerSelectionStyle(configRegistry);
        this.configureSelectionAnchorStyle(configRegistry);
        this.configureAlternatingRowStyle(configRegistry);
        this.configureColumnGroupHeaderStyle(configRegistry);
        this.configureRowGroupHeaderStyle(configRegistry);
        this.configureSortHeaderStyle(configRegistry);
        this.configureSelectedSortHeaderStyle(configRegistry);
        this.configureFilterRowStyle(configRegistry);
        this.configureTreeStyle(configRegistry);
        this.configureFreezeStyle(configRegistry);
        this.configureGridLineStyle(configRegistry);
        this.configureSummaryRowStyle(configRegistry);
        this.configureEditErrorStyle(configRegistry);
        this.configureFillHandleStyle(configRegistry);
        this.configureCopyBorderStyle(configRegistry);
        for (IThemeExtension extension : this.extensions) {
            extension.registerStyles(configRegistry);
        }
    }

    protected void configureDefaultStyle(IConfigRegistry configRegistry) {
        ICellPainter defaultPainter;
        IStyle defaultStyle = this.getDefaultCellStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultStyle);
        }
        if ((defaultPainter = this.getDefaultCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultPainter);
        }
    }

    protected abstract IStyle getDefaultCellStyle();

    protected abstract ICellPainter getDefaultCellPainter();

    protected void configureColumnHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter columnHeaderCellPainter;
        IStyle columnHeaderStyle = this.getColumnHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderStyle, "NORMAL", "COLUMN_HEADER");
        }
        if ((columnHeaderCellPainter = this.getColumnHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderCellPainter, "NORMAL", "COLUMN_HEADER");
        }
    }

    protected abstract IStyle getColumnHeaderStyle();

    protected abstract ICellPainter getColumnHeaderCellPainter();

    protected void configureRowHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter rowHeaderCellPainter;
        IStyle rowHeaderStyle = this.getRowHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderStyle, "NORMAL", "ROW_HEADER");
        }
        if ((rowHeaderCellPainter = this.getRowHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderCellPainter, "NORMAL", "ROW_HEADER");
        }
    }

    protected abstract IStyle getRowHeaderStyle();

    protected abstract ICellPainter getRowHeaderCellPainter();

    protected void configureCornerStyle(IConfigRegistry configRegistry) {
        ICellPainter cornerCellPainter;
        IStyle cornerStyle;
        IStyle iStyle = cornerStyle = this.styleCornerLikeColumnHeader ? this.getColumnHeaderStyle() : this.getCornerStyle();
        if (!ThemeConfiguration.isStyleEmpty(cornerStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cornerStyle, "NORMAL", "CORNER");
        }
        ICellPainter iCellPainter = cornerCellPainter = this.styleCornerLikeColumnHeader ? this.getColumnHeaderCellPainter() : this.getCornerCellPainter();
        if (cornerCellPainter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cornerCellPainter, "NORMAL", "CORNER");
        }
    }

    protected abstract IStyle getCornerStyle();

    protected abstract ICellPainter getCornerCellPainter();

    protected void configureHoverStyle(IConfigRegistry configRegistry) {
        ICellPainter rowHeaderHoverCellPainter;
        IStyle rowHeaderHoverStyle;
        ICellPainter columnHeaderHoverCellPainter;
        IStyle columnHeaderHoverStyle;
        ICellPainter bodyHoverCellPainter;
        IStyle bodyHoverStyle;
        ICellPainter defaultHoverCellPainter;
        IStyle defaultHoverStyle = this.getDefaultHoverStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultHoverStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultHoverStyle, "HOVER");
        }
        if ((defaultHoverCellPainter = this.getDefaultHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultHoverCellPainter, "HOVER");
        }
        if (!ThemeConfiguration.isStyleEmpty(bodyHoverStyle = this.getBodyHoverStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, bodyHoverStyle, "HOVER", "BODY");
        }
        if ((bodyHoverCellPainter = this.getBodyHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, bodyHoverCellPainter, "HOVER", "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderHoverStyle = this.getColumnHeaderHoverStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderHoverStyle, "HOVER", "COLUMN_HEADER");
        }
        if ((columnHeaderHoverCellPainter = this.getColumnHeaderHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderHoverCellPainter, "HOVER", "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderHoverStyle = this.getRowHeaderHoverStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderHoverStyle, "HOVER", "ROW_HEADER");
        }
        if ((rowHeaderHoverCellPainter = this.getRowHeaderHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderHoverCellPainter, "HOVER", "ROW_HEADER");
        }
    }

    protected abstract IStyle getDefaultHoverStyle();

    protected abstract ICellPainter getDefaultHoverCellPainter();

    protected abstract IStyle getBodyHoverStyle();

    protected abstract ICellPainter getBodyHoverCellPainter();

    protected abstract IStyle getColumnHeaderHoverStyle();

    protected abstract ICellPainter getColumnHeaderHoverCellPainter();

    protected abstract IStyle getRowHeaderHoverStyle();

    protected abstract ICellPainter getRowHeaderHoverCellPainter();

    protected void configureHoverSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter rowHeaderHoverCellPainter;
        IStyle rowHeaderHoverStyle;
        ICellPainter columnHeaderHoverCellPainter;
        IStyle columnHeaderHoverStyle;
        ICellPainter bodyHoverCellPainter;
        IStyle bodyHoverStyle;
        ICellPainter defaultHoverCellPainter;
        IStyle defaultHoverStyle = this.getDefaultHoverSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultHoverStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultHoverStyle, "SELECT_HOVER");
        }
        if ((defaultHoverCellPainter = this.getDefaultHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultHoverCellPainter, "SELECT_HOVER");
        }
        if (!ThemeConfiguration.isStyleEmpty(bodyHoverStyle = this.getBodyHoverSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, bodyHoverStyle, "SELECT_HOVER", "BODY");
        }
        if ((bodyHoverCellPainter = this.getBodyHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, bodyHoverCellPainter, "SELECT_HOVER", "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderHoverStyle = this.getColumnHeaderHoverSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderHoverStyle, "SELECT_HOVER", "COLUMN_HEADER");
        }
        if ((columnHeaderHoverCellPainter = this.getColumnHeaderHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderHoverCellPainter, "SELECT_HOVER", "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderHoverStyle = this.getRowHeaderHoverSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderHoverStyle, "SELECT_HOVER", "ROW_HEADER");
        }
        if ((rowHeaderHoverCellPainter = this.getRowHeaderHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderHoverCellPainter, "SELECT_HOVER", "ROW_HEADER");
        }
    }

    protected abstract IStyle getDefaultHoverSelectionStyle();

    protected abstract ICellPainter getDefaultHoverSelectionCellPainter();

    protected abstract IStyle getBodyHoverSelectionStyle();

    protected abstract ICellPainter getBodyHoverSelectionCellPainter();

    protected abstract IStyle getColumnHeaderHoverSelectionStyle();

    protected abstract ICellPainter getColumnHeaderHoverSelectionCellPainter();

    protected abstract IStyle getRowHeaderHoverSelectionStyle();

    protected abstract ICellPainter getRowHeaderHoverSelectionCellPainter();

    protected void configureDefaultSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter defaultSelectionCellPainter;
        IStyle defaultSelectionStyle = this.getDefaultSelectionCellStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultSelectionStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultSelectionStyle, "SELECT");
        }
        if ((defaultSelectionCellPainter = this.getDefaultSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultSelectionCellPainter, "SELECT");
        }
    }

    protected abstract IStyle getDefaultSelectionCellStyle();

    protected abstract ICellPainter getDefaultSelectionCellPainter();

    protected void configureColumnHeaderSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter fullSelectionColumnHeaderCellPainter;
        IStyle fullSelectionColumnHeaderStyle;
        ICellPainter columnHeaderCellPainter;
        IStyle columnHeaderStyle = this.getColumnHeaderSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderStyle, "SELECT", "COLUMN_HEADER");
        }
        if ((columnHeaderCellPainter = this.getColumnHeaderSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderCellPainter, "SELECT", "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(fullSelectionColumnHeaderStyle = this.getColumnHeaderFullSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, fullSelectionColumnHeaderStyle, "SELECT", "COLUMN_HEADER_FULL");
        }
        if ((fullSelectionColumnHeaderCellPainter = this.getColumnHeaderFullSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, fullSelectionColumnHeaderCellPainter, "SELECT", "COLUMN_HEADER_FULL");
        }
    }

    protected abstract IStyle getColumnHeaderSelectionStyle();

    protected abstract ICellPainter getColumnHeaderSelectionCellPainter();

    protected abstract IStyle getColumnHeaderFullSelectionStyle();

    protected abstract ICellPainter getColumnHeaderFullSelectionCellPainter();

    protected void configureRowHeaderSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter fullSelectionRowHeaderCellPainter;
        IStyle fullSelectionRowHeaderStyle;
        ICellPainter rowHeaderCellPainter;
        IStyle rowHeaderStyle = this.getRowHeaderSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderStyle, "SELECT", "ROW_HEADER");
        }
        if ((rowHeaderCellPainter = this.getRowHeaderSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderCellPainter, "SELECT", "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(fullSelectionRowHeaderStyle = this.getRowHeaderFullSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, fullSelectionRowHeaderStyle, "SELECT", "ROW_HEADER_FULL");
        }
        if ((fullSelectionRowHeaderCellPainter = this.getRowHeaderFullSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, fullSelectionRowHeaderCellPainter, "SELECT", "ROW_HEADER_FULL");
        }
    }

    protected abstract IStyle getRowHeaderSelectionStyle();

    protected abstract ICellPainter getRowHeaderSelectionCellPainter();

    protected abstract IStyle getRowHeaderFullSelectionStyle();

    protected abstract ICellPainter getRowHeaderFullSelectionCellPainter();

    protected void configureCornerSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter cornerCellPainter;
        IStyle cornerStyle;
        IStyle iStyle = cornerStyle = this.styleCornerLikeColumnHeader ? this.getColumnHeaderSelectionStyle() : this.getCornerSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(cornerStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cornerStyle, "SELECT", "CORNER");
        }
        ICellPainter iCellPainter = cornerCellPainter = this.styleCornerLikeColumnHeader ? this.getColumnHeaderSelectionCellPainter() : this.getCornerSelectionCellPainter();
        if (cornerCellPainter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cornerCellPainter, "SELECT", "CORNER");
        }
    }

    protected abstract IStyle getCornerSelectionStyle();

    protected abstract ICellPainter getCornerSelectionCellPainter();

    protected void configureSelectionAnchorStyle(IConfigRegistry configRegistry) {
        IStyle gridLineStyle;
        ICellPainter selectionAnchorPainter;
        IStyle selectionAnchorStyle;
        ICellPainter anchorPainter;
        IStyle anchorStyle = this.getSelectionAnchorStyle();
        if (!ThemeConfiguration.isStyleEmpty(anchorStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, anchorStyle, "NORMAL", "selectionAnchor");
        }
        if ((anchorPainter = this.getSelectionAnchorCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, anchorPainter, "NORMAL", "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(selectionAnchorStyle = this.getSelectionAnchorSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, selectionAnchorStyle, "SELECT", "selectionAnchor");
        }
        if ((selectionAnchorPainter = this.getSelectionAnchorSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, selectionAnchorPainter, "SELECT", "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(gridLineStyle = this.getSelectionAnchorGridLineStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, gridLineStyle, "SELECT", "selectionAnchorGridLine");
        }
    }

    protected abstract IStyle getSelectionAnchorStyle();

    protected abstract ICellPainter getSelectionAnchorCellPainter();

    protected abstract IStyle getSelectionAnchorSelectionStyle();

    protected abstract ICellPainter getSelectionAnchorSelectionCellPainter();

    protected abstract IStyle getSelectionAnchorGridLineStyle();

    protected void configureAlternatingRowStyle(IConfigRegistry configRegistry) {
        ICellPainter oddCellPainter;
        IStyle oddStyle;
        ICellPainter evenCellPainter;
        IStyle evenStyle = this.getEvenRowStyle();
        if (!ThemeConfiguration.isStyleEmpty(evenStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, evenStyle, "NORMAL", "EVEN_BODY");
        }
        if ((evenCellPainter = this.getEvenRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, evenCellPainter, "NORMAL", "EVEN_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(oddStyle = this.getOddRowStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, oddStyle, "NORMAL", "ODD_BODY");
        }
        if ((oddCellPainter = this.getOddRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, oddCellPainter, "NORMAL", "ODD_BODY");
        }
    }

    protected abstract IStyle getEvenRowStyle();

    protected abstract ICellPainter getEvenRowCellPainter();

    protected abstract IStyle getOddRowStyle();

    protected abstract ICellPainter getOddRowCellPainter();

    protected void configureColumnGroupHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter columnGroupHeaderCellPainter;
        IStyle columnGroupHeaderStyle = this.getColumnGroupHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(columnGroupHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnGroupHeaderStyle, "NORMAL", "COLUMN_GROUP_HEADER");
        }
        if ((columnGroupHeaderCellPainter = this.getColumnGroupHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnGroupHeaderCellPainter, "NORMAL", "COLUMN_GROUP_HEADER");
        }
    }

    protected abstract IStyle getColumnGroupHeaderStyle();

    protected abstract ICellPainter getColumnGroupHeaderCellPainter();

    protected void configureRowGroupHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter rowGroupHeaderCellPainter;
        IStyle rowGroupHeaderStyle = this.getRowGroupHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(rowGroupHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowGroupHeaderStyle, "NORMAL", "ROW_GROUP_HEADER");
        }
        if ((rowGroupHeaderCellPainter = this.getRowGroupHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowGroupHeaderCellPainter, "NORMAL", "ROW_GROUP_HEADER");
        }
    }

    protected abstract IStyle getRowGroupHeaderStyle();

    protected abstract ICellPainter getRowGroupHeaderCellPainter();

    protected void configureSortHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle sortStyle = this.getSortHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(sortStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, "NORMAL", "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, "NORMAL", "SORT_UP");
        }
        if ((cellPainter = this.getSortHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "NORMAL", "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "NORMAL", "SORT_UP");
        }
    }

    protected abstract IStyle getSortHeaderStyle();

    protected abstract ICellPainter getSortHeaderCellPainter();

    protected void configureSelectedSortHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle sortStyle = this.getSelectedSortHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(sortStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, "SELECT", "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, "SELECT", "SORT_UP");
        }
        if ((cellPainter = this.getSelectedSortHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "SELECT", "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "SELECT", "SORT_UP");
        }
    }

    protected abstract IStyle getSelectedSortHeaderStyle();

    protected abstract ICellPainter getSelectedSortHeaderCellPainter();

    protected void configureFilterRowStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle filterRowStyle = this.getFilterRowStyle();
        if (!ThemeConfiguration.isStyleEmpty(filterRowStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, filterRowStyle, "NORMAL", "FILTER_ROW");
        }
        if ((cellPainter = this.getFilterRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "NORMAL", "FILTER_ROW");
        }
    }

    protected abstract IStyle getFilterRowStyle();

    protected abstract ICellPainter getFilterRowCellPainter();

    protected void configureTreeStyle(IConfigRegistry configRegistry) {
        ICellPainter treeSelectionPainter;
        ICellPainter treePainter;
        ICellPainter selectionCellPainter;
        IStyle treeSelectionStyle;
        ICellPainter cellPainter;
        IStyle treeStyle = this.getTreeStyle();
        if (!ThemeConfiguration.isStyleEmpty(treeStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, treeStyle, "NORMAL", "TREE_COLUMN_CELL");
        }
        if ((cellPainter = this.getTreeCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "NORMAL", "TREE_COLUMN_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(treeSelectionStyle = this.getTreeSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, treeSelectionStyle, "SELECT", "TREE_COLUMN_CELL");
        }
        if ((selectionCellPainter = this.getTreeSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, selectionCellPainter, "SELECT", "TREE_COLUMN_CELL");
        }
        if ((treePainter = this.getTreeStructurePainter()) != null) {
            configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, treePainter, "NORMAL");
        }
        if ((treeSelectionPainter = this.getTreeStructureSelectionPainter()) != null) {
            configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, treeSelectionPainter, "SELECT");
        }
    }

    protected abstract IStyle getTreeStyle();

    protected abstract ICellPainter getTreeCellPainter();

    protected abstract IStyle getTreeSelectionStyle();

    protected abstract ICellPainter getTreeSelectionCellPainter();

    protected abstract ICellPainter getTreeStructurePainter();

    protected abstract ICellPainter getTreeStructureSelectionPainter();

    protected void configureSummaryRowStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle style = this.getSummaryRowStyle();
        if (!ThemeConfiguration.isStyleEmpty(style)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, style, "NORMAL", "SummaryRow");
        }
        if ((cellPainter = this.getSummaryRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "NORMAL", "SummaryRow");
        }
        if (!ThemeConfiguration.isStyleEmpty(style = this.getSummaryRowSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, style, "SELECT", "SummaryRow");
        }
        if ((cellPainter = this.getSummaryRowSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "SELECT", "SummaryRow");
        }
    }

    protected abstract IStyle getSummaryRowStyle();

    protected abstract ICellPainter getSummaryRowCellPainter();

    protected abstract IStyle getSummaryRowSelectionStyle();

    protected abstract ICellPainter getSummaryRowSelectionCellPainter();

    protected void configureFreezeStyle(IConfigRegistry configRegistry) {
        if (this.getFreezeSeparatorColor() != null) {
            configRegistry.registerConfigAttribute(IFreezeConfigAttributes.SEPARATOR_COLOR, this.getFreezeSeparatorColor());
        }
    }

    protected abstract Color getFreezeSeparatorColor();

    protected void configureGridLineStyle(IConfigRegistry configRegistry) {
        if (this.getGridLineColor() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR, this.getGridLineColor());
        }
        if (this.getRenderColumnHeaderGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderColumnHeaderGridLines(), "NORMAL", "COLUMN_HEADER");
        }
        if (this.getRenderCornerGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderCornerGridLines(), "NORMAL", "CORNER");
        }
        if (this.getRenderRowHeaderGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderRowHeaderGridLines(), "NORMAL", "ROW_HEADER");
        }
        if (this.getRenderBodyGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderBodyGridLines(), "NORMAL", "BODY");
        }
        if (this.getRenderFilterRowGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderFilterRowGridLines(), "NORMAL", "FILTER_ROW");
        }
    }

    protected abstract Color getGridLineColor();

    protected abstract Boolean getRenderColumnHeaderGridLines();

    protected abstract Boolean getRenderCornerGridLines();

    protected abstract Boolean getRenderRowHeaderGridLines();

    protected abstract Boolean getRenderBodyGridLines();

    protected abstract Boolean getRenderFilterRowGridLines();

    protected void configureEditErrorStyle(IConfigRegistry configRegistry) {
        if (!ThemeConfiguration.isStyleEmpty(this.getConversionErrorStyle())) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, this.getConversionErrorStyle(), "EDIT");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getValidationErrorStyle())) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, this.getValidationErrorStyle(), "EDIT");
        }
    }

    protected abstract IStyle getConversionErrorStyle();

    protected abstract IStyle getValidationErrorStyle();

    protected void configureFillHandleStyle(IConfigRegistry configRegistry) {
        BorderStyle fillHandleRegionBorderStyle;
        BorderStyle fillHandleBorderStyle;
        Color fillHandleColor = this.getFillHandleColor();
        if (fillHandleColor != null) {
            configRegistry.registerConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_COLOR, fillHandleColor, "NORMAL");
        }
        if ((fillHandleBorderStyle = this.getFillHandleBorderStyle()) != null) {
            configRegistry.registerConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_BORDER_STYLE, fillHandleBorderStyle, "NORMAL");
        }
        if ((fillHandleRegionBorderStyle = this.getFillHandleRegionBorderStyle()) != null) {
            configRegistry.registerConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_REGION_BORDER_STYLE, fillHandleRegionBorderStyle, "NORMAL");
        }
    }

    protected Color getFillHandleColor() {
        return null;
    }

    protected BorderStyle getFillHandleBorderStyle() {
        return null;
    }

    protected BorderStyle getFillHandleRegionBorderStyle() {
        return null;
    }

    protected void configureCopyBorderStyle(IConfigRegistry configRegistry) {
        IStyle copyBorderStyle = this.getCopyBorderStyle();
        if (!ThemeConfiguration.isStyleEmpty(copyBorderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, copyBorderStyle, "NORMAL", "copyBorderStyle");
        }
    }

    protected IStyle getCopyBorderStyle() {
        return null;
    }

    public static boolean isStyleEmpty(IStyle style) {
        if (style == null) {
            return true;
        }
        return style.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT) == null && style.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT) == null && style.getAttributeValue(CellStyleAttributes.FONT) == null && style.getAttributeValue(CellStyleAttributes.IMAGE) == null && style.getAttributeValue(CellStyleAttributes.BORDER_STYLE) == null && style.getAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR) == null && style.getAttributeValue(CellStyleAttributes.TEXT_DECORATION) == null;
    }

    public void unregisterThemeStyleConfigurations(IConfigRegistry configRegistry) {
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultCellStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE);
        }
        if (this.getDefaultCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultSelectionCellStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT");
        }
        if (this.getDefaultSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "COLUMN_HEADER");
        }
        if (this.getColumnHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "COLUMN_HEADER");
        }
        if (this.getColumnHeaderSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderFullSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "COLUMN_HEADER_FULL");
        }
        if (this.getColumnHeaderFullSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "COLUMN_HEADER_FULL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "ROW_HEADER");
        }
        if (this.getRowHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "ROW_HEADER");
        }
        if (this.getRowHeaderSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderFullSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "ROW_HEADER_FULL");
        }
        if (this.getRowHeaderFullSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "ROW_HEADER_FULL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getCornerStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "CORNER");
        }
        if (this.getCornerCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "CORNER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getCornerSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "CORNER");
        }
        if (this.getCornerSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "CORNER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "HOVER");
        }
        if (this.getDefaultHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "HOVER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getBodyHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "HOVER", "BODY");
        }
        if (this.getBodyHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "HOVER", "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "HOVER", "COLUMN_HEADER");
        }
        if (this.getColumnHeaderHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "HOVER", "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "HOVER", "ROW_HEADER");
        }
        if (this.getRowHeaderHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "HOVER", "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT_HOVER");
        }
        if (this.getDefaultHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT_HOVER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getBodyHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT_HOVER", "BODY");
        }
        if (this.getBodyHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT_HOVER", "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT_HOVER", "COLUMN_HEADER");
        }
        if (this.getColumnHeaderHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT_HOVER", "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT_HOVER", "ROW_HEADER");
        }
        if (this.getRowHeaderHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT_HOVER", "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectionAnchorStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "selectionAnchor");
        }
        if (this.getSelectionAnchorCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectionAnchorSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "selectionAnchor");
        }
        if (this.getSelectionAnchorSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectionAnchorGridLineStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "selectionAnchorGridLine");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getEvenRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "EVEN_BODY");
        }
        if (this.getEvenRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "EVEN_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getOddRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "ODD_BODY");
        }
        if (this.getOddRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "ODD_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnGroupHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "COLUMN_GROUP_HEADER");
        }
        if (this.getColumnGroupHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "COLUMN_GROUP_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowGroupHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "ROW_GROUP_HEADER");
        }
        if (this.getRowGroupHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "ROW_GROUP_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSortHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "SORT_UP");
        }
        if (this.getSortHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "SORT_UP");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectedSortHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "SORT_UP");
        }
        if (this.getSelectedSortHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "SORT_UP");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getFilterRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "FILTER_ROW");
        }
        if (this.getFilterRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "FILTER_ROW");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getTreeStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "TREE_COLUMN_CELL");
        }
        if (this.getTreeCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "TREE_COLUMN_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getTreeSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "TREE_COLUMN_CELL");
        }
        if (this.getTreeSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "TREE_COLUMN_CELL");
        }
        if (this.getTreeStructurePainter() != null) {
            configRegistry.unregisterConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, "NORMAL");
        }
        if (this.getTreeStructureSelectionPainter() != null) {
            configRegistry.unregisterConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, "SELECT");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSummaryRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "SummaryRow");
        }
        if (this.getSummaryRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "SummaryRow");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSummaryRowSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "SummaryRow");
        }
        if (this.getSummaryRowSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "SELECT", "SummaryRow");
        }
        if (this.getFreezeSeparatorColor() != null) {
            configRegistry.unregisterConfigAttribute(IFreezeConfigAttributes.SEPARATOR_COLOR);
        }
        if (this.getGridLineColor() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR);
        }
        if (this.getRenderColumnHeaderGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, "NORMAL", "COLUMN_HEADER");
        }
        if (this.getRenderCornerGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, "NORMAL", "CORNER");
        }
        if (this.getRenderRowHeaderGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, "NORMAL", "ROW_HEADER");
        }
        if (this.getRenderBodyGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, "NORMAL", "BODY");
        }
        if (this.getRenderFilterRowGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, "NORMAL", "FILTER_ROW");
        }
        if (this.getConversionErrorStyle() != null) {
            configRegistry.unregisterConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, "EDIT");
        }
        if (this.getValidationErrorStyle() != null) {
            configRegistry.unregisterConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, "EDIT");
        }
        if (this.getFillHandleColor() != null) {
            configRegistry.unregisterConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_COLOR, "NORMAL", "selectionHandleCell");
        }
        if (this.getFillHandleBorderStyle() != null) {
            configRegistry.unregisterConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_BORDER_STYLE, "NORMAL", "selectionHandleCell");
        }
        if (this.getFillHandleRegionBorderStyle() != null) {
            configRegistry.unregisterConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_REGION_BORDER_STYLE, "NORMAL", "FILL_HANDLE_REGION");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getCopyBorderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "copyBorderStyle");
        }
        for (IThemeExtension extension : this.extensions) {
            extension.unregisterStyles(configRegistry);
        }
    }

    public void addThemeExtension(IThemeExtension extension) {
        this.extensions.add(extension);
    }

    public void removeThemeExtension(IThemeExtension extension) {
        this.extensions.remove(extension);
    }
}

