/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.model;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.core.notifications.ResourceNotification;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public abstract class AbstractCommand
extends AbstractHandler {
    protected Model umlModel;
    protected ExecutionEvent event;
    protected DiagramStatus diagramStatus;
    protected PapyrusMultiDiagramEditor editor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.editor = CHESSEditorUtils.getCHESSEditor();
        this.diagramStatus = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)this.editor);
        if (this.editor == null || this.diagramStatus == null) {
            return null;
        }
        try {
            Resource res = ResourceUtils.getUMLResource((ServicesRegistry)this.editor.getServicesRegistry());
            this.umlModel = ResourceUtils.getModel((Resource)res);
            if (this.umlModel != null) {
                try {
                    this.execute();
                }
                catch (ModelError e) {
                    ResourceNotification.showInfo((String)("Problems with the model. " + e.getCause() + ": " + e.getMessage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ResourceNotification.showError((String)("Unexpected error: " + e.toString()));
                }
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return null;
    }

    public abstract void execute() throws ModelError, Exception;
}

