/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.OSSImporter.core.actions;

import com.google.common.collect.Maps;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSModelFactory;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.contract.contract.Assumption;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.contract.Guarantee;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.ComplexType;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.Interface;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.IterativeCondition;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.Operation;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.ParameterAssumptions;
import eu.fbk.tools.editor.oss.oss.RefinedBy;
import eu.fbk.tools.editor.oss.oss.Refinement;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SystemComponent;
import eu.fbk.tools.editor.oss.oss.Variable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.sysml.portandflows.FlowDirection;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.polarsys.chess.OSSImporter.core.exceptions.ImportException;
import org.polarsys.chess.OSSImporter.core.utils.ChessElementsUtil;
import org.polarsys.chess.OSSImporter.core.utils.OssTypeTranslator;
import org.polarsys.chess.OSSImporter.core.utils.StereotypeUtil;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.model.ChessSystemModel;

public class ImportOSSFileAction {
    private static boolean validateSerializedElements = false;
    private static String language = "OCRA";
    private static ImportOSSFileAction classInstance;
    private final ChessSystemModel chessSystemModel = ChessSystemModel.getInstance();
    private final ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private final EntityUtil entityUtil = EntityUtil.getInstance();
    private final StereotypeUtil stereotypeUtil = StereotypeUtil.getInstance();
    private final ChessElementsUtil chessElementsUtil = ChessElementsUtil.getInstance();
    private OSSModelUtil ossModelUtil = OSSModelUtil.getInstance();
    private OssTypeTranslator ossTypeTranslator = OssTypeTranslator.getInstance();
    private final EList<Element> addedElements = new BasicEList(2000);
    private final List<String> removedElements = new ArrayList<String>(2000);
    private final Set<String> modifiedDiagrams = new HashSet<String>();
    private Package sysView = null;
    private Map<String, Class> dslTypeToComponent;
    private ImportException importException;
    private static final Logger logger;
    private StringBuffer importErrors;

    static {
        logger = Logger.getLogger(ImportOSSFileAction.class);
    }

    public static ImportOSSFileAction getInstance() {
        if (classInstance == null) {
            classInstance = new ImportOSSFileAction();
        }
        return classInstance;
    }

    private String getTextOfTag(EObject tag) {
        return this.ossModelUtil.getOssElementAsString(tag, validateSerializedElements, true).split(" ")[0];
    }

    private void parseRefinements(AbstractComponent dslParentComponent, Refinement dslComponentRefinement) throws ImportException {
        EList dslRefInstances = dslComponentRefinement.getRefinements();
        Class owner = this.dslTypeToComponent.get(dslParentComponent.getType());
        EList existingComponentInstances = this.chessSystemModel.getSubComponentsInstances((Object)owner);
        HashMap mapComponentInstancesToKeep = Maps.newHashMapWithExpectedSize((int)existingComponentInstances.size());
        for (Property componentInstance : existingComponentInstances) {
            mapComponentInstancesToKeep.put(componentInstance.getQualifiedName(), null);
        }
        BasicEList existingConnectors = new BasicEList((Collection)owner.getOwnedConnectors());
        HashMap mapConnectorsToKeep = Maps.newHashMapWithExpectedSize((int)existingConnectors.size());
        for (Connector connector : existingConnectors) {
            mapConnectorsToKeep.put(connector.getQualifiedName(), null);
        }
        EList existingDelegationConstraints = this.entityUtil.getDelegationConstraintsAsUMLConstraints((Element)owner);
        HashMap mapDelegationContraintsToKeep = Maps.newHashMapWithExpectedSize((int)existingDelegationConstraints.size());
        for (Constraint delegationConstraint : existingDelegationConstraints) {
            mapDelegationContraintsToKeep.put(delegationConstraint.getQualifiedName(), null);
        }
        EList existingContractRefinements = this.entityUtil.getDataTypes(owner);
        HashMap mapContractRefinementsToKeep = Maps.newHashMapWithExpectedSize((int)existingContractRefinements.size());
        for (Classifier contractRefinement : existingContractRefinements) {
            mapContractRefinementsToKeep.put(contractRefinement.getQualifiedName(), null);
        }
        EList existingFormalProperties = this.chessSystemModel.getRefinementAssertions((Object)owner);
        HashMap mapFormalPropertiesToKeep = Maps.newHashMapWithExpectedSize((int)existingFormalProperties.size());
        for (Constraint formalProperty : existingFormalProperties) {
            mapFormalPropertiesToKeep.put(formalProperty.getQualifiedName(), null);
        }
        if (dslRefInstances != null && !dslRefInstances.isEmpty()) {
            for (RefinementInstance dslRefInstance : dslRefInstances) {
                if (this.containsSubComponent(dslRefInstance)) {
                    this.parseSubComponent(dslRefInstance.getSubcomponent(), mapComponentInstancesToKeep, owner);
                    continue;
                }
                if (this.containsConnection(dslRefInstance)) {
                    this.parseConnection(dslRefInstance.getConnection(), (EList<Connector>)existingConnectors, (EList<Constraint>)existingDelegationConstraints, mapConnectorsToKeep, mapDelegationContraintsToKeep, owner);
                    continue;
                }
                if (this.containsRefinedBy(dslRefInstance)) {
                    this.parseRefinedBy(dslRefInstance.getRefinedby(), mapContractRefinementsToKeep, owner);
                    continue;
                }
                if (this.containsFormula(dslRefInstance)) {
                    this.addImportError("Found a CONSTRAINT tag, don't know how to handle it!");
                    continue;
                }
                if (this.containsProp(dslRefInstance)) {
                    this.addImportError("Found a PROP tag, don't know how to handle it!");
                    continue;
                }
                if (this.containsAssertion(dslRefInstance)) {
                    this.parseRefinementAssertion(dslRefInstance.getAssertion(), mapFormalPropertiesToKeep, owner);
                    continue;
                }
                if (dslRefInstance == null) continue;
                this.addImportError("Found a " + this.getTextOfTag((EObject)dslRefInstance) + " tag, don't know how to handle it!");
            }
        }
        this.removeUnusedRefinementElements(mapComponentInstancesToKeep, (EList<Property>)existingComponentInstances, mapConnectorsToKeep, (EList<Connector>)existingConnectors, mapDelegationContraintsToKeep, (EList<Constraint>)existingDelegationConstraints, mapContractRefinementsToKeep, (EList<DataType>)existingContractRefinements, mapFormalPropertiesToKeep, (EList<Constraint>)existingFormalProperties);
    }

    private void removeUnusedRefinementElements(HashMap<String, Boolean> mapComponentInstancesToKeep, EList<Property> existingComponentInstances, HashMap<String, Boolean> mapConnectorsToKeep, EList<Connector> existingConnectors, HashMap<String, Boolean> mapDelegationContraintsToKeep, EList<Constraint> existingDelegationConstraints, HashMap<String, Boolean> mapContractRefinementsToKeep, EList<DataType> existingContractRefinements, HashMap<String, Boolean> mapFormalPropertiesToKeep, EList<Constraint> existingFormalProperties) {
        for (String qualifiedElement : mapComponentInstancesToKeep.keySet()) {
            if (mapComponentInstancesToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingComponentInstances, qualifiedElement));
            this.entityUtil.removeProperty(existingComponentInstances, qualifiedElement);
        }
        for (String qualifiedElement : mapConnectorsToKeep.keySet()) {
            if (mapConnectorsToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingConnectors, qualifiedElement));
            this.entityUtil.removeConnector(existingConnectors, qualifiedElement);
        }
        for (String qualifiedElement : mapDelegationContraintsToKeep.keySet()) {
            if (mapDelegationContraintsToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingDelegationConstraints, qualifiedElement));
            this.entityUtil.removeDelegationConstraint(existingDelegationConstraints, qualifiedElement);
        }
        for (String qualifiedElement : mapContractRefinementsToKeep.keySet()) {
            if (mapContractRefinementsToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingContractRefinements, qualifiedElement));
            this.contractEntityUtil.removeContractRefinement(existingContractRefinements, qualifiedElement);
        }
        for (String qualifiedElement : mapFormalPropertiesToKeep.keySet()) {
            if (mapFormalPropertiesToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingFormalProperties, qualifiedElement));
            this.entityUtil.removeFormalProperty(existingFormalProperties, qualifiedElement);
        }
    }

    private boolean containsAssertion(RefinementInstance dslRefInstance) {
        return dslRefInstance != null && dslRefInstance.getAssertion() != null;
    }

    private boolean containsProp(RefinementInstance dslRefInstance) {
        return dslRefInstance != null && dslRefInstance.getProp() != null;
    }

    private boolean containsFormula(RefinementInstance dslRefInstance) {
        return dslRefInstance != null && dslRefInstance.getFormula() != null;
    }

    private boolean containsRefinedBy(RefinementInstance dslRefInstance) {
        return dslRefInstance != null && dslRefInstance.getRefinedby() != null;
    }

    private boolean containsConnection(RefinementInstance dslRefInstance) {
        return dslRefInstance != null && dslRefInstance.getConnection() != null;
    }

    private boolean containsSubComponent(RefinementInstance dslRefInstance) {
        return dslRefInstance != null && dslRefInstance.getSubcomponent() != null;
    }

    private void parseRefinementAssertion(Assertion assertion, HashMap<String, Boolean> mapFormalPropertiesToKeep, Class owner) {
        String assertionName = assertion.getName();
        String assertionText = this.ossModelUtil.getExpressionAsString(assertion.getConstraint(), validateSerializedElements);
        Constraint umlConstraint = owner.getOwnedRule(assertionName);
        if (umlConstraint == null || !this.entityUtil.isFormalProperty((Element)umlConstraint)) {
            logger.debug((Object)"Formal property non found, creating one");
            this.addedElements.add((Object)this.entityUtil.createRefinementFormalProperty(owner, assertionName, assertionText));
        } else if (this.entityUtil.isFormalProperty((Element)umlConstraint)) {
            logger.debug((Object)"Formal property already present");
            this.chessElementsUtil.updateUmlRefinementFormalProperty(umlConstraint, assertionText, language, mapFormalPropertiesToKeep);
        }
    }

    private void parseRefinedBy(RefinedBy refinedBy, HashMap<String, Boolean> mapContractRefinementsToKeep, Class owner) throws ImportException {
        String refinedContractTypeName = refinedBy.getName();
        logger.debug((Object)("\n\n\nContract name = " + refinedContractTypeName + " from " + owner.getName()));
        ContractProperty chessContractProperty = this.contractEntityUtil.getUmlContractPropertyOfUmlComponentFromContractPropertyType(owner, refinedContractTypeName);
        EList chessContractPropertyRefinements = this.chessSystemModel.getContractRefinements((Object)chessContractProperty);
        EList refiningContractIds = refinedBy.getFullContractIds();
        for (FullContractIdList refiningContractId : refiningContractIds) {
            String componentInstanceName = this.getComponentNameCheckingOwnerSubComponents(refiningContractId, owner);
            String[] componentInstanceRange = this.ossModelUtil.getNearestComponentInstanceRangeFromFullContractId(refiningContractId, validateSerializedElements);
            String componentInstanceIndex = this.ossModelUtil.getNearestComponentInstanceIndexFromFullContractId(refiningContractId, componentInstanceName, validateSerializedElements);
            String refinementNameOptSuffix = "";
            if (!StringArrayUtil.isUndefined((String[])componentInstanceRange)) {
                refinementNameOptSuffix = refinementNameOptSuffix.concat("." + componentInstanceRange[0] + "_" + componentInstanceRange[1]);
            } else if (componentInstanceIndex != null) {
                refinementNameOptSuffix = refinementNameOptSuffix.concat("." + componentInstanceIndex);
            }
            String refinementName = String.valueOf(componentInstanceName) + "." + this.getRefiningContractPropertyName(componentInstanceName, owner, refiningContractId.getName()) + refinementNameOptSuffix;
            boolean alreadyLinked = false;
            for (ContractRefinement contractRefinement : chessContractPropertyRefinements) {
                if (!contractRefinement.getBase_DataType().getName().equals(refinementName)) continue;
                logger.debug((Object)"refinement already defined for the contract");
                mapContractRefinementsToKeep.put(contractRefinement.getBase_DataType().getQualifiedName(), Boolean.TRUE);
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked) continue;
            logger.debug((Object)"refinement not present");
            DataType umlRefinement = this.contractEntityUtil.getOrCreateContractRefinement(owner, componentInstanceName, componentInstanceRange, componentInstanceIndex, refiningContractId.getName(), this.stereotypeUtil.contractRefinementStereotype);
            this.contractEntityUtil.addContractRefinementToContractProperty(chessContractProperty, umlRefinement);
            this.addedElements.add((Object)umlRefinement);
        }
    }

    private String getComponentNameCheckingOwnerSubComponents(FullContractIdList refiningContractId, Class owner) throws ImportException {
        String componentInstanceName = this.ossModelUtil.getNearestComponentInstanceNameFromFullContractId(refiningContractId);
        String componentInstanceId = this.ossModelUtil.getNearestComponentInstanceIdFromFullContractId(refiningContractId, validateSerializedElements);
        Property possiblePropertyFromComponentInstanceName = this.entityUtil.getUmlComponentInstance(owner, componentInstanceName);
        Property possiblePropertyFromComponentInstanceId = this.entityUtil.getUmlComponentInstance(owner, componentInstanceId);
        if (possiblePropertyFromComponentInstanceName != null) {
            return componentInstanceName;
        }
        if (possiblePropertyFromComponentInstanceId != null) {
            return componentInstanceId;
        }
        throw new ImportException("No subcomponent with name " + componentInstanceName + " is found in " + owner.getName());
    }

    private String getRefiningContractPropertyName(String componentInstanceName, Class owner, String refiningContractTypeName) {
        Class refiningComponent = (Class)this.entityUtil.getUmlComponentInstance(owner, componentInstanceName).getType();
        logger.debug((Object)("refiningComponent: " + refiningComponent));
        logger.debug((Object)("contractId.getName(): " + refiningContractTypeName));
        Property refiningContractProperty = this.contractEntityUtil.getPropertyOfUmlComponentWithContractPropertyType(refiningComponent, refiningContractTypeName);
        logger.debug((Object)("refiningContractProperty.getName(): " + refiningContractProperty.getName()));
        return refiningContractProperty.getName();
    }

    private void parseConnection(Connection connection, EList<Connector> existingConnectors, EList<Constraint> existingDelegationConstraints, HashMap<String, Boolean> mapConnectors, HashMap<String, Boolean> mapDelegationContraintsToKeep, Class owner) throws ImportException {
        FullVariableId variable = connection.getVariable();
        Expression constraint = connection.getConstraint();
        IterativeCondition iterCondition = connection.getIterativeCondition();
        String variablePortName = null;
        String constraintPortName = null;
        Class componentTypeOfConstraint = null;
        Class componentTypeOfVariable = null;
        String componentInstanceNameOfConstraint = null;
        String componentInstanceNameOfVariable = null;
        Property componentInstanceOfConstraint = null;
        Property componentInstanceOfVariable = null;
        if (constraint instanceof FullVariableId && variable instanceof FullVariableId && (iterCondition == null || iterCondition.getConstraint() == null && iterCondition.getIteratorBounds() == null)) {
            variablePortName = this.ossModelUtil.getVariableIdAsString(variable.getId(), validateSerializedElements);
            constraintPortName = this.ossModelUtil.getVariableIdAsString(((FullVariableId)constraint).getId(), validateSerializedElements);
            componentInstanceNameOfConstraint = this.ossModelUtil.getNearestComponentId((FullVariableId)constraint);
            componentInstanceOfConstraint = this.entityUtil.getUmlComponentInstance(owner, componentInstanceNameOfConstraint);
            componentTypeOfConstraint = this.getPortOwner(componentInstanceOfConstraint, owner);
            componentInstanceNameOfVariable = this.ossModelUtil.getNearestComponentId(variable);
            componentInstanceOfVariable = this.entityUtil.getUmlComponentInstance(owner, componentInstanceNameOfVariable);
            componentTypeOfVariable = this.getPortOwner(componentInstanceOfVariable, owner);
        }
        if (this.connectorEndsExists(componentTypeOfConstraint, constraintPortName, componentTypeOfVariable, variablePortName)) {
            Connector connector = this.entityUtil.getExistingConnector(existingConnectors, componentInstanceNameOfVariable, variablePortName, componentInstanceNameOfConstraint, constraintPortName);
            if (connector != null) {
                logger.debug((Object)"connector already present");
                mapConnectors.put(connector.getQualifiedName(), Boolean.TRUE);
                return;
            }
        } else {
            logger.debug((Object)("isDelegationConstraint: " + this.ossModelUtil.getOssElementAsString((EObject)connection, validateSerializedElements, true)));
            Constraint delegationConstraint = null;
            String constraintText = this.ossModelUtil.getExpressionAsString(constraint, validateSerializedElements);
            String variableIdText = this.ossModelUtil.getFullVariableIdAsString(variable, validateSerializedElements);
            String iterConditionText = null;
            if (iterCondition != null) {
                iterConditionText = this.ossModelUtil.getIterativeConditionAsString(iterCondition, validateSerializedElements);
            }
            if ((delegationConstraint = this.entityUtil.getExistingDelegationConstraint(existingDelegationConstraints, variableIdText, constraintText, iterConditionText)) != null) {
                logger.debug((Object)"delegation constraint already present");
                mapDelegationContraintsToKeep.put(delegationConstraint.getQualifiedName(), Boolean.TRUE);
                return;
            }
            logger.debug((Object)"delegation constraint is not present");
            logger.debug((Object)("variableIdText: " + variableIdText));
            logger.debug((Object)("constraintText: " + constraintText));
            logger.debug((Object)("iterConditionText: " + iterConditionText));
            this.addedElements.add((Object)this.entityUtil.createDelegationConstraint(owner, variableIdText, constraintText, iterConditionText, this.stereotypeUtil.delegationConstraintStereotype));
            return;
        }
        logger.debug((Object)"connector is not present");
        this.addedElements.add((Object)this.entityUtil.createUmlConnector(constraintPortName, componentInstanceOfConstraint, componentTypeOfConstraint, variablePortName, componentInstanceOfVariable, componentTypeOfVariable, owner));
    }

    private boolean connectorEndsExists(Class portOwnerOfConstraint, String constraintPortName, Class portOwnerOfVariable, String variablePortName) {
        logger.debug((Object)("(portOwnerOfConstraint != null)" + (portOwnerOfConstraint != null)));
        logger.debug((Object)("(constraintPortName != null)" + (constraintPortName != null)));
        logger.debug((Object)("(portOwnerOfVariable != null)" + (portOwnerOfVariable != null)));
        logger.debug((Object)("(variablePortName != null)" + (variablePortName != null)));
        return portOwnerOfConstraint != null && constraintPortName != null && portOwnerOfVariable != null && variablePortName != null && portOwnerOfConstraint.getOwnedPort(constraintPortName, null) != null && portOwnerOfVariable.getOwnedPort(variablePortName, null) != null;
    }

    private Class getPortOwner(Property partWithPort, Class owner) {
        Class portOwner = owner;
        if (partWithPort != null) {
            String typeName = partWithPort.getType().getName();
            portOwner = this.dslTypeToComponent.get(typeName);
        }
        return portOwner;
    }

    private void parseSubComponent(SubComponent subComponent, HashMap<String, Boolean> mapComponentInstancesToKeep, Class owner) throws ImportException {
        String subName = this.ossModelUtil.getSubComponentName(subComponent, validateSerializedElements);
        logger.debug((Object)("\tsubcomponent name = " + subName));
        String subType = this.ossModelUtil.getSubComponentTypeName(subComponent);
        logger.debug((Object)("\tsubcomponent type = " + subType));
        String[] mulitplicityBoundaries = this.ossModelUtil.getMultiplicityBoundariesFromOssSubComponentType(subComponent.getType(), validateSerializedElements);
        logger.debug((Object)("\tsubcomponent multiplicityBoundaries = " + mulitplicityBoundaries[0] + " , " + mulitplicityBoundaries[1]));
        Type subComponentType = (Type)this.dslTypeToComponent.get(subType);
        Property componentInstance = this.entityUtil.getSubComponentInstance(owner, subName);
        if (componentInstance == null) {
            logger.debug((Object)"componentInstance not found, creating one");
            this.addedElements.add((Object)this.entityUtil.createUmlAssociation(subName, subComponentType, mulitplicityBoundaries, owner));
        } else {
            logger.debug((Object)"componentInstance already present");
            if (!componentInstance.getType().equals(subComponentType)) {
                this.addedElements.add((Object)componentInstance.getAssociation());
            }
            try {
                this.chessElementsUtil.updateUmlAssociation(componentInstance, subComponentType, mulitplicityBoundaries, mapComponentInstancesToKeep);
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    throw new ImportException(e.getMessage());
                }
                e.printStackTrace();
                throw new ImportException(e.toString());
            }
        }
    }

    private HashMap<String, FormalProperty> prepareFormalPropertiesMap(EList<Constraint> existingFormalProperties) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)existingFormalProperties.size());
        for (Constraint constraint : existingFormalProperties) {
            FormalProperty formalProperty = this.entityUtil.getFormalProperty(constraint);
            if (formalProperty == null) continue;
            map.put(formalProperty.getBase_Constraint().getName(), formalProperty);
        }
        return map;
    }

    private void parseInterfaces(AbstractComponent dslParentComponent, Interface dslComponentInterface) throws ImportException {
        EList dslIntInstances = dslComponentInterface.getInterfaces();
        Class owner = this.dslTypeToComponent.get(dslParentComponent.getType());
        EList existingNonStaticPorts = this.chessSystemModel.getNonStaticPorts((Object)owner);
        existingNonStaticPorts.addAll((Collection)this.chessSystemModel.getStaticPorts((Object)owner));
        HashMap mapPortsToKeep = Maps.newHashMapWithExpectedSize((int)existingNonStaticPorts.size());
        for (NamedElement port : existingNonStaticPorts) {
            mapPortsToKeep.put(port.getQualifiedName(), null);
        }
        EList existingContractProperties = this.chessSystemModel.getContractsOfComponent((Object)owner);
        HashMap mapContractPropertiesToKeep = Maps.newHashMapWithExpectedSize((int)existingContractProperties.size());
        for (ContractProperty contractProperty : existingContractProperties) {
            mapContractPropertiesToKeep.put(contractProperty.getBase_Property().getQualifiedName(), null);
        }
        EList existingFormalProperties = this.chessSystemModel.getInterfaceAssertions((Object)owner);
        HashMap<String, FormalProperty> hashFormalProperties = this.prepareFormalPropertiesMap((EList<Constraint>)existingFormalProperties);
        HashMap mapFormalPropertiesToKeep = Maps.newHashMapWithExpectedSize((int)existingFormalProperties.size());
        for (Constraint formalProperty : existingFormalProperties) {
            mapFormalPropertiesToKeep.put(formalProperty.getQualifiedName(), null);
        }
        EList existingParameterAssumptions = this.chessSystemModel.getParameterAssumptions((Object)owner);
        HashMap mapParameterAssumptionsToKeep = Maps.newHashMapWithExpectedSize((int)existingParameterAssumptions.size());
        for (Constraint parameterAssumptions : existingParameterAssumptions) {
            mapParameterAssumptionsToKeep.put(parameterAssumptions.getQualifiedName(), null);
        }
        EList existingFunctionBehaviors = owner.getOwnedBehaviors();
        HashMap mapFunctionBehaviorsToKeep = Maps.newHashMapWithExpectedSize((int)existingFunctionBehaviors.size());
        for (Behavior behavior : existingFunctionBehaviors) {
            mapFunctionBehaviorsToKeep.put(behavior.getQualifiedName(), null);
        }
        EList existingDefines = this.chessSystemModel.getDefines((Object)owner);
        HashMap mapDefinesToKeep = Maps.newHashMapWithExpectedSize((int)existingDefines.size());
        for (Constraint define : existingDefines) {
            mapDefinesToKeep.put(define.getQualifiedName(), null);
        }
        if (dslIntInstances != null && !dslIntInstances.isEmpty()) {
            for (InterfaceInstance dslIntInstance : dslIntInstances) {
                if (this.containsVariable(dslIntInstance)) {
                    Variable dslVariable = dslIntInstance.getVariable();
                    if (dslVariable instanceof eu.fbk.tools.editor.oss.oss.Port) {
                        this.parsePort((eu.fbk.tools.editor.oss.oss.Port)dslVariable, (EList<NamedElement>)existingNonStaticPorts, mapPortsToKeep, owner);
                        continue;
                    }
                    if (dslVariable instanceof Parameter) {
                        this.parseParameter((Parameter)dslVariable, mapFunctionBehaviorsToKeep, (EList<NamedElement>)existingNonStaticPorts, mapPortsToKeep, owner);
                        continue;
                    }
                    if (dslVariable instanceof Operation) {
                        this.addImportError("Found a OPERATION tag, don't know how to handle it!");
                        continue;
                    }
                    this.addImportError("Found a " + this.getTextOfTag((EObject)dslVariable) + " tag, don't know how to handle it!");
                    continue;
                }
                if (this.containsDefine(dslIntInstance)) {
                    this.parseDefine(dslIntInstance.getDefine(), (EList<Constraint>)existingDefines, mapDefinesToKeep, owner);
                    continue;
                }
                if (this.containsContract(dslIntInstance)) {
                    this.parseContract(dslIntInstance.getContract(), hashFormalProperties, mapFormalPropertiesToKeep, mapContractPropertiesToKeep, owner);
                    continue;
                }
                if (this.containsAssertion(dslIntInstance)) {
                    this.parseInterfaceAssertion(dslIntInstance.getAssertion(), hashFormalProperties, mapFormalPropertiesToKeep, owner);
                    continue;
                }
                if (this.containsParameterAssumptions(dslIntInstance)) {
                    this.parseParameterAssumptions(dslIntInstance.getParameterAssumptions(), mapParameterAssumptionsToKeep, owner);
                    continue;
                }
                if (dslIntInstance == null) continue;
                this.addImportError("Found a " + this.getTextOfTag((EObject)dslIntInstance) + " tag, don't know how to handle it!");
            }
        }
        this.removeUnusedInterfaceElements(mapPortsToKeep, (EList<NamedElement>)existingNonStaticPorts, mapContractPropertiesToKeep, (EList<ContractProperty>)existingContractProperties, mapFormalPropertiesToKeep, (EList<Constraint>)existingFormalProperties, mapParameterAssumptionsToKeep, (EList<Constraint>)existingParameterAssumptions, mapFunctionBehaviorsToKeep, (EList<Behavior>)existingFunctionBehaviors, mapDefinesToKeep, (EList<Constraint>)existingDefines);
    }

    private void parseParameterAssumptions(ParameterAssumptions parameterAssumptions, HashMap<String, Boolean> mapParameterAssumptionsToKeep, Class owner) {
        String parameterAssumptionsExpression = this.ossModelUtil.getExpressionAsString(parameterAssumptions.getConstraint(), validateSerializedElements);
        Constraint umlConstraint = this.entityUtil.getParameterAssumptionsFromExpression(parameterAssumptionsExpression, owner);
        if (umlConstraint == null || !this.entityUtil.isParameterAssumptions((Element)umlConstraint)) {
            logger.debug((Object)"Parameter assumptions non found, creating one");
            this.addedElements.add((Object)this.entityUtil.createParameterAssumptions(parameterAssumptionsExpression, owner, this.stereotypeUtil.parameterAssumptionsStereotype));
        } else if (this.entityUtil.isParameterAssumptions((Element)umlConstraint)) {
            logger.debug((Object)"Parameter assumptions already present");
            mapParameterAssumptionsToKeep.put(umlConstraint.getQualifiedName(), Boolean.TRUE);
        }
    }

    private boolean containsParameterAssumptions(InterfaceInstance dslIntInstance) {
        return dslIntInstance != null && dslIntInstance.getParameterAssumptions() != null;
    }

    private void removeUnusedInterfaceElements(HashMap<String, Boolean> mapPortsToKeep, EList<NamedElement> existingNonStaticPorts, HashMap<String, Boolean> mapContractPropertiesToKeep, EList<ContractProperty> existingContractProperties, HashMap<String, Boolean> mapFormalPropertiesToKeep, EList<Constraint> existingFormalProperties, HashMap<String, Boolean> mapParameterAssumptionsToKeep, EList<Constraint> existingParameterAssumptions, HashMap<String, Boolean> mapFunctionBehaviorsToKeep, EList<Behavior> existingFunctionBehaviors, HashMap<String, Boolean> mapDefinesToKeep, EList<Constraint> existingDefines) {
        for (String qualifiedElement : mapPortsToKeep.keySet()) {
            if (mapPortsToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingNonStaticPorts, qualifiedElement));
            this.entityUtil.removePort(existingNonStaticPorts, qualifiedElement);
        }
        for (String qualifiedElement : mapContractPropertiesToKeep.keySet()) {
            if (mapContractPropertiesToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingContractProperties, qualifiedElement));
            this.contractEntityUtil.removeContractProperty(existingContractProperties, qualifiedElement);
        }
        for (String qualifiedElement : mapFormalPropertiesToKeep.keySet()) {
            if (mapFormalPropertiesToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingFormalProperties, qualifiedElement));
            this.entityUtil.removeFormalProperty(existingFormalProperties, qualifiedElement);
        }
        for (String qualifiedElement : mapParameterAssumptionsToKeep.keySet()) {
            if (mapParameterAssumptionsToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingParameterAssumptions, qualifiedElement));
            this.entityUtil.removeParameterAssumptions(existingParameterAssumptions, qualifiedElement);
        }
        for (String qualifiedElement : mapFunctionBehaviorsToKeep.keySet()) {
            if (mapFunctionBehaviorsToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingFunctionBehaviors, qualifiedElement));
            this.entityUtil.removeFunctionBehavior(existingFunctionBehaviors, qualifiedElement);
        }
        for (String qualifiedElement : mapDefinesToKeep.keySet()) {
            if (mapDefinesToKeep.get(qualifiedElement) != null) continue;
            this.removedElements.add(qualifiedElement);
            this.modifiedDiagrams.addAll(this.chessElementsUtil.getInvolvedDiagrams(existingDefines, qualifiedElement));
            this.entityUtil.removeMacroDefinition(existingDefines, qualifiedElement);
        }
    }

    private void addImportError(String message) {
        logger.error((Object)("Import Error: " + message));
        this.importErrors.append(String.valueOf(message) + "\n");
    }

    private boolean containsAssertion(InterfaceInstance dslIntInstance) {
        return dslIntInstance != null && dslIntInstance.getAssertion() != null;
    }

    private boolean containsContract(InterfaceInstance dslIntInstance) {
        return dslIntInstance != null && dslIntInstance.getContract() != null;
    }

    private boolean containsDefine(InterfaceInstance dslIntInstance) {
        return dslIntInstance != null && dslIntInstance.getDefine() != null;
    }

    private boolean containsVariable(InterfaceInstance dslIntInstance) {
        return dslIntInstance != null && dslIntInstance.getVariable() != null;
    }

    private void parseInterfaceAssertion(Assertion assertion, HashMap<String, FormalProperty> hashFormalProperties, HashMap<String, Boolean> mapFormalPropertiesToKeep, Class owner) {
        String assertionName = assertion.getName();
        String assertionText = this.ossModelUtil.getExpressionAsString(assertion.getConstraint(), validateSerializedElements);
        Constraint umlConstraint = owner.getOwnedRule(assertionName);
        if (umlConstraint == null || !this.entityUtil.isFormalProperty((Element)umlConstraint)) {
            logger.debug((Object)"Formal property not found, creating one");
            this.addedElements.add((Object)this.chessElementsUtil.createUmlInterfaceFormalProperty(assertionName, assertionText, hashFormalProperties, owner));
        } else if (this.entityUtil.isFormalProperty((Element)umlConstraint)) {
            logger.debug((Object)"Formal property already present");
            this.chessElementsUtil.updateUmlFormalProperty(umlConstraint, assertionText, language, hashFormalProperties, mapFormalPropertiesToKeep);
        }
    }

    private void parseContract(Contract dslContract, HashMap<String, FormalProperty> hashFormalProperties, HashMap<String, Boolean> mapFormalPropertiesToKeep, HashMap<String, Boolean> mapContractPropertiesToKeep, Class owner) {
        Assumption dslAssumption = dslContract.getAssumption();
        Guarantee dslGuarantee = dslContract.getGuarantee();
        String ossAssumptionText = this.ossModelUtil.getExpressionAsString(dslAssumption.getConstraint(), validateSerializedElements);
        String ossGuaranteeText = this.ossModelUtil.getExpressionAsString(dslGuarantee.getConstraint(), validateSerializedElements);
        String contractName = dslContract.getName();
        Class umlContract = (Class)owner.getOwnedMember(contractName, false, UMLFactory.eINSTANCE.createClass().eClass());
        if (umlContract == null) {
            logger.debug((Object)"contract not found, creating one");
            umlContract = this.chessElementsUtil.createUmlContract(contractName, ossAssumptionText, ossGuaranteeText, hashFormalProperties, owner, this.stereotypeUtil.contractStereotype);
            String contractPropertyName = this.deriveContractPropertyNameFromContract(umlContract);
            this.contractEntityUtil.createContractProperty(owner, contractPropertyName, (Type)umlContract, this.stereotypeUtil.contractPropertyStereotype);
            this.addedElements.add((Object)umlContract);
        } else {
            logger.debug((Object)"Contract already present");
            this.chessElementsUtil.updateUmlContract(umlContract, ossAssumptionText, ossGuaranteeText, language, hashFormalProperties, mapContractPropertiesToKeep, mapFormalPropertiesToKeep, owner);
        }
    }

    private void parseDefine(Define define, EList<Constraint> existingPorts, HashMap<String, Boolean> mapDefinesToKeep, Class owner) {
        String defineName = define.getName();
        String defineExpression = this.ossModelUtil.getExpressionAsString(define.getConstraint(), validateSerializedElements);
        Constraint umlConstraint = owner.getOwnedRule(defineName);
        if (umlConstraint == null || !this.entityUtil.isMacroDefinition((Element)umlConstraint)) {
            logger.debug((Object)"Macro definition not found, creating one");
            this.addedElements.add((Object)this.entityUtil.createMacroDefinition(defineName, defineExpression, owner, this.stereotypeUtil.macroDefinitionStereotype));
        } else if (this.entityUtil.isMacroDefinition((Element)umlConstraint)) {
            logger.debug((Object)"Macro definition already present");
            this.chessElementsUtil.updateMacroDefinition(umlConstraint, defineExpression, language, mapDefinesToKeep);
        }
    }

    private String deriveContractPropertyNameFromContract(Class contract) {
        String contractName = contract.getName();
        if (contractName.length() > 0) {
            return contractName.toLowerCase();
        }
        return ((Contract)contract).getName().toLowerCase();
    }

    private void parsePort(eu.fbk.tools.editor.oss.oss.Port ossPort, EList<NamedElement> existingPorts, HashMap<String, Boolean> mapPortsToKeep, Class owner) throws ImportException {
        ComplexType ossPortType = ossPort.getType();
        String portName = this.ossModelUtil.getPortName(ossPort, validateSerializedElements);
        logger.debug((Object)("port: " + ossPort));
        logger.debug((Object)("portName: " + portName));
        Type newPortType = this.ossTypeTranslator.getOrCreateTypeFromOssComplexType(ossPortType, owner.getNearestPackage());
        if (newPortType == null) {
            throw new ImportException("Not able to map the requested type for port : " + portName);
        }
        String[] newMultiplicityRange = this.ossModelUtil.getMultiplicityBoundariesFromOssComplexType(ossPortType, validateSerializedElements);
        Port port = this.entityUtil.getExistingUmlPort(portName, existingPorts);
        if (port != null) {
            if (ossPort instanceof InputPort) {
                this.chessElementsUtil.updateUmlNonStaticPort(port, ossPort, newPortType, newMultiplicityRange, FlowDirection.IN, this.stereotypeUtil.flowPortStereotype, mapPortsToKeep);
            } else if (ossPort instanceof OutputPort) {
                this.chessElementsUtil.updateUmlNonStaticPort(port, ossPort, newPortType, newMultiplicityRange, FlowDirection.OUT, this.stereotypeUtil.flowPortStereotype, mapPortsToKeep);
            }
        } else {
            logger.debug((Object)"Port not found, creating it");
            if (ossPort instanceof InputPort) {
                this.addedElements.add((Object)this.entityUtil.createNonStaticPort(owner, portName, newPortType, newMultiplicityRange, true, this.stereotypeUtil.flowPortStereotype));
            } else if (ossPort instanceof OutputPort) {
                this.addedElements.add((Object)this.entityUtil.createNonStaticPort(owner, portName, newPortType, newMultiplicityRange, false, this.stereotypeUtil.flowPortStereotype));
            }
        }
    }

    private void parseParameter(Parameter ossParameter, HashMap<String, Boolean> mapFunctionBehaviorsToKeep, EList<NamedElement> existingNonStaticPorts, HashMap<String, Boolean> mapPortsToKeep, Class owner) throws ImportException {
        ComplexType ossOutputType = ossParameter.getType();
        EList ossInputTypes = ossParameter.getParameters();
        String parameterName = this.ossModelUtil.getVariableIdAsString(ossParameter.getId(), validateSerializedElements);
        if (ossInputTypes.size() != 0) {
            this.parseParameterAsUmlFunctionBehaviour(parameterName, ossOutputType, (EList<ComplexType>)ossInputTypes, mapFunctionBehaviorsToKeep, owner);
        } else {
            this.parseParameterAsUmlStaticPort(parameterName, ossOutputType, existingNonStaticPorts, mapPortsToKeep, owner);
        }
    }

    private void parseParameterAsUmlStaticPort(String ossParameterName, ComplexType ossParameterType, EList<NamedElement> existingStaticPorts, HashMap<String, Boolean> mapPortsToKeep, Class owner) throws ImportException {
        String[] newMultiplicityRange = this.ossModelUtil.getMultiplicityBoundariesFromOssComplexType(ossParameterType, validateSerializedElements);
        Type newParameterType = this.ossTypeTranslator.getOrCreateTypeFromOssComplexType(ossParameterType, owner.getNearestPackage());
        if (newParameterType == null) {
            throw new ImportException("Not able to map the requested type for port : " + ossParameterName);
        }
        Port staticPort = this.entityUtil.getExistingUmlPort(ossParameterName, newParameterType.getName(), existingStaticPorts);
        if (staticPort != null) {
            logger.debug((Object)"Port already present");
            this.chessElementsUtil.updateUmlStaticPort(staticPort, newMultiplicityRange, mapPortsToKeep);
        } else {
            this.addedElements.add((Object)this.entityUtil.createStaticPort(owner, ossParameterName, newParameterType, newMultiplicityRange, this.stereotypeUtil.flowPortStereotype));
        }
    }

    private void parseParameterAsUmlFunctionBehaviour(String parameterName, ComplexType ossOutputType, EList<ComplexType> ossInputTypes, HashMap<String, Boolean> mapFunctionBehaviorsToKeep, Class owner) throws ImportException {
        FunctionBehavior functionBehavior = (FunctionBehavior)owner.getOwnedBehavior(parameterName);
        Type newOutputType = this.ossTypeTranslator.getOrCreateTypeFromOssComplexType(ossOutputType, owner.getNearestPackage());
        String[] newMultiplicity = this.ossModelUtil.getMultiplicityBoundariesFromOssComplexType(ossOutputType, validateSerializedElements);
        EList<Type> newInputTypes = this.ossTypeTranslator.getOrCreateTypesFromOssComplexTypes(ossInputTypes, owner.getNearestPackage());
        EList newMultiplicities = this.ossModelUtil.getMultiplicityBoundariesFromOssComplexTypes(ossInputTypes, validateSerializedElements);
        if (newOutputType == null) {
            throw new ImportException("Not able to map the requested type for port : " + parameterName);
        }
        if (functionBehavior == null) {
            logger.debug((Object)"functionBehavior not found, creating one");
            this.addedElements.add((Object)this.entityUtil.createUmlFunctionBehaviour(parameterName, newInputTypes, newMultiplicities, newOutputType, newMultiplicity, owner));
        } else {
            logger.debug((Object)"functionBehavior already present");
            this.chessElementsUtil.updateUmlFunctionBehaviour(functionBehavior, newInputTypes, (EList<String[]>)newMultiplicities, newOutputType, newMultiplicity, mapFunctionBehaviorsToKeep);
        }
    }

    private void parseComponentInterfaces(AbstractComponent dslParentComponent) throws ImportException {
        logger.debug((Object)("\n\n\nParsing Interfaces for  " + dslParentComponent.getType() + "\n"));
        Interface dslComponentInterface = dslParentComponent.getInterface();
        if (dslComponentInterface != null) {
            this.parseInterfaces(dslParentComponent, dslComponentInterface);
        }
    }

    private void parseComponentRefinements(AbstractComponent dslParentComponent) throws ImportException {
        logger.debug((Object)("\n\n\nParsing Refinements for " + dslParentComponent.getType() + "\n"));
        Refinement dslComponentRefinement = dslParentComponent.getRefinement();
        if (dslComponentRefinement != null) {
            this.parseRefinements(dslParentComponent, dslComponentRefinement);
        }
    }

    public List<String> getAddedElements() {
        ArrayList<String> qualifiedNames = new ArrayList<String>(this.addedElements.size());
        for (Element element : this.addedElements) {
            if (element instanceof NamedElement) {
                qualifiedNames.add(((NamedElement)element).getQualifiedName());
                continue;
            }
            qualifiedNames.add(element.toString());
        }
        return qualifiedNames;
    }

    public List<String> getRemovedElements() {
        return this.removedElements;
    }

    public Set<String> getModifiedDiagrams() {
        return this.modifiedDiagrams;
    }

    public StringBuffer startParsing(final Package pkg, File ossFile, TransactionalEditingDomain domain) throws Exception {
        logger.debug((Object)("pkg: " + pkg));
        this.sysView = pkg;
        this.importErrors = new StringBuffer();
        this.stereotypeUtil.refreshStereotypes(this.sysView);
        long startTime = System.currentTimeMillis();
        if (ossFile == null) {
            return this.importErrors;
        }
        final OSS ocraOssFile = OSSModelFactory.getInstance().createOssModel(ossFile);
        final SystemComponent dslSystemComponent = ocraOssFile.getSystem();
        if (dslSystemComponent == null) {
            logger.error((Object)"Import Error: System component is missing");
            throw new ImportException("System component is missing");
        }
        final String dslSystemComponentName = dslSystemComponent.getType() == null ? "System" : dslSystemComponent.getType();
        dslSystemComponent.setType(dslSystemComponentName);
        logger.debug((Object)("dslSystemComponent.type = " + dslSystemComponentName));
        EList existingMembers = this.sysView.getOwnedMembers();
        BasicEList existingBlocks = new BasicEList(existingMembers.size());
        final HashMap mapBlocks = Maps.newHashMapWithExpectedSize((int)existingMembers.size());
        for (Element member : existingMembers) {
            if (!this.entityUtil.isBlock(member) || this.contractEntityUtil.isContract(member)) continue;
            mapBlocks.put(((Class)member).getQualifiedName(), null);
            existingBlocks.add((Object)((Class)member));
        }
        this.addedElements.clear();
        this.removedElements.clear();
        this.modifiedDiagrams.clear();
        this.dslTypeToComponent = new HashMap<String, Class>();
        this.importException = null;
        domain.getCommandStack().execute((Command)new RecordingCommand(domain, (EList)existingBlocks, startTime){
            private final /* synthetic */ EList val$existingBlocks;
            private final /* synthetic */ long val$startTime;
            {
                this.val$existingBlocks = eList;
                this.val$startTime = l;
                super($anonymous0);
            }

            protected void doExecute() {
                String blockQualifiedName = String.valueOf(pkg.getQualifiedName()) + "::" + dslSystemComponentName;
                Class systemComponent = null;
                if (!mapBlocks.containsKey(blockQualifiedName)) {
                    logger.debug((Object)("block not present: " + blockQualifiedName));
                    systemComponent = ImportOSSFileAction.this.entityUtil.createSystemBlock(ImportOSSFileAction.this.sysView, dslSystemComponent.getType(), ((ImportOSSFileAction)ImportOSSFileAction.this).stereotypeUtil.blockStereotype, ((ImportOSSFileAction)ImportOSSFileAction.this).stereotypeUtil.systemStereotype);
                    ImportOSSFileAction.this.addedElements.add((Object)systemComponent);
                } else {
                    logger.debug((Object)"block already present");
                    systemComponent = (Class)ImportOSSFileAction.this.sysView.getOwnedMember(dslSystemComponentName, false, UMLFactory.eINSTANCE.createClass().eClass());
                    mapBlocks.put(blockQualifiedName, Boolean.TRUE);
                }
                ImportOSSFileAction.this.dslTypeToComponent.put(dslSystemComponentName, systemComponent);
                for (Component dslComponent : ocraOssFile.getComponents()) {
                    blockQualifiedName = String.valueOf(pkg.getQualifiedName()) + "::" + dslComponent.getType();
                    Class component = null;
                    if (!mapBlocks.containsKey(blockQualifiedName)) {
                        logger.debug((Object)("block not present: " + blockQualifiedName));
                        component = ImportOSSFileAction.this.entityUtil.createBlock(ImportOSSFileAction.this.sysView, dslComponent.getType(), ((ImportOSSFileAction)ImportOSSFileAction.this).stereotypeUtil.blockStereotype);
                        ImportOSSFileAction.this.addedElements.add((Object)component);
                    } else {
                        logger.debug((Object)("block already present: " + blockQualifiedName));
                        component = (Class)ImportOSSFileAction.this.sysView.getOwnedMember(dslComponent.getType(), false, UMLFactory.eINSTANCE.createClass().eClass());
                        mapBlocks.put(blockQualifiedName, Boolean.TRUE);
                    }
                    ImportOSSFileAction.this.dslTypeToComponent.put(dslComponent.getType(), component);
                }
                try {
                    ImportOSSFileAction.this.parseComponentInterfaces((AbstractComponent)dslSystemComponent);
                    for (Component dslComponent : ocraOssFile.getComponents()) {
                        ImportOSSFileAction.this.parseComponentInterfaces((AbstractComponent)dslComponent);
                    }
                    ImportOSSFileAction.this.parseComponentRefinements((AbstractComponent)dslSystemComponent);
                    for (Component dslComponent : ocraOssFile.getComponents()) {
                        ImportOSSFileAction.this.parseComponentRefinements((AbstractComponent)dslComponent);
                    }
                }
                catch (ImportException e) {
                    ImportOSSFileAction.this.importException = e;
                }
                for (String qualifiedElement : mapBlocks.keySet()) {
                    if (mapBlocks.get(qualifiedElement) != null) continue;
                    ImportOSSFileAction.this.removedElements.add(qualifiedElement);
                    ImportOSSFileAction.this.modifiedDiagrams.addAll(ImportOSSFileAction.this.chessElementsUtil.getInvolvedDiagrams(this.val$existingBlocks, qualifiedElement));
                    ImportOSSFileAction.this.entityUtil.removeElement(this.val$existingBlocks, qualifiedElement);
                }
                logger.debug((Object)("Total parsing time = " + (System.currentTimeMillis() - this.val$startTime) + "ms"));
            }
        });
        logger.debug((Object)("addedElements size = " + this.addedElements.size()));
        for (Object element : this.addedElements) {
            if (element instanceof NamedElement) {
                logger.debug((Object)("added/modified element = " + ((NamedElement)element).getQualifiedName()));
                continue;
            }
            logger.debug((Object)("added/modified element = " + element));
        }
        logger.debug((Object)("removedElements size = " + this.removedElements.size()));
        for (Object element : this.removedElements) {
            logger.debug((Object)("removed element = " + (String)element));
        }
        logger.debug((Object)("modifiedDiagrams size = " + this.modifiedDiagrams.size()));
        for (Object element : this.modifiedDiagrams) {
            logger.debug((Object)("modified diagram = " + (String)element));
        }
        if (this.importException != null) {
            throw this.importException;
        }
        return this.importErrors;
    }
}

