/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.commands;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.contracts.integration.ToolIntegration;
import org.polarsys.chess.contracts.profile.chesscontract.CHESSContractPackage;
import org.polarsys.chess.contracts.profile.chesscontract.ComponentInstance;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.DataTypes.ContractStatus;
import org.polarsys.chess.contracts.transformations.dialogs.RefinementResultDialog;
import org.polarsys.chess.contracts.transformations.main.Generate;
import org.polarsys.chess.contracts.transformations.main.GenerateErrorModel;
import org.polarsys.chess.contracts.transformations.main.GenerateFaultExtensions;
import org.polarsys.chess.core.util.uml.ResourceUtils;

public class CommandsCommon {
    public static final int NUM_SUB_TASKS = 4;

    public static void TransformationJob(final Shell activeShell, final IEditorPart editor, final List<String> args, final CommandEnum commandType, final String blockName, final String ftaCondition) {
        Job job = new Job("Analysis Running"){

            protected IStatus run(IProgressMonitor monitor) {
                block30: {
                    monitor.beginTask("operation in progress ...", 4);
                    monitor.subTask("setting up project folders (if needed)...");
                    System.out.println("setting up project folders (if needed)...");
                    IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
                    IFile inputfile = input.getFile();
                    IProject project = inputfile.getProject();
                    IFolder folder = null;
                    IFolder tempFolder = null;
                    folder = commandType == CommandEnum.FTA || commandType == CommandEnum.FEI ? project.getFolder("NuSMV3-XSAP") : project.getFolder("NuSMV3-OCRA");
                    IFolder results = folder.getFolder("Results");
                    IFolder files = folder.getFolder("Files");
                    try {
                        project.refreshLocal(2, null);
                        if (!folder.exists()) {
                            folder.create(true, true, null);
                        }
                        if (!results.exists()) {
                            results.create(true, true, null);
                        }
                        if (!files.exists()) {
                            files.create(true, true, null);
                        }
                        if (commandType == CommandEnum.FTA || commandType == CommandEnum.FEI) {
                            tempFolder = folder.getFolder("Temp");
                            if (tempFolder.exists()) {
                                tempFolder.delete(true, null);
                            }
                            tempFolder.create(true, true, null);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                    String resultFile = results.getLocation().toString();
                    String tempFiles = null;
                    if (commandType == CommandEnum.FTA || commandType == CommandEnum.FEI) {
                        tempFiles = tempFolder.getLocation().toString();
                    }
                    ToolIntegration checker = new ToolIntegration(activeShell, resultFile, tempFiles);
                    String stringToURI = inputfile.getFullPath().toString();
                    stringToURI = stringToURI.substring(0, stringToURI.lastIndexOf("."));
                    stringToURI = String.valueOf(stringToURI) + ".uml";
                    URI modelURI = URI.createPlatformResourceURI((String)stringToURI, (boolean)true);
                    File target = files.getLocation().toFile();
                    monitor.worked(1);
                    try {
                        try {
                            String systemName = null;
                            Generate gen = null;
                            String location = null;
                            String smvLocation = null;
                            String feiLocation = null;
                            String resultLocation = null;
                            switch (commandType) {
                                case REFINEMENT: {
                                    monitor.subTask("transforming uml model...");
                                    systemName = ((String)args.get(0)).substring(((String)args.get(0)).lastIndexOf("::") + 2);
                                    gen = new Generate(modelURI, target, (List<? extends Object>)args);
                                    gen.doGenerate(null);
                                    monitor.worked(1);
                                    location = target + File.separator + (String)args.get(2);
                                    location = String.valueOf(location) + "_" + systemName + ".oss";
                                    monitor.subTask("performing refinement check analysis...");
                                    resultLocation = checker.checkRefinement(location);
                                    break;
                                }
                                case VALIDPROP: {
                                    monitor.subTask("transforming uml model...");
                                    systemName = ((String)args.get(0)).substring(((String)args.get(0)).lastIndexOf("::") + 2);
                                    gen = new Generate(modelURI, target, (List<? extends Object>)args);
                                    gen.doGenerate(null);
                                    monitor.worked(1);
                                    location = target + File.separator + (String)args.get(2);
                                    location = String.valueOf(location) + "_" + systemName + ".oss";
                                    monitor.subTask("Checking all validation properties...");
                                    resultLocation = checker.checkValidationProp(location);
                                    break;
                                }
                                case IMPLEMENTATION: {
                                    monitor.subTask("transforming uml model...");
                                    systemName = ((String)args.get(0)).substring(((String)args.get(0)).lastIndexOf("::") + 2);
                                    gen = new Generate(modelURI, target, (List<? extends Object>)args);
                                    gen.doGenerate(null);
                                    monitor.worked(1);
                                    location = target + File.separator + (String)args.get(2);
                                    location = String.valueOf(location) + "_" + systemName + ".oss";
                                    monitor.subTask("performing implementation check analysis...");
                                    String name = blockName.substring(blockName.lastIndexOf("::") + 2);
                                    smvLocation = target + File.separator + name + ".smv";
                                    checker.checkImplementation(location, smvLocation, name);
                                    break;
                                }
                                case FTA: {
                                    systemName = ((String)args.get(0)).substring(((String)args.get(0)).lastIndexOf("::") + 2);
                                    monitor.subTask("transforming uml model... (SMV)");
                                    System.out.println("transforming uml model... (SMV)");
                                    GenerateErrorModel genFTA = new GenerateErrorModel(modelURI, target, (List<? extends Object>)args);
                                    genFTA.doGenerate(null);
                                    monitor.worked(1);
                                    monitor.subTask("transforming uml model... (Fault Extensions)");
                                    System.out.println("transforming uml model... (Fault Extensions)");
                                    GenerateFaultExtensions genFex = new GenerateFaultExtensions(modelURI, target, (List<? extends Object>)args);
                                    genFex.doGenerate(null);
                                    feiLocation = smvLocation = target + File.separator + (String)args.get(2);
                                    smvLocation = String.valueOf(smvLocation) + ".smv";
                                    feiLocation = String.valueOf(feiLocation) + ".fei";
                                    monitor.subTask("calling xSAP");
                                    System.out.println("calling xSAP");
                                    checker.FTA(smvLocation, feiLocation, ftaCondition);
                                    monitor.worked(1);
                                    break;
                                }
                                case FEI: {
                                    systemName = ((String)args.get(0)).substring(((String)args.get(0)).lastIndexOf("::") + 2);
                                    monitor.subTask("transforming uml model... (Fault Extensions)");
                                    GenerateFaultExtensions genFei = new GenerateFaultExtensions(modelURI, target, (List<? extends Object>)args);
                                    genFei.doGenerate(null);
                                    feiLocation = smvLocation = target + File.separator + (String)args.get(2);
                                    smvLocation = String.valueOf(smvLocation) + ".smv";
                                    feiLocation = String.valueOf(feiLocation) + ".fei";
                                    break;
                                }
                            }
                            monitor.worked(1);
                            if (resultLocation != null) {
                                FileInputStream fstream = new FileInputStream(resultLocation);
                                DataInputStream in = new DataInputStream(fstream);
                                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                                String text = "";
                                String line = "";
                                while ((line = br.readLine()) != null) {
                                    if (line.startsWith("*")) continue;
                                    text = String.valueOf(text) + line;
                                    text = String.valueOf(text) + "\n";
                                }
                                fstream.close();
                                in.close();
                                br.close();
                                CommandsCommon.openRefinementResult(text);
                                if (commandType.equals((Object)CommandEnum.VALIDPROP)) {
                                    CommandsCommon.updateWeakContractStatus(editor, args, text);
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                monitor.subTask("refreshing...");
                                project.refreshLocal(2, monitor);
                                monitor.worked(1);
                            }
                            catch (CoreException e2) {
                                e2.printStackTrace();
                            }
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            monitor.subTask("refreshing...");
                            project.refreshLocal(2, monitor);
                            monitor.worked(1);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        monitor.subTask("refreshing...");
                        project.refreshLocal(2, monitor);
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                monitor.done();
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
    }

    private static void openRefinementResult(final String text) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                RefinementResultDialog dialog = new RefinementResultDialog(shell, text);
                dialog.open();
            }
        });
    }

    private static void updateWeakContractStatus(final IEditorPart eobject, final List<String> args, final String text) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PapyrusMultiDiagramEditor editor = (PapyrusMultiDiagramEditor)eobject;
                    TransactionalEditingDomain tdom = (TransactionalEditingDomain)editor.getEditingDomain();
                    Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
                    Model model = ResourceUtils.getModel((Resource)res);
                    Package sysView = null;
                    Package compView = null;
                    ArrayList<Property> allContractProperties = new ArrayList<Property>();
                    ArrayList<Property> allCompInst = new ArrayList<Property>();
                    for (Package pkg : model.getNestedPackages()) {
                        if (pkg.getAppliedStereotype("CHESS::Core::CHESSViews::SystemView") != null) {
                            sysView = pkg;
                        }
                        if (pkg.getAppliedStereotype("CHESS::Core::CHESSViews::ComponentView") == null) continue;
                        compView = pkg;
                    }
                    if (sysView != null) {
                        for (Element elem : sysView.allOwnedElements()) {
                            if (!(elem instanceof Property)) continue;
                            if (elem.getAppliedStereotype("CHESSContract::ContractProperty") != null) {
                                allContractProperties.add((Property)elem);
                                continue;
                            }
                            if (elem.getAppliedStereotype("CHESSContract::ComponentInstance") == null) continue;
                            allCompInst.add((Property)elem);
                        }
                    }
                    if (compView != null) {
                        for (Element elem : compView.allOwnedElements()) {
                            if (!(elem instanceof Property) || elem.getAppliedStereotype("CHESSContract::ContractProperty") == null) continue;
                            allContractProperties.add((Property)elem);
                        }
                    }
                    for (Property prop : allContractProperties) {
                        ContractProperty contractProp = (ContractProperty)prop.getStereotypeApplication(prop.getAppliedStereotype("CHESSContract::ContractProperty"));
                        System.out.println(String.valueOf(prop.getName()) + " " + contractProp.getStatus());
                    }
                    if (((String)args.get(3)).equalsIgnoreCase("true") && !text.isEmpty()) {
                        HashMap selectedWeakContracts = new HashMap();
                        for (Property property : allContractProperties) {
                            Stereotype contrPropStereo = property.getAppliedStereotype("CHESSContract::ContractProperty");
                            Class block = (Class)property.getOwner();
                            if (!selectedWeakContracts.containsKey(block)) {
                                selectedWeakContracts.put(block, new ArrayList());
                            }
                            ContractProperty contractProp = (ContractProperty)property.getStereotypeApplication(contrPropStereo);
                            String match1 = "Consistency " + block.getName() + "_" + property.getName() + "_consistency: [OK]";
                            String match11 = "Consistency " + block.getName() + "_" + property.getName() + "_consistency: OK";
                            String match2 = "Consistency " + block.getName() + "_" + property.getName() + "_consistency: [NOT OK]";
                            String match22 = "Consistency " + block.getName() + "_" + property.getName() + "_consistency: NOT OK";
                            System.out.println(match1);
                            if (text.indexOf(match1) != -1 || text.indexOf(match11) != -1) {
                                tdom.getCommandStack().execute(SetCommand.create((EditingDomain)editor.getEditingDomain(), (Object)contractProp, (Object)CHESSContractPackage.eINSTANCE.getContractProperty_Status(), (Object)ContractStatus.VALIDATED));
                                ((List)selectedWeakContracts.get(block)).add(contractProp);
                                continue;
                            }
                            if (text.indexOf(match2) == -1 && text.indexOf(match22) == -1) continue;
                            tdom.getCommandStack().execute(SetCommand.create((EditingDomain)editor.getEditingDomain(), (Object)contractProp, (Object)CHESSContractPackage.eINSTANCE.getContractProperty_Status(), (Object)ContractStatus.NOT_VALIDATED));
                        }
                        for (Map.Entry entry : selectedWeakContracts.entrySet()) {
                            for (Property compInstProp : allCompInst) {
                                if (!compInstProp.getType().equals(entry.getKey())) continue;
                                ComponentInstance compInstStereo = (ComponentInstance)compInstProp.getStereotypeApplication(compInstProp.getAppliedStereotype("CHESSContract::ComponentInstance"));
                                tdom.getCommandStack().execute(SetCommand.create((EditingDomain)editor.getEditingDomain(), (Object)compInstStereo, (Object)CHESSContractPackage.eINSTANCE.getComponentInstance_WeakGuarantees(), entry.getValue()));
                            }
                        }
                    }
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static enum CommandEnum {
        REFINEMENT,
        IMPLEMENTATION,
        FTA,
        FEI,
        VALIDPROP;

    }
}

