/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.verificationService.ui.commands;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.SelectArchitectureConfigurationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.service.core.exceptions.NoComponentException;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.core.utils.FileNamesUtil;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class CheckValidationAssertionPropertyCommand
extends AbstractJobCommand {
    private static final Logger logger = Logger.getLogger(CheckValidationAssertionPropertyCommand.class);
    private ChessSystemModel chessToOCRAModelTranslator = ChessSystemModel.getInstance();
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)this.chessToOCRAModelTranslator);
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
    private AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();
    private Class umlSelectedComponent;
    private InstantiatedArchitectureConfiguration selectedInstantiatedArchitectureConfiguration;
    private Resource umlSelectedResource;
    private boolean isDiscreteTime;
    private boolean showPopups;
    private boolean usexTextValidation;
    private String ossFilepath;
    private String resultFilePath;
    private boolean commandExecuted;
    EList<String> conditions;
    private List<AnalysisContextElement> contextList;

    public CheckValidationAssertionPropertyCommand() {
        super("Check Validation Property");
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        try {
            this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        }
        catch (NoComponentException noComponentException) {
            this.umlSelectedComponent = this.analysisResultUtil.getSystemComponentFromEvent(event);
        }
        this.umlSelectedResource = this.umlSelectedComponent.eResource();
        this.isDiscreteTime = MessageTimeModelDialog.openQuestion((boolean)false);
        this.showPopups = false;
        this.usexTextValidation = true;
        this.ossFilepath = this.ocraDirectoryUtil.getOSSDirPath();
        this.resultFilePath = FileNamesUtil.getInstance().computePropertyValidationFileName(this.umlSelectedComponent);
        PapyrusMultiDiagramEditor editorPapyrus = CHESSEditorUtils.getCHESSEditor();
        Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editorPapyrus.getServicesRegistry());
        Model model = ResourceUtils.getModel((Resource)res);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        EList instantiatedArchitecures = EntityUtil.getInstance().getInstantiatedArchitecureConfigurations(this.umlSelectedComponent);
        if (instantiatedArchitecures != null && !instantiatedArchitecures.isEmpty()) {
            SelectArchitectureConfigurationDialog dialog = new SelectArchitectureConfigurationDialog(shell, (AbstractSystemModel)ChessSystemModel.getInstance(), instantiatedArchitecures);
            dialog.open();
            if (dialog.goAhead()) {
                this.selectedInstantiatedArchitectureConfiguration = (InstantiatedArchitectureConfiguration)dialog.getSelectedAchitectureConfiguration();
                String configurationName = ChessSystemModel.getInstance().getInstantiatedArchitectureConfigurationName((Object)this.selectedInstantiatedArchitectureConfiguration);
                this.resultFilePath = this.ocraDirectoryUtil.getCommandCheckPropertyResultPath(configurationName);
            }
        }
        this.contextList = AnalysisResultUtil.getInstance().getAnalysisContexts(this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, Analysis.PROPERTY_VALIDATION_ANALYSIS, model);
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
    }

    private EList<String> createConditions(String[] expression) {
        BasicEList conditions = new BasicEList();
        if (expression != null) {
            String[] stringArray = expression;
            int n = expression.length;
            int n2 = 0;
            while (n2 < n) {
                String currExp = stringArray[n2];
                logger.debug((Object)("currExp: " + currExp));
                ++n2;
            }
            StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"check_type", (String)expression[0]);
            StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"selected_components", (String)expression[1]);
            StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"selected_properties", (String)expression[2]);
            if (expression.length == 4) {
                StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"property", (String)expression[3]);
            }
        }
        return conditions;
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
        String[] expression = new String[1];
        this.commandExecuted = this.ocraExecService.executeValidationAssertionProperty((Object)this.umlSelectedComponent, (Object)this.selectedInstantiatedArchitectureConfiguration, this.umlSelectedResource, this.isDiscreteTime, this.usexTextValidation, this.showPopups, this.ossFilepath, this.resultFilePath, (IProgressMonitor)nullProgressMonitor, true, expression, this.contextList);
        if (this.commandExecuted) {
            this.conditions = this.createConditions(expression[0].split("#"));
        }
        if (this.commandExecuted) {
            this.analysisResultUtil.createOrUpdateAnalysisContext(Analysis.PROPERTY_VALIDATION_ANALYSIS, this.conditions, this.resultFilePath, false, this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, null);
            this.analysisResultUtil.showResult("ocra_check_validation_prop", this.resultFilePath);
        }
    }
}

