/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.verificationService.ui.commands;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.ui.services.SmvExportServiceUI;
import eu.fbk.eclipse.standardtools.nuXmvService.ui.utils.NuXmvDirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.SelectArchitectureConfigurationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.exceptions.NoComponentException;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.model.UMLStateMachineModel;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.core.utils.FileNamesUtil;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class CompositeContractImplementationCommand
extends AbstractJobCommand {
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private SmvExportServiceUI smvExportService = SmvExportServiceUI.getInstance((AbstractSystemModel)ChessSystemModel.getInstance(), (AbstractStateMachineModel)UMLStateMachineModel.getInstance());
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
    private NuXmvDirectoryUtil nuXmvDirectoryUtil = NuXmvDirectoryUtil.getInstance();
    private AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();
    private Class umlSelectedComponent;
    private InstantiatedArchitectureConfiguration selectedInstantiatedArchitectureConfiguration;
    private Resource umlSelectedResource;
    private boolean isDiscreteTime;
    private boolean showPopups;
    private boolean usexTextValidation;
    private String smvMapDirPath;
    private String smvFilePath;
    private String resultFilePath;
    private String ossDirPath;
    private boolean commandExecuted;

    public CompositeContractImplementationCommand() {
        super("Check Compositional Contract Implementation");
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        try {
            this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        }
        catch (NoComponentException noComponentException) {
            this.umlSelectedComponent = this.analysisResultUtil.getSystemComponentFromEvent(event);
        }
        this.umlSelectedResource = this.umlSelectedComponent.eResource();
        this.isDiscreteTime = MessageTimeModelDialog.openQuestion((boolean)true);
        this.showPopups = false;
        this.usexTextValidation = true;
        this.ossDirPath = this.ocraDirectoryUtil.getOSSDirPath();
        this.smvMapDirPath = this.nuXmvDirectoryUtil.getSmvFileDirectory();
        this.smvFilePath = this.nuXmvDirectoryUtil.getSmvFileDirectory();
        this.resultFilePath = FileNamesUtil.getInstance().computeContractCompositeImplementationFileName(this.umlSelectedComponent);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        EList instantiatedArchitecures = EntityUtil.getInstance().getInstantiatedArchitecureConfigurations(this.umlSelectedComponent);
        if (instantiatedArchitecures != null && !instantiatedArchitecures.isEmpty()) {
            SelectArchitectureConfigurationDialog dialog = new SelectArchitectureConfigurationDialog(shell, (AbstractSystemModel)ChessSystemModel.getInstance(), instantiatedArchitecures);
            dialog.open();
            if (dialog.goAhead()) {
                this.selectedInstantiatedArchitectureConfiguration = (InstantiatedArchitectureConfiguration)dialog.getSelectedAchitectureConfiguration();
            }
        }
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        HashMap smvPathComponentNameMap = this.smvExportService.exportSmv((Object)this.umlSelectedComponent, this.showPopups, this.smvFilePath, monitor);
        this.commandExecuted = this.ocraExecService.executeCheckCompositeContractImplementation((Object)this.umlSelectedComponent, this.umlSelectedResource, smvPathComponentNameMap, this.isDiscreteTime, this.usexTextValidation, this.showPopups, this.ossDirPath, this.smvMapDirPath, this.resultFilePath, monitor, true);
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
        if (this.commandExecuted) {
            this.analysisResultUtil.createOrUpdateAnalysisContext(Analysis.CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS, ECollections.emptyEList(), this.resultFilePath, false, this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, null);
            this.analysisResultUtil.showResult("ocra_check_composite_impl", this.resultFilePath);
        }
    }
}

