/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flaxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FailureType implements Enumerator
{
    NO_FAILURE(0, "noFailure", "noFailure"),
    LATE(1, "late", "late"),
    EARLY(2, "early", "early"),
    VALUE_SUBTLE(3, "valueSubtle", "valueSubtle"),
    VALUE_COARSE(4, "valueCoarse", "valueCoarse"),
    OMISSION(5, "omission", "omission"),
    COMMISSION(6, "commission", "commission");

    public static final int NO_FAILURE_VALUE = 0;
    public static final int LATE_VALUE = 1;
    public static final int EARLY_VALUE = 2;
    public static final int VALUE_SUBTLE_VALUE = 3;
    public static final int VALUE_COARSE_VALUE = 4;
    public static final int OMISSION_VALUE = 5;
    public static final int COMMISSION_VALUE = 6;
    private static final FailureType[] VALUES_ARRAY;
    public static final List<FailureType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FailureType[]{NO_FAILURE, LATE, EARLY, VALUE_SUBTLE, VALUE_COARSE, OMISSION, COMMISSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FailureType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FailureType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FailureType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FailureType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FailureType get(int value) {
        switch (value) {
            case 0: {
                return NO_FAILURE;
            }
            case 1: {
                return LATE;
            }
            case 2: {
                return EARLY;
            }
            case 3: {
                return VALUE_SUBTLE;
            }
            case 4: {
                return VALUE_COARSE;
            }
            case 5: {
                return OMISSION;
            }
            case 6: {
                return COMMISSION;
            }
        }
        return null;
    }

    private FailureType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

