/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.paramArchConfigurator.ui.wizard;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.PackageViewFilter;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.page.LastPage;

public class TreeSelector {
    private static final Logger logger = Logger.getLogger(TreeSelector.class);
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private TreeViewer treeViewer;
    private Composite composite;
    private Object input = null;
    private Object[] result;
    LastPage lastPage;
    private final Set<ICommitListener> commitListeners = new HashSet<ICommitListener>();

    public TreeSelector(Composite composite, LastPage lastPage) {
        this.composite = composite;
        this.lastPage = lastPage;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
        if (this.treeViewer != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this.contentProvider = provider;
        if (this.treeViewer != null) {
            this.initViewerAndProvider();
        }
        if (this.contentProvider instanceof ICommitListener) {
            this.commitListeners.add((ICommitListener)this.contentProvider);
        }
    }

    protected void initViewerAndProvider() {
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        if (this.treeViewer.getInput() == null) {
            this.doSetInput();
        }
    }

    protected Composite getDialogArea() {
        return this.composite;
    }

    public void create() {
        this.treeViewer = new TreeViewer(this.getDialogArea(), 2048);
        if (this.labelProvider != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        if (this.contentProvider != null) {
            this.initViewerAndProvider();
        }
        this.treeViewer.addFilter((ViewerFilter)new PackageViewFilter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Object selectedElement = null;
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    IStructuredSelection sSelection = (IStructuredSelection)selection;
                    selectedElement = sSelection.getFirstElement();
                }
                if (TreeSelector.this.contentProvider instanceof IHierarchicContentProvider) {
                    boolean isValidValue = ((IHierarchicContentProvider)TreeSelector.this.contentProvider).isValidValue(selectedElement);
                    if (TreeSelector.this.contentProvider instanceof IAdaptableContentProvider) {
                        selectedElement = ((IAdaptableContentProvider)TreeSelector.this.contentProvider).getAdaptedValue(selectedElement);
                    }
                    if (TreeSelector.this.lastPage.importArchitecture()) {
                        if (isValidValue) {
                            TreeSelector.this.setResult(Collections.singletonList(selectedElement));
                        } else {
                            TreeSelector.this.setResult(Collections.emptyList());
                        }
                        TreeSelector.this.lastPage.setPageComplete(isValidValue);
                    }
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 300;
        data.minimumWidth = 300;
        this.treeViewer.getTree().setLayoutData((Object)data);
        if (this.contentProvider instanceof IGraphicalContentProvider) {
            IGraphicalContentProvider graphicalContentProvider = (IGraphicalContentProvider)this.contentProvider;
            Composite beforeTreeComposite = new Composite(this.getDialogArea(), 0);
            beforeTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            beforeTreeComposite.setLayout((Layout)new FillLayout());
            graphicalContentProvider.createBefore(beforeTreeComposite);
            beforeTreeComposite.moveAbove((Control)this.treeViewer.getTree());
        }
    }

    protected TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    private void doSetInput() {
        if (this.input == null) {
            this.treeViewer.setInput((Object)"");
        } else {
            this.treeViewer.setInput(this.input);
        }
    }

    protected void setResult(List<Object> newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    public Object[] getResult() {
        return this.result;
    }
}

