/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.paramArchConfigurator.ui.wizard.page;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.TreeSelector;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.page.BasicWizardPage;
import org.polarsys.chess.service.core.model.ChessSystemModel;

public class LastPage
extends BasicWizardPage {
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private File newOssFile;
    private File paramListFile;
    private Composite container;
    private EObject selectedElement;
    private TreeSelector treeSelector;
    private Button checkCreatePackage;
    private Button checkImport;
    private static final Logger logger = Logger.getLogger(LastPage.class);

    public LastPage(EObject selectedElement, File newOssFile, EList<EList<String>> prevParametersList) throws Exception {
        super("Arctitecture Instantiated", prevParametersList);
        this.setTitle("Parameterized Architecture Instantiated");
        this.setDescription("Instantiation Completed.");
        this.selectedElement = selectedElement;
        this.newOssFile = newOssFile;
        if (prevParametersList != null && newOssFile != null) {
            this.paramListFile = this.ocraExecService.prepareFinalParameterValuesFile(prevParametersList, "final_" + newOssFile.getName());
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.container = new Composite(parent, 2048);
        GridLayout containerLayout = new GridLayout(2, true);
        this.container.setLayout((Layout)containerLayout);
        this.createViewPrevParametersArea(this.container);
        this.createSelectPackageArea(this.container);
        this.container.redraw();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    protected void createSelectPackageArea(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        GridData gd = new GridData(4, 4, true, true);
        sc.setLayoutData((Object)gd);
        Composite scrolledContent = new Composite((Composite)sc, 2048);
        scrolledContent.setLayout((Layout)new GridLayout(1, false));
        scrolledContent.setLayoutData((Object)gd);
        Composite importArchComposite = new Composite(scrolledContent, 0);
        importArchComposite.setLayout((Layout)new GridLayout(2, false));
        Label labelImport = new Label(importArchComposite, 0);
        labelImport.setText("Import the instantiated architecture.");
        this.checkImport = new Button(importArchComposite, 32);
        this.checkImport.setSelection(true);
        this.checkImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LastPage.this.setPageComplete(!LastPage.this.checkImport.getSelection());
            }
        });
        Label labelCheck = new Label(scrolledContent, 0);
        labelCheck.setText("Select the destination package of the instantiated architecture.");
        Composite createPackageComposite = new Composite(scrolledContent, 0);
        createPackageComposite.setLayout((Layout)new GridLayout(2, false));
        this.checkCreatePackage = new Button(createPackageComposite, 32);
        this.checkCreatePackage.setSelection(true);
        Label newPackageLabel = new Label(createPackageComposite, 0);
        newPackageLabel.setText("Create a nested package in the destination package.");
        this.createTreeSelector(scrolledContent);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setContent((Control)scrolledContent);
        sc.setMinSize(scrolledContent.computeSize(-1, -1));
    }

    public Package getSelectedPackage() {
        if (this.treeSelector != null && this.treeSelector.getResult() != null) {
            return (Package)this.treeSelector.getResult()[0];
        }
        return null;
    }

    public boolean createNestedPackage() {
        return this.checkCreatePackage.getSelection();
    }

    public boolean importArchitecture() {
        return this.checkImport.getSelection();
    }

    public String getNestedPackageName() {
        return FilenameUtils.removeExtension((String)this.newOssFile.getName());
    }

    public File getOSSFile() {
        return this.newOssFile;
    }

    public File getParamListFile() {
        return this.paramListFile;
    }

    private void createTreeSelector(Composite scrolledContent) {
        this.treeSelector = new TreeSelector(scrolledContent, this);
        Package pkg = EntityUtil.getInstance().getToPackage((Element)this.selectedElement);
        UMLContentProvider provider = new UMLContentProvider((EObject)pkg, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement());
        this.treeSelector.setContentProvider((ITreeContentProvider)provider);
        this.treeSelector.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        this.treeSelector.create();
    }
}

