/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class SupersuserToggleCommand
extends AbstractHandler
implements IElementUpdater {
    private boolean selected = false;
    String uncheckedText = "Enable superuser: deactivate write permission checking";
    String checkedText = "Disable superuser: activate write permission checking";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (CHESSEditorUtils.isCHESSProject(editor) && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus diagramStatus = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)editor);
            if (diagramStatus == null) {
                return null;
            }
            this.selected = !this.selected;
            diagramStatus.setSuperuser(this.selected);
            CHESSProjectSupport.printlnToCHESSConsole((String)("Superuser " + (this.selected ? "ON" : "OFF")));
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        if (editor != null && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus st = CHESSEditorUtils.getDiagramStatus(editor);
            this.selected = st.isSuperuser();
        }
        element.setChecked(this.selected);
        element.setText(this.selected ? this.checkedText : this.uncheckedText);
    }
}

