/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.constraints;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParser {
    public double getValuePattern(String value, String toSearch) {
        String[] array = value.split("[()=, ]");
        int i = 0;
        while (i < array.length - 1) {
            int j = i + 1;
            while (j < array.length) {
                if (array[i].equalsIgnoreCase(toSearch) && array[j].equalsIgnoreCase("value")) {
                    String d = array[j + 1];
                    return Double.valueOf(d.trim());
                }
                ++j;
            }
            ++i;
        }
        return -1.0;
    }

    public String getUnitPattern(String value, String toSearch) {
        String[] array = value.split("[()=, ]");
        int i = 0;
        while (i < array.length - 1) {
            int j = i + 1;
            while (j < array.length) {
                if (array[i].equalsIgnoreCase(toSearch) && array[j].equalsIgnoreCase("unit")) {
                    String d = array[j + 1];
                    return d.trim();
                }
                ++j;
            }
            ++i;
        }
        return "INVALID";
    }

    public String getComplexValuePattern(String value, String toSearch, String delimiter) {
        value.split("[()=, ]");
        Pattern p = Pattern.compile(".*" + toSearch + ".*value.*" + delimiter + "(.*)" + delimiter, 2);
        Matcher m = p.matcher(value);
        String group = "";
        if (m.find()) {
            group = m.group(1);
        }
        return group;
    }

    public double getValueNFP(String value) {
        String[] array = value.split("[()=,]");
        int i = 0;
        while (i < array.length - 1) {
            if (array[i].trim().equalsIgnoreCase("value")) {
                String d = array[i + 1].trim();
                return Double.valueOf(d);
            }
            ++i;
        }
        return -1.0;
    }

    public String getUnitNFP(String value) {
        String[] array = value.split("[()=,]");
        int i = 0;
        while (i < array.length - 1) {
            if (array[i].trim().equalsIgnoreCase("unit")) {
                String d = array[i + 1].trim();
                return d;
            }
            ++i;
        }
        return "INVALID";
    }

    public double getDoubleValue(String value) {
        try {
            value = value.trim();
            return Double.valueOf(value);
        }
        catch (Exception exception) {
            return -1.0;
        }
    }
}

