/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.codegen.ada.handlers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaResourcesPlatform;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaAnalysisContext;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.codegen.ada.transformations.Transformations;
import org.polarsys.chess.codegen.ada.util.AdaGenUtil;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.m2m.transformations.PIMPSMTransformationVERDE;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class AdaGenUIHandler
extends AbstractHandler {
    Resource inResource = null;
    private Class contextClass;
    private TransactionalEditingDomain transactionalEditingDomain;
    private Class analysisContextClass;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        final Shell shell = window.getShell();
        if (!CHESSEditorUtils.isCHESSProject((IEditorPart)editor)) {
            return null;
        }
        if (editor.isDirty() && !MessageDialog.openQuestion((Shell)shell, (String)"CHESS code generation", (String)"Model must be saved first, do you want to continue?")) {
            return null;
        }
        try {
            this.inResource = ResourceUtils.getUMLResource((ServicesRegistry)((PapyrusMultiDiagramEditor)editor).getServicesRegistry());
            ModelSet x = (ModelSet)this.inResource.getResourceSet();
            this.transactionalEditingDomain = x.getTransactionalEditingDomain();
        }
        catch (ServiceException serviceException) {
            MessageDialog.openError((Shell)shell, (String)"CHESS", (String)"Unable to load the model");
            return null;
        }
        final Model model = (Model)this.inResource.getContents().get(0);
        final DiagramStatus diagramStatus = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)((PapyrusMultiDiagramEditor)editor));
        Job job = new Job("Transforming"){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor;
                block19: {
                    block18: {
                        block16: {
                            try {
                                subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                                subMonitor.beginTask("Transforming", 100);
                                if (diagramStatus != null) break block16;
                                return null;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                e.printStackTrace(pw);
                                CHESSProjectSupport.printlnToCHESSConsole((String)sw.toString());
                                return new Status(4, "org.polarsys.chess.m2m", 1, "Error in transformation " + e.getMessage(), null);
                            }
                        }
                        boolean oldSuperUserStatus = diagramStatus.isSuperuser();
                        diagramStatus.setSuperuser(true);
                        subMonitor.subTask("Generating AnalysisContext");
                        AdaGenUIHandler.this.contextClass = null;
                        try {
                            try {
                                AdaGenUIHandler.this.contextClass = AdaGenUIHandler.this.createAnalysisContext(shell, model);
                                ((PapyrusMultiDiagramEditor)editor).doSave((IProgressMonitor)subMonitor.newChild(5));
                            }
                            catch (ModelError e1) {
                                MessageDialog.openError((Shell)shell, (String)"CHESS", (String)("Unable to create analysis context: " + e1.getMessage()));
                                diagramStatus.setSuperuser(oldSuperUserStatus);
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            diagramStatus.setSuperuser(oldSuperUserStatus);
                            throw throwable;
                        }
                        diagramStatus.setSuperuser(oldSuperUserStatus);
                    }
                    if (AdaGenUIHandler.this.contextClass != null) break block19;
                    return null;
                }
                IFile filecopy = null;
                subMonitor.subTask("Generating PSM");
                try {
                    filecopy = AdaGenUIHandler.this.performPIM2PSMtransformation(AdaGenUIHandler.this.inResource, AdaGenUIHandler.this.contextClass, editor, (IProgressMonitor)subMonitor.newChild(55));
                    CHESSEditorUtils.reopenEditor((IEditorPart)editor, (Boolean)false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                subMonitor.subTask("Generating code");
                try {
                    AdaGenUIHandler.this.execute_(editor, (IProgressMonitor)subMonitor.newChild(40), AdaGenUIHandler.this.contextClass, filecopy);
                }
                finally {
                    AdaGenUtil.getActiveProject(editor).refreshLocal(2, (IProgressMonitor)subMonitor.newChild(5));
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job completed successfully");
                } else {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job did not complete successfully");
                }
            }
        });
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    protected IFile performPIM2PSMtransformation(Resource inResource, Class contextClass, IEditorPart editor, IProgressMonitor monitor) throws Exception {
        IFile inputFile = CHESSProjectSupport.resourceToFile((Resource)inResource);
        PIMPSMTransformationVERDE t = new PIMPSMTransformationVERDE();
        HashMap<String, String> configProps = new HashMap<String, String>();
        configProps.put("saAnalysis", contextClass.getQualifiedName());
        configProps.put("analysisType", "Schedulability");
        t.setConfigProperty(configProps);
        t.setPsmPackageName(String.valueOf(contextClass.getName()) + "_PSM");
        return t.performPIM2PSMtransformation((PapyrusMultiDiagramEditor)editor, inputFile, monitor, true);
    }

    private void execute_(IEditorPart editor, IProgressMonitor monitor, Class contextClass, IFile inputFile) throws Exception {
        if (!(editor instanceof PapyrusMultiDiagramEditor)) {
            return;
        }
        String saAnalysisName = contextClass.getQualifiedName();
        Transformations.performXMLGeneration(inputFile, saAnalysisName, monitor);
        Transformations.performCodeGeneration((PapyrusMultiDiagramEditor)editor, inputFile, monitor);
    }

    private Class createAnalysisContext(final Shell activeShell, final Model model) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype((Model)model, (String)"AnalysisView");
        for (Package pkg : parent.getNestedPackages()) {
            Stereotype x = pkg.getAppliedStereotype("CHESS::Core::CHESSViews::RTAnalysisView");
            if (x == null) continue;
            parent = pkg;
        }
        final Package aView = parent;
        this.transactionalEditingDomain.getCommandStack().execute((Command)new RecordingCommand(this.transactionalEditingDomain){

            public void doExecute() {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                    Date date = new Date(System.currentTimeMillis());
                    AdaGenUIHandler.this.analysisContextClass = aView.createOwnedClass("CodeGen" + dateFormat.format(date), false);
                    UMLUtils.applyStereotype((Element)AdaGenUIHandler.this.analysisContextClass, (String)"MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext");
                    SaAnalysisContext saAnalysisContext = (SaAnalysisContext)UMLUtils.getStereotypeApplication((Element)AdaGenUIHandler.this.analysisContextClass, SaAnalysisContext.class);
                    Package cmpv = CHESSProfileManager.getViewByStereotype((Model)model, (String)"DeploymentView");
                    Package resourcePlatformHW = UMLUtils.getResourcePlatformPackage((Package)cmpv);
                    GaResourcesPlatform gaHW = (GaResourcesPlatform)UMLUtils.getStereotypeApplication((Element)resourcePlatformHW, GaResourcesPlatform.class);
                    saAnalysisContext.getPlatform().add((Object)gaHW);
                    cmpv = CHESSProfileManager.getViewByStereotype((Model)model, (String)"ComponentView");
                    Package resourcePlatformSW = UMLUtils.getResourcePlatformPackage((Package)cmpv);
                    GaResourcesPlatform gaSW = (GaResourcesPlatform)UMLUtils.getStereotypeApplication((Element)resourcePlatformSW, GaResourcesPlatform.class);
                    saAnalysisContext.getPlatform().add((Object)gaSW);
                    if (!UMLUtils.checkPlatformsInContext((SaAnalysisContext)saAnalysisContext, (Model)model)) {
                        MessageDialog.openWarning((Shell)activeShell, (String)"CHESS", (String)"Context must specify a SW and a HW instance platform!");
                    }
                }
                catch (Exception exception) {
                    MessageDialog.openWarning((Shell)activeShell, (String)"CHESS", (String)"Cannot create analysis context");
                }
            }
        });
        return this.analysisContextClass;
    }
}

