/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSShapeImpl;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.BlockDefinitionDiagramCreateCommand;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.AssociationEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.BlockEditPart;
import org.eclipse.papyrus.uml.diagram.common.actions.AbstractShowHideAction;
import org.eclipse.papyrus.uml.diagram.common.actions.ShowHideContentsAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.diagramsCreator.utils.DiagramUtils;

public class ShowBDDElementsAction
extends ShowHideContentsAction {
    private static final int MIN_WIDTH = 150;
    private static final int MAX_WIDTH = 1500;
    private static final int MIN_HEIGHT = 150;
    private static final int MAX_HEIGHT = 1500;
    private final EntityUtil entityUtil = EntityUtil.getInstance();
    private final ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private final DiagramUtils diagramUtils = DiagramUtils.getInstance();
    private List<Object> selection;
    private Set<DisplayableElement> elementsToDisplay = new HashSet<DisplayableElement>();
    private static final Logger logger = Logger.getLogger(ShowBDDElementsAction.class);
    private static ShowBDDElementsAction classInstance;

    public ShowBDDElementsAction() {
        this.elementsToDisplay.add(DisplayableElement.PORT);
        this.elementsToDisplay.add(DisplayableElement.DELEGATION_CONSTRAINT);
        this.elementsToDisplay.add(DisplayableElement.CONTRACT_PROPERTY);
    }

    public static ShowBDDElementsAction getInstance() {
        if (classInstance == null) {
            classInstance = new ShowBDDElementsAction();
        }
        return classInstance;
    }

    public Diagram addBDD(Package owner) throws Exception {
        ServicesRegistry servicesRegistry = ServiceUtilsForResource.getInstance().getServiceRegistry(owner.eResource());
        ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        BlockDefinitionDiagramCreateCommand command = new BlockDefinitionDiagramCreateCommand();
        return command.createDiagram(modelSet, (EObject)owner, String.valueOf(owner.getName()) + "_BDD");
    }

    private int[] getSize(Element element) {
        int width = 0;
        int height = 0;
        int maxLength = 0;
        int childrenNumber = 0;
        int[] size = new int[2];
        EList children = element.getOwnedElements();
        for (Element child : children) {
            String constraintText;
            int textLength;
            if (this.elementsToDisplay.contains((Object)DisplayableElement.PORT) && this.entityUtil.isPort(child)) {
                textLength = 0;
                ++childrenNumber;
                textLength = ((Property)child).getName().length();
                if (((Property)child).getType() != null) {
                    textLength += ((Property)child).getType().getName().length();
                }
                int n = maxLength = textLength > maxLength ? textLength : maxLength;
            }
            if (this.elementsToDisplay.contains((Object)DisplayableElement.CONTRACT_PROPERTY) && this.contractEntityUtil.isContractProperty(child)) {
                textLength = 0;
                ++childrenNumber;
                textLength = ((Property)child).getName().length();
                if (((Property)child).getType() != null) {
                    textLength += ((Property)child).getType().getName().length();
                }
                int n = maxLength = textLength > maxLength ? textLength : maxLength;
            }
            if (this.elementsToDisplay.contains((Object)DisplayableElement.DELEGATION_CONSTRAINT) && this.entityUtil.isDelegationConstraint(child)) {
                textLength = 0;
                ++childrenNumber;
                constraintText = EntityUtil.getInstance().getConstraintBodyStr((Constraint)child, null);
                if (constraintText != null) {
                    textLength = constraintText.length();
                }
                int n = maxLength = textLength > maxLength ? textLength : maxLength;
            }
            if (this.elementsToDisplay.contains((Object)DisplayableElement.MACRO_DEFINITION) && this.entityUtil.isMacroDefinition(child)) {
                textLength = 0;
                ++childrenNumber;
                constraintText = EntityUtil.getInstance().getConstraintBodyStr((Constraint)child, null);
                if (constraintText != null) {
                    textLength = constraintText.length();
                }
                int n = maxLength = textLength > maxLength ? textLength : maxLength;
            }
            if (this.elementsToDisplay.contains((Object)DisplayableElement.OPERATION) && child instanceof Operation) {
                textLength = 0;
                ++childrenNumber;
                textLength = ((Operation)child).getName().length();
                int n = maxLength = textLength > maxLength ? textLength : maxLength;
            }
            if (this.elementsToDisplay.contains((Object)DisplayableElement.PARAMETER_ASSUMPTION) && this.entityUtil.isParameterAssumptions(child)) {
                textLength = 0;
                ++childrenNumber;
                constraintText = EntityUtil.getInstance().getConstraintBodyStr((Constraint)child, null);
                if (constraintText != null) {
                    textLength = constraintText.length();
                }
                int n = maxLength = textLength > maxLength ? textLength : maxLength;
            }
            if (!this.elementsToDisplay.contains((Object)DisplayableElement.PROPERTY) || !(child instanceof Property) || this.entityUtil.isPort(child) || this.contractEntityUtil.isContractProperty(child)) continue;
            textLength = 0;
            ++childrenNumber;
            textLength = ((Property)child).getName().length();
            if (((Property)child).getType() != null) {
                textLength += ((Property)child).getType().getName().length();
            }
            int n = maxLength = textLength > maxLength ? textLength : maxLength;
        }
        width = (int)Math.round(140.0 + 5.4 * (double)maxLength);
        height = 132 + 16 * childrenNumber;
        size[0] = width < 150 ? 150 : (width > 1500 ? 1500 : width);
        size[1] = height < 150 ? 150 : (height > 1500 ? 1500 : height);
        return size;
    }

    private void resizeElements(IGraphicalEditPart diagramEP, EList<Class> displayedBlocks) {
        EList childrenView = diagramEP.getNotationView().getChildren();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagramEP.getNotationView());
        domain.getCommandStack().execute((Command)new RecordingCommand(domain, (List)childrenView, displayedBlocks){
            private final /* synthetic */ List val$childrenView;
            private final /* synthetic */ EList val$displayedBlocks;
            {
                this.val$childrenView = list;
                this.val$displayedBlocks = eList;
                super($anonymous0);
            }

            protected void doExecute() {
                for (Object child : this.val$childrenView) {
                    View childView = (View)child;
                    Element semanticElement = (Element)childView.getElement();
                    if (!ShowBDDElementsAction.this.entityUtil.isBlock(semanticElement) || ShowBDDElementsAction.this.contractEntityUtil.isContract(semanticElement) || this.val$displayedBlocks.contains((Object)semanticElement) || !(childView instanceof CSSShapeImpl)) continue;
                    CSSShapeImpl viewShape = (CSSShapeImpl)childView;
                    Bounds layout = (Bounds)viewShape.getLayoutConstraint();
                    int[] size = ShowBDDElementsAction.this.getSize(semanticElement);
                    layout.setWidth(size[0]);
                    layout.setHeight(size[1]);
                }
            }
        });
    }

    private void contributeToSelection(List<Object> listToComplete, AbstractShowHideAction.EditPartRepresentation representation) {
        listToComplete.addAll(representation.getPossibleElement());
        List children = representation.getPossibleElement();
        if (children != null) {
            for (AbstractShowHideAction.EditPartRepresentation child : children) {
                this.contributeToSelection(listToComplete, child);
            }
        }
    }

    private void buildSelection() {
        this.selection = new ArrayList<Object>();
        for (AbstractShowHideAction.EditPartRepresentation current : this.representations) {
            this.contributeToSelection(this.selection, current);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildShowHideElementsList(Object[] results) {
        void var3_4;
        this.viewsToCreate = new ArrayList();
        this.viewsToDestroy = new ArrayList();
        ArrayList<AbstractShowHideAction.EditPartRepresentation> result = new ArrayList<AbstractShowHideAction.EditPartRepresentation>();
        boolean bl = false;
        while (var3_4 < results.length) {
            AbstractShowHideAction.EditPartRepresentation editPartRepresentation = (AbstractShowHideAction.EditPartRepresentation)results[var3_4];
            Element semanticElement = (Element)editPartRepresentation.getSemanticElement();
            for (DisplayableElement elementToDisplay : this.elementsToDisplay) {
                if (elementToDisplay == DisplayableElement.PORT) {
                    if (!this.entityUtil.isPort(semanticElement) || editPartRepresentation.getParentRepresentation() instanceof ShowHideContentsAction.AffixedChildrenEditPartRepresentation) continue;
                    result.add(editPartRepresentation);
                    continue;
                }
                if (elementToDisplay == DisplayableElement.CONTRACT_PROPERTY) {
                    if (!this.contractEntityUtil.isContractProperty(semanticElement)) continue;
                    result.add(editPartRepresentation);
                    continue;
                }
                if (elementToDisplay == DisplayableElement.DELEGATION_CONSTRAINT) {
                    if (!this.entityUtil.isDelegationConstraint(semanticElement)) continue;
                    result.add(editPartRepresentation);
                    continue;
                }
                if (elementToDisplay == DisplayableElement.OPERATION) {
                    if (!(semanticElement instanceof Operation)) continue;
                    result.add(editPartRepresentation);
                    continue;
                }
                if (elementToDisplay == DisplayableElement.MACRO_DEFINITION) {
                    if (!this.entityUtil.isMacroDefinition(semanticElement)) continue;
                    result.add(editPartRepresentation);
                    continue;
                }
                if (elementToDisplay == DisplayableElement.PARAMETER_ASSUMPTION) {
                    if (!this.entityUtil.isParameterAssumptions(semanticElement)) continue;
                    result.add(editPartRepresentation);
                    continue;
                }
                if (elementToDisplay != DisplayableElement.PROPERTY || !(semanticElement instanceof Property) || this.entityUtil.isPort(semanticElement) || this.contractEntityUtil.isContractProperty(semanticElement)) continue;
                result.add(editPartRepresentation);
            }
            ++var3_4;
        }
        for (Object e : result) {
            if (this.initialSelection.contains(e) || !(e instanceof AbstractShowHideAction.EditPartRepresentation)) continue;
            this.viewsToCreate.add((AbstractShowHideAction.EditPartRepresentation)e);
        }
    }

    protected final TransactionalEditingDomain getEditingDomain(EditPart host) {
        try {
            return ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)host);
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }

    public void populateDiagramByReference(Diagram diagram, EList<Element> elementsByRef) {
        this.populateDiagram(diagram, elementsByRef, true);
    }

    public void populateDiagram(Diagram diagram) {
        this.populateDiagram(diagram, null, false);
    }

    private void populateDiagram(Diagram diagram, EList<Element> elements, boolean useElements) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorPart activeEditor = ((PapyrusMultiDiagramEditor)editorPart).getActiveEditor();
        logger.debug((Object)("activeEditor = " + activeEditor));
        Package pkg = (Package)diagramEP.resolveSemanticElement();
        EList<Element> packageChildren = pkg.getOwnedElements();
        if (useElements) {
            packageChildren = elements;
        }
        List<EditPart> childrenList = this.diagramUtils.findAllChildren((EditPart)diagramEP);
        ArrayList<EObject> blocksToDisplay = new ArrayList<EObject>();
        for (Element element : packageChildren) {
            if (!this.entityUtil.isBlock(element) && !(element instanceof Package)) continue;
            logger.debug((Object)("calling showElementIn for element = " + element));
            blocksToDisplay.add((EObject)element);
        }
        if (!blocksToDisplay.isEmpty()) {
            org.eclipse.gef.commands.Command showBlocksCmd = this.diagramUtils.showElementsIn(blocksToDisplay, (DiagramEditor)activeEditor, (EditPart)diagramEP, childrenList, new Point(100, 100));
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(showBlocksCmd));
        }
        this.resizeElements((IGraphicalEditPart)diagramEP, (EList<Class>)new BasicEList());
        this.selectedElements = new ArrayList();
        List editPartChildren = diagramEP.getChildren();
        for (Object editPartChild : editPartChildren) {
            Element element = (Element)((IGraphicalEditPart)editPartChild).resolveSemanticElement();
            if (!this.entityUtil.isBlock(element) || this.contractEntityUtil.isContract(element)) continue;
            this.selectedElements.add((IGraphicalEditPart)editPartChild);
        }
        this.initAction();
        this.buildInitialSelection();
        this.buildSelection();
        if (this.selection.size() > 0) {
            this.buildShowHideElementsList(this.selection.toArray());
            org.eclipse.gef.commands.Command command = this.getActionCommand();
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(command));
        }
        ArrayList<EObject> associationsToDisplay = new ArrayList<EObject>();
        for (Element element : packageChildren) {
            if (!(element instanceof Association) && !(element instanceof Dependency)) continue;
            logger.debug((Object)("calling showElementIn for Association = " + element));
            associationsToDisplay.add((EObject)element);
        }
        if (!associationsToDisplay.isEmpty()) {
            org.eclipse.gef.commands.Command showAssociationsCmd = this.diagramUtils.showElementsIn(associationsToDisplay, (DiagramEditor)activeEditor, (EditPart)diagramEP, childrenList, new Point(100, 100));
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(showAssociationsCmd));
        }
    }

    public boolean refreshDiagram(Object diagramEditPart) {
        if (diagramEditPart instanceof IGraphicalEditPart) {
            return this.refreshIGraphicalEditPartDiagram((IGraphicalEditPart)diagramEditPart);
        }
        if (diagramEditPart instanceof IGraphicalEditPart) {
            this.refreshGmfDiagram((Diagram)diagramEditPart);
            return true;
        }
        return false;
    }

    private boolean refreshIGraphicalEditPartDiagram(IGraphicalEditPart diagramEditPart) {
        boolean isDiagramChanged = false;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorPart activeEditor = ((PapyrusMultiDiagramEditor)editorPart).getActiveEditor();
        Map elements = diagramEditPart.getViewer().getEditPartRegistry();
        Object[] editParts = elements.values().toArray();
        BasicEList displayedBlocks = new BasicEList();
        BasicEList displayedAssociations = new BasicEList();
        int i = 0;
        while (i < editParts.length) {
            if (editParts[i] instanceof BlockEditPart) {
                displayedBlocks.add((Object)((Class)((BlockEditPart)editParts[i]).resolveSemanticElement()));
            } else if (editParts[i] instanceof AssociationEditPart) {
                displayedAssociations.add((Object)((Association)((AssociationEditPart)editParts[i]).resolveSemanticElement()));
            }
            ++i;
        }
        EObject semanticElement = diagramEditPart.resolveSemanticElement();
        Package pkg = null;
        if (semanticElement instanceof Package) {
            pkg = (Package)semanticElement;
        } else {
            if (displayedBlocks.size() == 0) {
                return isDiagramChanged;
            }
            pkg = ((Class)displayedBlocks.get(0)).getNearestPackage();
        }
        List<EditPart> childrenList = this.diagramUtils.findAllChildren((EditPart)diagramEditPart);
        EList existingElements = pkg.getOwnedElements();
        BasicEList missingBlocks = new BasicEList();
        BasicEList missingAssociations = new BasicEList();
        for (Element element : existingElements) {
            if (this.entityUtil.isBlock(element) && !this.contractEntityUtil.isContract(element)) {
                if (displayedBlocks.contains((Object)element)) {
                    logger.debug((Object)"block already present in diagram");
                    continue;
                }
                logger.debug((Object)"block is not present in diagram");
                missingBlocks.add((Object)element);
                continue;
            }
            if (!(element instanceof Association) && !(element instanceof Dependency)) continue;
            if (displayedAssociations.contains((Object)element)) {
                logger.debug((Object)"association already present in diagram");
                continue;
            }
            logger.debug((Object)"association is not present in diagram");
            missingAssociations.add((Object)element);
        }
        ArrayList<EObject> blocksToDisplay = new ArrayList<EObject>();
        for (Element element : missingBlocks) {
            logger.debug((Object)("block missing in the diagram = " + element));
            blocksToDisplay.add((EObject)element);
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)editorPart);
        if (!blocksToDisplay.isEmpty()) {
            org.eclipse.gef.commands.Command showBlocksCmd = this.diagramUtils.showElementsIn(blocksToDisplay, (DiagramEditor)activeEditor, (EditPart)diagramEditPart, childrenList, new Point(100, 100));
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(showBlocksCmd));
        }
        this.resizeElements(diagramEditPart, (EList<Class>)displayedBlocks);
        this.selectedElements = new ArrayList();
        List editPartChildren = diagramEditPart.getChildren();
        for (Object editPartChild : editPartChildren) {
            Element element = (Element)((IGraphicalEditPart)editPartChild).resolveSemanticElement();
            if (!this.entityUtil.isBlock(element) || this.contractEntityUtil.isContract(element)) continue;
            this.selectedElements.add((IGraphicalEditPart)editPartChild);
        }
        this.initAction();
        this.buildInitialSelection();
        this.buildSelection();
        if (this.selection.size() > 0) {
            this.buildShowHideElementsList(this.selection.toArray());
            CompoundCommand command = (CompoundCommand)this.getActionCommand();
            if (command.size() > 0) {
                isDiagramChanged = true;
                TransactionalEditingDomain notationDomain = TransactionUtil.getEditingDomain((EObject)diagramEditPart.getNotationView());
                notationDomain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)command));
            }
        }
        ArrayList<EObject> associationsToDisplay = new ArrayList<EObject>();
        for (Element element : missingAssociations) {
            logger.debug((Object)("association missing in the diagram = " + element));
            associationsToDisplay.add((EObject)element);
        }
        if (!associationsToDisplay.isEmpty()) {
            org.eclipse.gef.commands.Command showAssociationsCmd = this.diagramUtils.showElementsIn(associationsToDisplay, (DiagramEditor)activeEditor, (EditPart)diagramEditPart, childrenList, new Point(100, 100));
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(showAssociationsCmd));
        }
        return isDiagramChanged;
    }

    private void refreshGmfDiagram(Diagram diagram) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
        this.refreshDiagram(diagramEditPart);
    }

    public void setDisplayableElement(Set<DisplayableElement> elements) {
        this.elementsToDisplay = elements;
    }

    public static enum DisplayableElement {
        PORT,
        OPERATION,
        DELEGATION_CONSTRAINT,
        CONTRACT_PROPERTY,
        PROPERTY,
        PARAMETER_ASSUMPTION,
        MACRO_DEFINITION;

    }
}

