/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BDDCreatorDialog
extends Dialog {
    private static final String TITLE = "BDD diagram parameters";
    private Button btnShowStereotypes;
    private boolean showStereotypes;
    private Button btnShowAssociationsNames;
    private boolean showAssociationsNames;
    private Button btnShowSourceMultiplicity;
    private boolean showSourceMultiplicity;
    private Button btnShowTargetMultiplicity;
    private boolean showTargetMultiplicity;
    private Button btnShowSourceRole;
    private boolean showSourceRole;
    private Button btnShowTargetRole;
    private boolean showTargetRole;
    private Combo combo;
    private boolean rectilinearRouting;
    private boolean goAhead = false;

    public BDDCreatorDialog(Shell parentShell, boolean blocking) {
        super(parentShell);
        this.setShellStyle(32);
        this.setBlockOnOpen(blocking);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected void okPressed() {
        this.showStereotypes = this.btnShowStereotypes.getSelection();
        this.showAssociationsNames = this.btnShowAssociationsNames.getSelection();
        this.showSourceRole = this.btnShowSourceRole.getSelection();
        this.showSourceMultiplicity = this.btnShowSourceMultiplicity.getSelection();
        this.showTargetRole = this.btnShowTargetRole.getSelection();
        this.showTargetMultiplicity = this.btnShowTargetMultiplicity.getSelection();
        this.rectilinearRouting = this.combo.getSelectionIndex() == 0;
        this.goAhead = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.btnShowStereotypes = new Button(container, 32);
        this.btnShowStereotypes.setSelection(false);
        this.btnShowStereotypes.setAlignment(131072);
        this.btnShowStereotypes.setText("Show stereotypes labels");
        this.btnShowAssociationsNames = new Button(container, 32);
        this.btnShowAssociationsNames.setSelection(false);
        this.btnShowAssociationsNames.setAlignment(131072);
        this.btnShowAssociationsNames.setText("Show associations names");
        this.btnShowSourceRole = new Button(container, 32);
        this.btnShowSourceRole.setSelection(false);
        this.btnShowSourceRole.setAlignment(131072);
        this.btnShowSourceRole.setText("Show source role");
        this.btnShowSourceMultiplicity = new Button(container, 32);
        this.btnShowSourceMultiplicity.setSelection(false);
        this.btnShowSourceMultiplicity.setAlignment(131072);
        this.btnShowSourceMultiplicity.setText("Show source multiplicity");
        this.btnShowTargetRole = new Button(container, 32);
        this.btnShowTargetRole.setSelection(false);
        this.btnShowTargetRole.setAlignment(131072);
        this.btnShowTargetRole.setText("Show target role");
        this.btnShowTargetMultiplicity = new Button(container, 32);
        this.btnShowTargetMultiplicity.setSelection(false);
        this.btnShowTargetMultiplicity.setAlignment(131072);
        this.btnShowTargetMultiplicity.setText("Show target multiplicity");
        Label selectRoutingStyle = new Label(container, 131072);
        selectRoutingStyle.setText("Select routing style:");
        this.combo = new Combo(container, 12);
        this.combo.setItems(new String[]{"Rectilinear", "Oblique"});
        this.combo.select(0);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(435, 230);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public boolean getShowAssociationsNames() {
        return this.showAssociationsNames;
    }

    public boolean getShowStereotypes() {
        return this.showStereotypes;
    }

    public boolean getShowSourceRole() {
        return this.showSourceRole;
    }

    public boolean getShowSourceMultiplicity() {
        return this.showSourceMultiplicity;
    }

    public boolean getShowTargetRole() {
        return this.showTargetRole;
    }

    public boolean getShowTargetMultiplicity() {
        return this.showTargetMultiplicity;
    }

    public boolean getRectilinearRouting() {
        return this.rectilinearRouting;
    }
}

