/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class IBDCreatorDialog
extends Dialog {
    private static final String TITLE = "IBD diagram parameters";
    private Button btnPortLexicographicallyOrder;
    private boolean portLexicographicallyOrder;
    private Button btnShowFlowPorts;
    private boolean showFlowPorts;
    private Button btnShowStereotypes;
    private boolean showStereotypes;
    private Button btnShowConnectorNames;
    private boolean showConnectorNames;
    private Combo combo;
    private boolean rectilinearRouting;
    private boolean goAhead = false;

    public IBDCreatorDialog(Shell parentShell, boolean blocking) {
        super(parentShell);
        this.setShellStyle(32);
        this.setBlockOnOpen(blocking);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected void okPressed() {
        this.portLexicographicallyOrder = this.btnPortLexicographicallyOrder.getSelection();
        this.showFlowPorts = this.btnShowFlowPorts.getSelection();
        this.showStereotypes = this.btnShowStereotypes.getSelection();
        this.showConnectorNames = this.btnShowConnectorNames.getSelection();
        this.rectilinearRouting = this.combo.getSelectionIndex() == 0;
        this.goAhead = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.btnPortLexicographicallyOrder = new Button(container, 32);
        this.btnPortLexicographicallyOrder.setSelection(false);
        this.btnPortLexicographicallyOrder.setAlignment(131072);
        this.btnPortLexicographicallyOrder.setText("Alphabetical port name ordering");
        this.btnShowFlowPorts = new Button(container, 32);
        this.btnShowFlowPorts.setSelection(false);
        this.btnShowFlowPorts.setAlignment(131072);
        this.btnShowFlowPorts.setText("Show <<FlowPort>> labels");
        this.btnShowStereotypes = new Button(container, 32);
        this.btnShowStereotypes.setSelection(false);
        this.btnShowStereotypes.setAlignment(131072);
        this.btnShowStereotypes.setText("Show stereotypes labels");
        this.btnShowConnectorNames = new Button(container, 32);
        this.btnShowConnectorNames.setSelection(false);
        this.btnShowConnectorNames.setAlignment(131072);
        this.btnShowConnectorNames.setText("Show connectors names");
        Label selectRoutingStyle = new Label(container, 131072);
        selectRoutingStyle.setText("Select routing style:");
        this.combo = new Combo(container, 12);
        this.combo.setItems(new String[]{"Rectilinear", "Oblique"});
        this.combo.select(0);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(485, 230);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public boolean getPortLexicographicallyOrder() {
        return this.portLexicographicallyOrder;
    }

    public boolean getShowConnectors() {
        return this.showConnectorNames;
    }

    public boolean getShowFlowPorts() {
        return this.showFlowPorts;
    }

    public boolean getShowStereotypes() {
        return this.showStereotypes;
    }

    public boolean getRectilinearRouting() {
        return this.rectilinearRouting;
    }
}

