/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.mobius.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.ErrorModelBehavior;
import org.polarsys.chess.chessmlprofile.Dependability.StateBased.StateBasedAnalysis.SANAnalysis;
import org.polarsys.chess.chessmlprofile.Dependability.ThreatsPropagation.Attack;
import org.polarsys.chess.chessmlprofile.Dependability.ThreatsPropagation.AttackScenario;
import org.polarsys.chess.chessmlprofile.Dependability.ThreatsPropagation.ErrorModel;
import org.polarsys.chess.chessmlprofile.Dependability.ThreatsPropagation.InternalFault;
import org.polarsys.chess.chessmlprofile.Dependability.ThreatsPropagation.Vulnerability;
import org.polarsys.chess.mobius.model.SAN.Node;
import org.polarsys.chess.mobius.utils.MobiusComponents;

public class TransformationUtil {
    private static final int OFFSET = 15;
    private static MobiusComponents mobiusComponents;
    private static List<Message> attacks;
    private static Map<Classifier, List<Message>> vulnerableComponents;
    private static List<Interaction> scenarios;
    private List<String> shortGlobalVars = new ArrayList<String>();
    private static String startPlace;
    private static Integer startX;
    private static Integer startY;
    private static Integer okX;
    private static Integer okY;
    private static List<String> predicateList;
    private static String BLOCKQN;
    private static String ERRORMODELBEHAVIORQN;
    private static String NORMALSTATEQN;
    private static String ERRORSTATEQN;
    private static String COMPROMISEDSTATEQN;
    private static String INTERNALFAULTQN;
    private static String ATTACKQN;
    private static String ATTACKSCENARIOQN;
    private static String CYBERSECURITYANALYSISQN;

    static {
        predicateList = new ArrayList<String>();
        BLOCKQN = "SysML::Blocks::Block";
        ERRORMODELBEHAVIORQN = "CHESS::Dependability::DependableComponent::ErrorModelBehavior";
        NORMALSTATEQN = "CHESS::Dependability::ThreatsPropagation::NormalState";
        ERRORSTATEQN = "CHESS::Dependability::ThreatsPropagation::ErrorState";
        COMPROMISEDSTATEQN = "CHESS::Dependability::ThreatsPropagation::DegradedState";
        INTERNALFAULTQN = "CHESS::Dependability::ThreatsPropagation::InternalFault";
        ATTACKQN = "CHESS::Dependability::ThreatsPropagation::Attack";
        ATTACKSCENARIOQN = "CHESS::Dependability::ThreatsPropagation::AttackScenario";
        CYBERSECURITYANALYSISQN = "CHESS::Dependability::StateBased::StateBasedAnalysis::CyberSecurityAnalysis";
    }

    public static MobiusComponents getMobiusComponenents(CHGaResourcePlatform platform) {
        Classifier root = (Classifier)platform.getBase_InstanceSpecification().getClassifiers().get(0);
        MobiusComponents mobiusComponents = new MobiusComponents();
        if (platform.getResources().size() > 0) {
            for (Resource res : platform.getResources()) {
                if (res.getBase_InstanceSpecification() == null) continue;
                TransformationUtil.getMobiusComponents(res, mobiusComponents);
            }
            mobiusComponents.getComposedBlocks().add(root);
        } else {
            mobiusComponents.getAtomicBlocks().add(root);
        }
        TransformationUtil.mobiusComponents = mobiusComponents;
        return mobiusComponents;
    }

    private static MobiusComponents getMobiusComponents(Resource res, MobiusComponents mobiusComponents) {
        if (res.getBase_InstanceSpecification().getClassifiers().isEmpty()) {
            return null;
        }
        Classifier block = (Classifier)res.getBase_InstanceSpecification().getClassifiers().get(0);
        EList slots = res.getBase_InstanceSpecification().getSlots();
        if (slots.size() > 0) {
            boolean composed = false;
            for (Slot slot : slots) {
                if (slot.getDefiningFeature() instanceof Port) continue;
                composed = true;
            }
            if (composed) {
                if (TransformationUtil.getErrorModelStateMachine(block) != null) {
                    mobiusComponents.getAtomicBlocks().add(block);
                } else {
                    mobiusComponents.getComposedBlocks().add(block);
                }
            } else if (TransformationUtil.getErrorModelStateMachine(block) != null) {
                mobiusComponents.getAtomicBlocks().add(block);
            }
        } else if (TransformationUtil.getErrorModelStateMachine(block) != null) {
            mobiusComponents.getAtomicBlocks().add(block);
        }
        return null;
    }

    public List<Classifier> getAtomicBlocks() {
        return mobiusComponents.getAtomicBlocks();
    }

    public List<Classifier> getComposedBlocks() {
        return mobiusComponents.getComposedBlocks();
    }

    public static List<Interaction> getModelAttackScenarios(Model model) {
        ArrayList<Interaction> result = new ArrayList<Interaction>();
        for (Element elem : model.allOwnedElements()) {
            if (!(elem instanceof Interaction) || elem.getAppliedStereotype(ATTACKSCENARIOQN) == null) continue;
            Interaction scenario = (Interaction)elem;
            boolean test = false;
            for (Message msg : scenario.getMessages()) {
                if (msg.getAppliedStereotype(ATTACKQN) == null) continue;
                test = true;
            }
            if (!test) continue;
            result.add(scenario);
        }
        scenarios = result;
        return result;
    }

    public List<Interaction> getAttackScenarios() {
        return scenarios;
    }

    public static List<Message> getModelAttacks(Model model) {
        ArrayList<Message> result = new ArrayList<Message>();
        for (Element elem : model.allOwnedElements()) {
            if (!(elem instanceof Interaction)) continue;
            Interaction scenario = (Interaction)elem;
            for (Message msg : TransformationUtil.getAttacksForScenario(scenario)) {
                result.add(msg);
            }
        }
        attacks = result;
        return result;
    }

    public List<Message> getAttacks() {
        return attacks;
    }

    public List<String> getAllBlockAttacks(Classifier block) {
        ArrayList<String> result = new ArrayList<String>();
        for (Message msg : attacks) {
            Stereotype stereo;
            Attack attack = (Attack)msg.getStereotypeApplication(stereo = msg.getAppliedStereotype(ATTACKQN));
            if (attack.getVulnerability() == null || !block.getOwnedElements().contains((Object)attack.getVulnerability().getBase_Port())) continue;
            result.add(msg.getName());
        }
        return result;
    }

    public List<String> getBlockAttacks(Classifier block, String scenarioName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Message msg : attacks) {
            Stereotype stereo;
            Attack attack;
            if (!msg.getInteraction().getName().equals(scenarioName) || (attack = (Attack)msg.getStereotypeApplication(stereo = msg.getAppliedStereotype(ATTACKQN))).getVulnerability() == null || !block.getOwnedElements().contains((Object)attack.getVulnerability().getBase_Port())) continue;
            result.add(msg.getName());
        }
        return result;
    }

    public List<String> getBlockAttackScenarios(Classifier block) {
        ArrayList<String> result = new ArrayList<String>();
        for (Interaction scenario : scenarios) {
            EList lifelines = scenario.getLifelines();
            for (Lifeline lifeline : lifelines) {
                if (!lifeline.getRepresents().getType().equals(block)) continue;
                result.add(scenario.getName());
            }
        }
        return result;
    }

    public static Map<Classifier, List<Message>> getVulnerableComponents(Model model) {
        HashMap<Classifier, List<Message>> result = new HashMap<Classifier, List<Message>>();
        for (Interaction scenario : scenarios) {
            EList lifelines = scenario.getLifelines();
            for (Message msg : TransformationUtil.getAttacksForScenario(scenario)) {
                for (Lifeline lifeline : lifelines) {
                    if (!lifeline.getCoveredBys().contains((Object)msg.getReceiveEvent()) || !(lifeline.getRepresents().getType() instanceof Classifier)) continue;
                    Classifier comp = (Classifier)lifeline.getRepresents().getType();
                    ArrayList<Message> msgList = (ArrayList<Message>)result.get(comp);
                    if (msgList == null) {
                        msgList = new ArrayList<Message>();
                    }
                    msgList.add(msg);
                    result.put(comp, msgList);
                }
            }
        }
        vulnerableComponents = result;
        return result;
    }

    private static List<Message> getAttacksForScenario(Interaction scenario) {
        ArrayList<Message> result = new ArrayList<Message>();
        for (Element elem : scenario.allOwnedElements()) {
            if (elem.getAppliedStereotype(ATTACKQN) == null) continue;
            result.add((Message)elem);
        }
        return result;
    }

    public Set<Classifier> getVulnerableComponents() {
        return vulnerableComponents.keySet();
    }

    public Classifier getBlockFromQN(List<Classifier> blocks, String qualifiedName) {
        Classifier result = null;
        for (Classifier cl : blocks) {
            if (!cl.getQualifiedName().equals(qualifiedName)) continue;
            result = cl;
        }
        return result;
    }

    public Node getNodeFromQN(List<Node> nodes, String qualifiedName) {
        Node result = null;
        for (Node cl : nodes) {
            if (!cl.getName().equals(qualifiedName)) continue;
            result = cl;
        }
        return result;
    }

    public State getNormalState(Classifier block) {
        State result = null;
        for (State state : this.getPlaces(block)) {
            if (state.getAppliedStereotype(NORMALSTATEQN) == null) continue;
            result = state;
        }
        return result;
    }

    public List<State> getPlaces(Classifier block) {
        ArrayList<State> result = new ArrayList<State>();
        StateMachine sm = TransformationUtil.getErrorModelStateMachine(block);
        if (sm != null) {
            EList vertices = ((Region)sm.getRegions().get(0)).getSubvertices();
            for (Vertex vertex : vertices) {
                if (!(vertex instanceof State)) continue;
                if (vertex.getAppliedStereotype(NORMALSTATEQN) != null) {
                    result.add((State)vertex);
                    continue;
                }
                if (vertex.getAppliedStereotype(ERRORSTATEQN) != null) {
                    result.add((State)vertex);
                    continue;
                }
                if (vertex.getAppliedStereotype(COMPROMISEDSTATEQN) == null) continue;
                result.add((State)vertex);
            }
        }
        return result;
    }

    public List<Transition> getActivities(Classifier block) {
        ArrayList<Transition> result = new ArrayList<Transition>();
        StateMachine sm = TransformationUtil.getErrorModelStateMachine(block);
        if (sm != null) {
            EList transitions = ((Region)sm.getRegions().get(0)).getTransitions();
            for (Transition transition : transitions) {
                if (transition.getAppliedStereotype(INTERNALFAULTQN) != null) {
                    result.add(transition);
                    continue;
                }
                if (transition.getAppliedStereotype(ATTACKQN) == null) continue;
                result.add(transition);
            }
        }
        return result;
    }

    private static StateMachine getErrorModelStateMachine(Classifier block) {
        StateMachine sm = null;
        Stereotype stereo = block.getAppliedStereotype(ERRORMODELBEHAVIORQN);
        ErrorModelBehavior behavior = (ErrorModelBehavior)block.getStereotypeApplication(stereo);
        if (behavior != null && behavior.getErrorModel().size() > 0) {
            ErrorModel errorModel = (ErrorModel)behavior.getErrorModel().get(0);
            sm = errorModel.getBase_StateMachine();
        }
        return sm;
    }

    public String getRate(Transition tr) {
        InternalFault intF;
        String rate = "";
        Stereotype stereo = tr.getAppliedStereotype(INTERNALFAULTQN);
        if (stereo != null && (intF = (InternalFault)tr.getStereotypeApplication(stereo)).getOccurrence() != null) {
            rate = intF.getOccurrence();
        }
        return rate;
    }

    public List<Classifier> getSubsystems(Classifier parent) {
        ArrayList<Classifier> result = new ArrayList<Classifier>();
        for (Element elem : parent.getOwnedElements()) {
            Property prop;
            if (!(elem instanceof Property) || elem instanceof Port || !((prop = (Property)elem).getType() instanceof Classifier)) continue;
            Classifier cl = (Classifier)prop.getType();
            if (prop.getType().getAppliedStereotype(BLOCKQN) == null) continue;
            result.add(cl);
        }
        return result;
    }

    public boolean isReplicated(Classifier block, Classifier parent) {
        boolean result = false;
        for (Element elem : parent.getOwnedElements()) {
            Classifier cl;
            Property prop;
            if (!(elem instanceof Property) || elem instanceof Port || !((prop = (Property)elem).getType() instanceof Classifier) || !(cl = (Classifier)prop.getType()).getQualifiedName().equals(block.getQualifiedName()) || prop.getUpper() <= 1 && prop.getUpper() != -1) continue;
            result = true;
        }
        return result;
    }

    public String getReplication(Classifier block, Classifier parent) {
        String result = "";
        for (Element elem : parent.getOwnedElements()) {
            Classifier cl;
            Property prop;
            if (!(elem instanceof Property) || elem instanceof Port || !((prop = (Property)elem).getType() instanceof Classifier) || !(cl = (Classifier)prop.getType()).getQualifiedName().equals(block.getQualifiedName()) || prop.getLower() != prop.getUpper() || prop.getUpper() <= 1) continue;
            result = Integer.toString(prop.getUpper());
        }
        return result;
    }

    public Set<String> getEmptyStringSet() {
        return new HashSet<String>();
    }

    public void addToGlobalVars(String name, Set<String> globalvars) {
        if (!name.startsWith("1.0")) {
            globalvars.add(name);
        }
    }

    public List<String> getAttackSuccName(Transition tr) {
        ArrayList<String> result = new ArrayList<String>();
        String name = "";
        Stereotype stereo = tr.getAppliedStereotype(ATTACKQN);
        Attack attack = (Attack)tr.getStereotypeApplication(stereo);
        Vulnerability vuln = attack.getVulnerability();
        if (vuln != null) {
            for (Message msg : TransformationUtil.getModelAttacks(tr.getModel())) {
                Attack msgAttack = (Attack)msg.getStereotypeApplication(stereo = msg.getAppliedStereotype(ATTACKQN));
                if (msgAttack.getVulnerability() == null || !msgAttack.getVulnerability().equals(vuln)) continue;
                name = msgAttack.getBase_Message().getName();
                result.add(name);
            }
        }
        return result;
    }

    public Interaction getScenario(Model model, String scenarioName) {
        Interaction scenario = null;
        for (Interaction interaction : scenarios) {
            if (!interaction.getName().equals(scenarioName)) continue;
            scenario = interaction;
        }
        return scenario;
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static void setCeiling2(IContext context, Class self, String ceiling) {
    }

    public List<NamedElement> getOrderedAttacksAndFragments(Interaction scenario) {
        List<DurationConstraint> durConstrList = TransformationUtil.getDurConstrList(scenario);
        List<MessageOccurrenceSpecification> msgOccList = this.getMsgOccSpecs(scenario);
        ArrayList<GeneralOrdering> genOrderList = new ArrayList<GeneralOrdering>();
        for (MessageOccurrenceSpecification msgOcc : msgOccList) {
            for (GeneralOrdering order : msgOcc.getGeneralOrderings()) {
                genOrderList.add(order);
            }
        }
        for (GeneralOrdering order : scenario.getGeneralOrderings()) {
            genOrderList.add(order);
        }
        ArrayList<Message> orderedMsgList = new ArrayList<Message>();
        boolean start = true;
        for (GeneralOrdering order : genOrderList) {
            Message beforeMsg = ((MessageOccurrenceSpecification)order.getBefore()).getMessage();
            Message afterMsg = ((MessageOccurrenceSpecification)order.getAfter()).getMessage();
            if (start) {
                orderedMsgList.add(beforeMsg);
                if (!beforeMsg.equals(afterMsg)) {
                    orderedMsgList.add(afterMsg);
                }
                start = false;
                continue;
            }
            if (orderedMsgList.contains(beforeMsg) && !orderedMsgList.contains(afterMsg)) {
                orderedMsgList.add(afterMsg);
            }
            if (!orderedMsgList.contains(afterMsg) || orderedMsgList.contains(beforeMsg)) continue;
            orderedMsgList.add(0, beforeMsg);
        }
        if (orderedMsgList.isEmpty()) {
            orderedMsgList.addAll((Collection<Message>)scenario.getMessages());
        }
        ArrayList<NamedElement> orderedElemList = new ArrayList<NamedElement>();
        for (Message message : orderedMsgList) {
            InteractionOperand operand;
            CombinedFragment combfrag;
            if (message.getAppliedStereotype(ATTACKQN) == null || !(message.getSendEvent() instanceof MessageOccurrenceSpecification)) continue;
            MessageOccurrenceSpecification msgOcc = (MessageOccurrenceSpecification)message.getSendEvent();
            if (msgOcc.getEnclosingInteraction() != null) {
                orderedElemList.add((NamedElement)message);
                continue;
            }
            if (msgOcc.getEnclosingOperand() == null || orderedElemList.contains(combfrag = (CombinedFragment)(operand = msgOcc.getEnclosingOperand()).getOwner())) continue;
            orderedElemList.add((NamedElement)combfrag);
        }
        for (DurationConstraint durConstr : durConstrList) {
            Element constrElem;
            EList constrElems = durConstr.getConstrainedElements();
            if (constrElems.size() == 0 || !orderedElemList.contains(constrElem = (Element)constrElems.get(0))) continue;
            int index = orderedElemList.indexOf(constrElem);
            orderedElemList.add(index, (NamedElement)durConstr);
        }
        return orderedElemList;
    }

    private List<MessageOccurrenceSpecification> getMsgOccSpecs(Interaction scenario) {
        ArrayList<MessageOccurrenceSpecification> msgOccList = new ArrayList<MessageOccurrenceSpecification>();
        EList fragments = scenario.getFragments();
        for (InteractionFragment fragment : fragments) {
            if (fragment instanceof CombinedFragment) {
                CombinedFragment combFrag = (CombinedFragment)fragment;
                EList operands = combFrag.getOperands();
                for (InteractionOperand intOp : operands) {
                    for (InteractionFragment intOpFrag : intOp.getFragments()) {
                        if (!(intOpFrag instanceof MessageOccurrenceSpecification)) continue;
                        msgOccList.add((MessageOccurrenceSpecification)intOpFrag);
                    }
                }
            }
            if (!(fragment instanceof MessageOccurrenceSpecification)) continue;
            msgOccList.add((MessageOccurrenceSpecification)fragment);
        }
        return msgOccList;
    }

    private static List<DurationConstraint> getDurConstrList(Interaction scenario) {
        ArrayList<DurationConstraint> durConstrList = new ArrayList<DurationConstraint>();
        EList rules = scenario.getOwnedRules();
        for (Constraint constraint : rules) {
            if (!(constraint instanceof DurationConstraint)) continue;
            durConstrList.add((DurationConstraint)constraint);
        }
        return durConstrList;
    }

    public static CombinedFragment getCombinedFragment(Message message) {
        MessageOccurrenceSpecification msgOcc;
        CombinedFragment result = null;
        if (message.getSendEvent() instanceof MessageOccurrenceSpecification && (msgOcc = (MessageOccurrenceSpecification)message.getSendEvent()).getEnclosingOperand() != null) {
            InteractionOperand operand = msgOcc.getEnclosingOperand();
            result = (CombinedFragment)operand.getOwner();
        }
        return result;
    }

    public static String getDelay(DurationConstraint constraint) {
        String result = "delay";
        DurationConstraint duration = constraint;
        DurationInterval durInt = (DurationInterval)duration.getSpecification();
        Duration durMin = (Duration)durInt.getMin();
        Duration durMax = (Duration)durInt.getMax();
        if (durMin.getExpr() instanceof LiteralString && durMax.getExpr() instanceof LiteralString) {
            LiteralString litStrMin = (LiteralString)durMin.getExpr();
            LiteralString litStrMax = (LiteralString)durMin.getExpr();
            if (litStrMin.getValue().equals(litStrMax.getValue())) {
                result = litStrMin.getValue();
            }
        }
        return result;
    }

    public String getAttackScenarioFrequency(Model model, String scenarioName) {
        String result = "";
        for (Interaction scenario : scenarios) {
            Stereotype stereo;
            AttackScenario attackScenario;
            String freq;
            if (!scenario.getName().equals(scenarioName) || (freq = (attackScenario = (AttackScenario)scenario.getStereotypeApplication(stereo = scenario.getAppliedStereotype(ATTACKSCENARIOQN))).getFrequency()) == null || freq.isEmpty()) continue;
            result = freq;
        }
        return result;
    }

    public String getAttackScenarioProbSuccess(Model model, String scenarioName) {
        String result = "";
        for (Interaction scenario : scenarios) {
            Stereotype stereo;
            AttackScenario attackScenario;
            String prob;
            if (!scenario.getName().equals(scenarioName) || (prob = (attackScenario = (AttackScenario)scenario.getStereotypeApplication(stereo = scenario.getAppliedStereotype(ATTACKSCENARIOQN))).getProbSuccess()) == null || prob.isEmpty()) continue;
            result = prob;
        }
        return result;
    }

    public String getAttackScenarioProbUnsuccess(Model model, String probSuccess) {
        String result = "";
        double prob = Double.parseDouble(probSuccess);
        double prob2 = 1.0 - prob;
        result = Double.toString(prob2);
        return result;
    }

    public String getPredicate(InteractionOperand operand) {
        String result = operand.getName();
        ValueSpecification valSpec = operand.getGuard().getSpecification();
        if (valSpec instanceof LiteralString) {
            LiteralString litStr = (LiteralString)valSpec;
            if (litStr.getValue().equalsIgnoreCase("else") && predicateList.size() > 0) {
                result = "1.0 - (";
                boolean first = true;
                for (String predicate : predicateList) {
                    if (first) {
                        result = String.valueOf(result) + predicate;
                        first = false;
                        continue;
                    }
                    result = String.valueOf(result) + " + " + predicate;
                }
                result = String.valueOf(result) + ')';
            } else {
                result = litStr.getValue();
                predicateList.add(result);
            }
        }
        return result;
    }

    public void resetPredicateList() {
        predicateList.clear();
    }

    public Integer getAltOffset(Integer index, Integer size) {
        Integer result = (index + 1 - size / 2) * 15;
        if (size % 2 != 0) {
            result = (index - size / 2) * 15;
        }
        return result;
    }

    public Message getOperandAttack(InteractionOperand operand) {
        Message result = null;
        for (Message message : attacks) {
            MessageOccurrenceSpecification msgOcc;
            if (!(message.getSendEvent() instanceof MessageOccurrenceSpecification) || (msgOcc = (MessageOccurrenceSpecification)message.getSendEvent()).getEnclosingOperand() == null || !msgOcc.getEnclosingOperand().equals(operand)) continue;
            result = message;
        }
        return result;
    }

    public String getLoopCounter(InteractionOperand operand) {
        String result = "counter";
        ValueSpecification valSpec = operand.getGuard().getMaxint();
        if (valSpec instanceof LiteralString) {
            LiteralString litStr = (LiteralString)valSpec;
            result = litStr.getValue();
        } else if (valSpec instanceof LiteralInteger) {
            LiteralInteger litInt = (LiteralInteger)valSpec;
            result = Integer.toString(litInt.getValue());
        }
        if (!this.shortGlobalVars.contains(result)) {
            this.shortGlobalVars.add(result);
        }
        return result;
    }

    public static String getStartPlace() {
        return startPlace;
    }

    public static void setStartPlace(String startPlace) {
        TransformationUtil.startPlace = startPlace;
    }

    public static Integer getStartX() {
        return startX;
    }

    public static void setStartX(Integer startX) {
        TransformationUtil.startX = startX;
    }

    public static Integer getStartY() {
        return startY;
    }

    public static void setStartY(Integer startY) {
        TransformationUtil.startY = startY;
    }

    public String getVarType(Model model, String globalvar) {
        String result = "double";
        if (this.shortGlobalVars.contains(globalvar)) {
            result = "short";
        }
        return result;
    }

    public static Integer getOkX() {
        return okX;
    }

    public static void setOkX(Integer okX) {
        TransformationUtil.okX = okX;
    }

    public static Integer getOkY() {
        return okY;
    }

    public static void setOkY(Integer okY) {
        TransformationUtil.okY = okY;
    }

    public List<String> getRewards(Classifier analysisContext) {
        Stereotype stereo = analysisContext.getAppliedStereotype(CYBERSECURITYANALYSISQN);
        SANAnalysis csa = (SANAnalysis)analysisContext.getStereotypeApplication(stereo);
        ArrayList<String> result = new ArrayList<String>();
        String conditions = csa.getCondition();
        result.add(conditions);
        return result;
    }
}

