/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.partitioning;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.polarsys.chess.multicore.partitioning.Bin;
import org.polarsys.chess.multicore.partitioning.BinPacker;
import org.polarsys.chess.multicore.partitioning.BinPackerFactory;
import org.polarsys.chess.multicore.partitioning.Heuristic;
import org.polarsys.chess.multicore.partitioning.Task;

public class RUNReduction
implements BinPacker {
    int level = -1;

    @Override
    public Map<Bin, List<Task>> pack(List<Bin> bins, List<Task> tasks) {
        ++this.level;
        Hashtable<Bin, List<Task>> toReturn = new Hashtable<Bin, List<Task>>();
        if (tasks.size() == 1) {
            Bin theBin = new Bin(0);
            theBin.setLevel(this.level);
            toReturn.put(theBin, tasks);
            return toReturn;
        }
        for (Task task : tasks) {
            task.switchToDual();
        }
        Map<Bin, List<Task>> result = BinPackerFactory.getBinPacker(Heuristic.WORST_FIT).pack(new ArrayList<Bin>(), tasks);
        Set<Bin> keys = result.keySet();
        ArrayList<Task> supertasks = new ArrayList<Task>();
        for (Bin bin : keys) {
            bin.setLevel(this.level);
            toReturn.put(bin, result.get(bin));
            supertasks.add(new Task(bin.getId().toString(), bin.getCapacity()));
        }
        toReturn.putAll(this.pack(null, supertasks));
        return toReturn;
    }
}

