/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tabbedproperties.sections;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.papyrus.views.search.utils.DefaultServiceRegistryTracker;
import org.eclipse.papyrus.views.search.utils.IServiceRegistryTracker;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;

public class TableCellMouseListener
implements MouseListener {
    private Table swInstanceTable;

    public TableCellMouseListener(Table swInstanceTable) {
        this.swInstanceTable = swInstanceTable;
    }

    public void mouseDoubleClick(MouseEvent event) {
        Rectangle clientArea = this.swInstanceTable.getClientArea();
        Point pt = new Point(event.x, event.y);
        int index = this.swInstanceTable.getTopIndex();
        while (index < this.swInstanceTable.getItemCount()) {
            boolean visible = false;
            TableItem item = this.swInstanceTable.getItem(index);
            int i = 0;
            while (i < this.swInstanceTable.getColumns().length) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt)) {
                    InstanceSpecification inst = (InstanceSpecification)((Map.Entry)item.getData()).getKey();
                    if (i == 0) {
                        try {
                            URI umlUri = inst.eResource().getURI();
                            ScopeEntry scopeEntry = new ScopeEntry(umlUri, (IServiceRegistryTracker)new DefaultServiceRegistryTracker());
                            OpenElementService service = (OpenElementService)scopeEntry.getServicesRegistry().getService(OpenElementService.class);
                            service.openSemanticElement((EObject)inst);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                        }
                    }
                    Operation op = (Operation)((Map.Entry)item.getData()).getValue();
                    if (i == 1) {
                        for (Slot slot : inst.getSlots()) {
                            Stereotype stereo = slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot");
                            if (stereo == null) continue;
                            CHRtPortSlot chrtPortSlot = (CHRtPortSlot)slot.getStereotypeApplication(stereo);
                            for (CHRtSpecification chrt : chrtPortSlot.getCH_RtSpecification()) {
                                if (!chrt.getContext().equals(op)) continue;
                                try {
                                    Comment comm = chrt.getBase_Comment();
                                    URI umlUri = comm.eResource().getURI();
                                    ScopeEntry scopeEntry = new ScopeEntry(umlUri, (IServiceRegistryTracker)new DefaultServiceRegistryTracker());
                                    OpenElementService service = (OpenElementService)scopeEntry.getServicesRegistry().getService(OpenElementService.class);
                                    service.openSemanticElement((EObject)comm);
                                }
                                catch (PartInitException e) {
                                    e.printStackTrace();
                                }
                                catch (ServiceException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
                if (!visible && rect.intersects(clientArea)) {
                    visible = true;
                }
                ++i;
            }
            if (!visible) {
                return;
            }
            ++index;
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }
}

