/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableDoubleBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;

public class ImmutableDoubleBagFactoryImpl
implements ImmutableDoubleBagFactory {
    public static final ImmutableDoubleBagFactory INSTANCE = new ImmutableDoubleBagFactoryImpl();

    @Override
    public ImmutableDoubleBag empty() {
        return ImmutableDoubleEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableDoubleBag of() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleBag with() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleBag of(double one) {
        return this.with(one);
    }

    @Override
    public ImmutableDoubleBag with(double one) {
        return new ImmutableDoubleSingletonBag(one);
    }

    @Override
    public ImmutableDoubleBag of(double ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableDoubleBag with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleHashBag.newBagWith(items);
    }

    @Override
    public ImmutableDoubleBag ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleBag withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleBag) {
            return (ImmutableDoubleBag)items;
        }
        if (items == null) {
            return this.with();
        }
        DoubleHashBag bag = new DoubleHashBag();
        items.forEach(bag::add);
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableDoubleHashBag.newBagWith(bag);
    }

    @Override
    public ImmutableDoubleBag ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableDoubleBag withAll(Iterable<Double> iterable) {
        return DoubleBags.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableDoubleBag ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleBag withAll(DoubleStream items) {
        if (items == null) {
            return this.with();
        }
        DoubleHashBag bag = new DoubleHashBag();
        items.forEach(bag::add);
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableDoubleHashBag.newBagWith(bag);
    }
}

