/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.comma.java.JArtifactInfo;
import org.eclipse.comma.java.JClassInfo;
import org.eclipse.comma.java.JClassInfos;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.JSourceInfo;
import org.eclipse.comma.java.JSourceInfos;
import org.eclipse.comma.java.impl.JArtifactInfoImpl;

public class JArtifactInfoBuilder {
    private File archiveFile;
    private List<JClassInfo> classInfos = new ArrayList<JClassInfo>();
    private List<JDependencyInfo> dependencyInfos = new ArrayList<JDependencyInfo>();
    private List<JSourceInfo> resources = new ArrayList<JSourceInfo>();
    private String mainClass;
    private Manifest manifest;

    public JArtifactInfoBuilder withArchiveFile(File archiveFile) {
        this.archiveFile = Objects.requireNonNull(archiveFile, "archiveFile must not be null");
        return this;
    }

    public JArtifactInfoBuilder withClassInfos(JClassInfo ... classInfos) {
        JClassInfo[] jClassInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JClassInfo cInfo = jClassInfoArray[n2];
            this.classInfos.add(Objects.requireNonNull(cInfo, "classInfo must not be null"));
            ++n2;
        }
        return this;
    }

    public JArtifactInfoBuilder withClassInfos(Collection<JClassInfo> classInfos) {
        classInfos.forEach(ci -> {
            JArtifactInfoBuilder jArtifactInfoBuilder = this.withClassInfos((JClassInfo)ci);
        });
        return this;
    }

    public JArtifactInfoBuilder withDependencyInfos(JDependencyInfo ... dependencyInfos) {
        JDependencyInfo[] jDependencyInfoArray = dependencyInfos;
        int n = dependencyInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JDependencyInfo dInfos = jDependencyInfoArray[n2];
            this.dependencyInfos.add(Objects.requireNonNull(dInfos, "dependencyInfo must not be null"));
            ++n2;
        }
        return this;
    }

    public JArtifactInfoBuilder withDependencyInfos(Collection<JDependencyInfo> dependencyInfos) {
        dependencyInfos.forEach(di -> {
            JArtifactInfoBuilder jArtifactInfoBuilder = this.withDependencyInfos((JDependencyInfo)di);
        });
        return this;
    }

    public JArtifactInfoBuilder withResources(JSourceInfo ... resources) {
        JSourceInfo[] jSourceInfoArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            JSourceInfo rInfo = jSourceInfoArray[n2];
            if (JSourceInfos.isResource(rInfo)) {
                throw new IllegalArgumentException("resource '" + rInfo + "' ist not null");
            }
            this.resources.add(rInfo);
            ++n2;
        }
        return this;
    }

    public JArtifactInfoBuilder withResources(Collection<JSourceInfo> resources) {
        resources.forEach(r -> {
            JArtifactInfoBuilder jArtifactInfoBuilder = this.withResources((JSourceInfo)r);
        });
        return this;
    }

    public JArtifactInfoBuilder withMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public JArtifactInfoBuilder withManifest(Manifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public JArtifactInfo build() throws IOException {
        this.makeArchive();
        return new JArtifactInfoImpl(this.archiveFile, this.dependencyInfos, this.getMainClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeArchive() throws IOException {
        this.archiveFile.delete();
        this.prepareManifest();
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileOutputStream stream = new FileOutputStream(this.archiveFile);
            try {
                try (JarOutputStream out = new JarOutputStream((OutputStream)stream, this.manifest);){
                    for (JClassInfo classInfo : this.classInfos) {
                        JarEntry jarEntry = JClassInfos.toJarEntry(classInfo);
                        out.putNextEntry(jarEntry);
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (FileInputStream in = new FileInputStream(classInfo.getLocation());){
                            int nRead;
                            byte[] buffer = new byte[10240];
                            while ((nRead = in.read(buffer)) > 0) {
                                out.write(buffer, 0, nRead);
                            }
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        out.closeEntry();
                    }
                }
                if (stream == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private void prepareManifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        if (!this.manifest.getMainAttributes().containsKey(Attributes.Name.MANIFEST_VERSION)) {
            this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        if (this.mainClass != null) {
            this.manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
    }

    private String getMainClass() {
        return (String)this.manifest.getMainAttributes().get(Attributes.Name.MAIN_CLASS);
    }
}

