/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.emf.common.util.EList;

public class ClauseParserUtility {
    private HashMap<String, ArrayList<Transition>> notifications_map;
    private ArrayList<Transition> list_of_notification_transitions;
    private String signature_name;

    public ClauseParserUtility(String _signature_name) {
        HashMap _hashMap = new HashMap();
        this.notifications_map = _hashMap;
        this.signature_name = _signature_name;
    }

    public HashMap<String, ArrayList<Transition>> getNotificationsMap() {
        return this.notifications_map;
    }

    public void generateAllActionsForClause(Action action, NonTriggeredTransition transition) {
        if (action instanceof AssignmentAction || action instanceof IfAction || action instanceof RecordFieldAssignmentAction || action instanceof CommandReply || action instanceof EventCall) {
            this.generateAssignmentAction(action, transition);
        }
    }

    protected void _generateAssignmentAction(AssignmentAction action, NonTriggeredTransition transition) {
    }

    protected void _generateAssignmentAction(IfAction action, NonTriggeredTransition transition) {
        boolean _tripleNotEquals;
        EList _actions = action.getThenList().getActions();
        for (Action act : _actions) {
            this.generateAssignmentAction(act, transition);
        }
        ActionList _elseList = action.getElseList();
        boolean bl = _tripleNotEquals = _elseList != null;
        if (_tripleNotEquals) {
            EList _actions_1 = action.getElseList().getActions();
            for (Action act_1 : _actions_1) {
                this.generateAssignmentAction(act_1, transition);
            }
        }
    }

    protected void _generateAssignmentAction(RecordFieldAssignmentAction action, NonTriggeredTransition transition) {
    }

    protected void _generateAssignmentAction(CommandReply action, NonTriggeredTransition transition) {
    }

    protected void _generateAssignmentAction(EventCall action, NonTriggeredTransition transition) {
        boolean _not;
        EventCall eventAction = action;
        String _name = eventAction.getEvent().getName();
        String eventActionName = String.valueOf(this.signature_name) + "_" + _name;
        boolean _containsKey = this.notifications_map.containsKey(eventActionName);
        if (_containsKey) {
            this.list_of_notification_transitions = this.notifications_map.get(eventActionName);
        } else {
            ArrayList _arrayList = new ArrayList();
            this.list_of_notification_transitions = _arrayList;
        }
        boolean _contains = this.list_of_notification_transitions.contains(transition);
        boolean bl = _not = !_contains;
        if (_not) {
            this.list_of_notification_transitions.add(transition);
        }
        this.notifications_map.put(eventActionName, this.list_of_notification_transitions);
    }

    public void generateAssignmentAction(Action action, NonTriggeredTransition transition) {
        if (action instanceof EventCall) {
            this._generateAssignmentAction((EventCall)action, transition);
            return;
        }
        if (action instanceof AssignmentAction) {
            this._generateAssignmentAction((AssignmentAction)action, transition);
            return;
        }
        if (action instanceof CommandReply) {
            this._generateAssignmentAction((CommandReply)action, transition);
            return;
        }
        if (action instanceof IfAction) {
            this._generateAssignmentAction((IfAction)action, transition);
            return;
        }
        if (action instanceof RecordFieldAssignmentAction) {
            this._generateAssignmentAction((RecordFieldAssignmentAction)action, transition);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(action, transition).toString());
    }
}

