/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.comma.java.JSourceInfo;
import org.eclipse.comma.java.impl.JSourceInfoImpl;

public class JSourceInfos {
    public static Set<JSourceInfo> getJavaSourcesFromSrcDirectory(String directory) throws IOException {
        return JSourceInfos.getJavaSourcesFromSrcDirectory(new File(directory));
    }

    public static Set<JSourceInfo> getJavaSourcesFromSrcDirectory(File directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> files = Files.walk(Paths.get(directory.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
            return files.filter(p -> !p.toFile().equals(directory) && JSourceInfos.isJavaSource(p.toFile())).map(p -> new JSourceInfoImpl(p.toFile(), JSourceInfos.getName(directory, p))).collect(Collectors.toSet());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Set<JSourceInfo> getResourcesFromSrcDirectory(String directory) throws IOException {
        return JSourceInfos.getJavaSourcesFromSrcDirectory(new File(directory));
    }

    public static Set<JSourceInfo> getResourcesFromSrcDirectory(File directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> files = Files.walk(Paths.get(directory.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
            return files.filter(p -> !p.toFile().equals(directory) && JSourceInfos.isResource(p.toFile())).map(p -> new JSourceInfoImpl(p.toFile(), JSourceInfos.getName(directory, p))).collect(Collectors.toSet());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isJavaSource(File file) {
        return file != null && file.getAbsolutePath().endsWith(".java") && file.isFile();
    }

    public static boolean isJavaSource(JSourceInfo sourceInfo) {
        return sourceInfo != null && JSourceInfos.isJavaSource(sourceInfo.getLocation());
    }

    public static boolean isResource(File file) {
        return file != null && !JSourceInfos.isJavaSource(file) && file.isFile();
    }

    public static boolean isResource(JSourceInfo sourceInfo) {
        return sourceInfo != null && !JSourceInfos.isJavaSource(sourceInfo);
    }

    static String getName(File directory, Path classFile) {
        String prefix = directory.getAbsolutePath();
        String className = classFile.toFile().getAbsolutePath();
        if (className.startsWith(prefix)) {
            className = className.substring(prefix.length());
        }
        if ((className = className.replace('/', '.').replace('\\', '.').replaceFirst(".java$", "")).indexOf(46) == 0) {
            className = className.substring(1);
        }
        return className;
    }

    static JarEntry toJarEntry(JSourceInfo jSrc) {
        String jarFileName = jSrc.getName();
        if (JSourceInfos.isJavaSource(jSrc)) {
            jarFileName = String.valueOf(jSrc.getName().replaceAll("\\.", "/")) + ".class";
        }
        return new JarEntry(jarFileName);
    }
}

