/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.quickfix;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticModificationContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.ide.server.rename.ChangeConverter2;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;

public class DiagnosticResolution {
    private String label;
    private IChangeSerializer.IModification<EObject> modification;
    private DiagnosticModificationContext.Factory factory;
    private int relevance;
    private ICodeActionService2.Options options;

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContextFactory, IChangeSerializer.IModification<EObject> modification) {
        this(label, modificationContextFactory, modification, 0);
    }

    public DiagnosticResolution(String label, DiagnosticModificationContext.Factory modificationContext, IChangeSerializer.IModification<EObject> modification, int relevance) {
        this.label = label;
        this.factory = modificationContext;
        this.modification = modification;
        this.relevance = relevance;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public String getLabel() {
        return this.label;
    }

    public WorkspaceEdit apply() {
        DiagnosticModificationContext modificationContext = this.factory.createModificationContext();
        try {
            XtextResource resource = this.options.getResource();
            URI uri = resource.getURI();
            ILanguageServerAccess access = this.options.getLanguageServerAccess();
            WorkspaceEdit edit = new WorkspaceEdit();
            ChangeConverter2 changeConverter = modificationContext.getConverterFactory().create(edit, access);
            ResourceSet resourceSet = access.newLiveScopeResourceSet(uri);
            XtextResource tmpResource = (XtextResource)resourceSet.getResource(uri, true);
            CodeActionParams params = this.options.getCodeActionParams();
            int offset = this.options.getDocument().getOffSet(params.getRange().getStart());
            EObjectAtOffsetHelper helper = new EObjectAtOffsetHelper();
            EObject obj = helper.resolveContainedElementAt(tmpResource, offset);
            IChangeSerializer serializer = modificationContext.getSerializer();
            serializer.addModification(obj, this.modification);
            serializer.applyModifications(changeConverter);
            return edit;
        }
        catch (Exception exc) {
            throw new WrappedException(exc);
        }
    }

    void configure(ICodeActionService2.Options options) {
        this.options = options;
    }
}

