/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.simulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

class PlantUMLPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage image;
    private String source;
    private int lastWidth = -1;
    private int height = 0;

    public PlantUMLPane() {
        this.setBackground(Color.WHITE);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (PlantUMLPane.this.lastWidth != -1 && PlantUMLPane.this.getWidth() != PlantUMLPane.this.lastWidth) {
                    PlantUMLPane.this.updateImage();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public void setSource(String source) {
        if (this.source == null || !source.equals(this.source)) {
            this.source = source;
            this.updateImage();
        }
    }

    private void updateImage() {
        if (this.source != null) {
            try {
                String sourceDpi = this.source.replace("@enduml", "skinparam dpi 150\n@enduml");
                SourceStringReader reader = new SourceStringReader(sourceDpi);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.PNG));
                ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
                this.image = ImageIO.read(in);
                this.lastWidth = this.getWidth();
                double factor = (double)this.image.getWidth() / (double)this.getWidth();
                this.height = (int)((double)this.image.getHeight() / factor);
                this.revalidate();
                this.repaint();
                if (this.getParent().getParent() instanceof JScrollPane) {
                    final JScrollPane scroll = (JScrollPane)this.getParent().getParent();
                    JScrollBar bar = scroll.getVerticalScrollBar();
                    int current = bar.getValue() + bar.getModel().getExtent();
                    int max = scroll.getVerticalScrollBar().getMaximum();
                    if (max == current) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                scroll.getVerticalScrollBar().setValue(scroll.getVerticalScrollBar().getMaximum());
                            }
                        });
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this.getWidth(), this.height, this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, this.height);
    }
}

