/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetCompletionProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetDefinitionContentAssist;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.DelegateProcessor;

public class TagValueCompletionProcessor
extends DelegateProcessor {
    private static final Map<String, String[]> tagTextValues = new HashMap<String, String[]>();
    private String searchTerm;
    private String acKey;
    private int offset;

    static {
        tagTextValues.put("os", Platform.knownOSValues());
        tagTextValues.put("ws", Platform.knownWSValues());
        tagTextValues.put("arch", Platform.knownOSArchValues());
        tagTextValues.put("nl", TagValueCompletionProcessor.getLocales());
    }

    public TagValueCompletionProcessor(String searchTerm, String acKey, int offset) {
        this.searchTerm = searchTerm;
        this.offset = offset;
        this.acKey = acKey;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals() {
        ArrayList<TargetCompletionProposal> proposals = new ArrayList<TargetCompletionProposal>();
        Object[] strings = tagTextValues.get(this.acKey);
        if (strings != null) {
            Arrays.sort(strings);
            Object[] objectArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                Object string = objectArray[n2];
                StyledString displayString = TargetDefinitionContentAssist.getFilteredStyledString((String)string, this.searchTerm);
                if (displayString != null && displayString.length() != 0) {
                    proposals.add(new TargetCompletionProposal((String)string, ((String)string).length(), this.offset - this.searchTerm.length(), this.searchTerm.length(), displayString));
                }
                ++n2;
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public static String[] getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        String[] result = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            result[i] = locales[i].toString();
            ++i;
        }
        return result;
    }
}

