/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.cli;

import com.google.common.base.Preconditions;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xtext.wizard.AbstractFile;
import org.eclipse.xtext.xtext.wizard.BinaryFile;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectsCreator;
import org.eclipse.xtext.xtext.wizard.SourceFolderDescriptor;
import org.eclipse.xtext.xtext.wizard.TextFile;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;

public class CliProjectsCreator
implements ProjectsCreator {
    private String lineDelimiter;

    @Override
    public void createProjects(WizardConfiguration config) {
        for (ProjectDescriptor p : config.getEnabledProjects()) {
            this.createProject(p);
        }
    }

    public void createProject(ProjectDescriptor project) {
        Preconditions.checkNotNull((Object)this.lineDelimiter, (Object)"lineDelimiter may not be null");
        try {
            File projectRoot = new File(project.getLocation());
            projectRoot.mkdirs();
            for (AbstractFile abstractFile : project.getFiles()) {
                String outletPath = project.getConfig().getSourceLayout().getPathFor(abstractFile.getOutlet());
                String projectRelativePath = outletPath + "/" + abstractFile.getRelativePath();
                File file = new File(projectRoot, projectRelativePath);
                file.getParentFile().mkdirs();
                if (abstractFile instanceof TextFile) {
                    String normalizedContent = ((TextFile)abstractFile).getContent().replace(Strings.newLine(), this.lineDelimiter);
                    Files.asCharSink((File)file, (Charset)project.getConfig().getEncoding(), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)normalizedContent);
                } else if (abstractFile instanceof BinaryFile) {
                    Files.write((byte[])Resources.toByteArray((URL)((BinaryFile)abstractFile).getContent()), (File)file);
                }
                if (!abstractFile.isExecutable()) continue;
                file.setExecutable(true);
            }
            for (SourceFolderDescriptor sourceFolderDescriptor : project.getSourceFolders()) {
                new File(projectRoot, sourceFolderDescriptor.getPath()).mkdirs();
            }
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }
}

