/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.util.List;
import java.util.function.Function;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.modelqualitychecks.PInput;
import org.eclipse.comma.modelqualitychecks.PPlace;
import org.eclipse.comma.modelqualitychecks.SnakesHelper;

class PGuard {
    private Expression expression = null;
    private boolean inverse = false;
    private PRepeatGuardType repeatGuardType = null;
    private Long repeatGuardValue = null;

    PGuard(Expression expression) {
        this(expression, false);
    }

    PGuard(Expression expression, boolean inverse) {
        assert (expression != null);
        this.expression = expression;
        this.inverse = inverse;
    }

    PGuard(PRepeatGuardType repeatGuardType, Long repeatGuardValue) {
        this.repeatGuardType = repeatGuardType;
        this.repeatGuardValue = repeatGuardValue;
    }

    String toSnakes(Function<String, String> variablePrefix, List<PInput> inputs) {
        if (this.expression != null) {
            Function<String, String> variablePrefix2 = variable -> {
                boolean inTransition = inputs.stream().anyMatch(i -> i.place.type == PPlace.PPlaceType.TRANSITION || i.place.type == PPlace.PPlaceType.CLAUSE);
                String prefix = inTransition ? "gl." : "";
                return String.valueOf(prefix) + (String)variablePrefix.apply((String)variable);
            };
            String expr = SnakesHelper.expression(this.expression, variablePrefix2);
            if (this.inverse) {
                expr = String.format("not (%s)", expr);
            }
            return expr;
        }
        String operation = this.repeatGuardType == PRepeatGuardType.MAX ? "<" : ">=";
        return String.format("gl.r %s %d", operation, this.repeatGuardValue);
    }

    static enum PRepeatGuardType {
        MIN,
        MAX;

    }
}

