/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.testclient;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.PetrinetBuilder;
import org.eclipse.xtext.scoping.IScopeProvider;

public class TestClientGenerator {
    public static String generateForComponent(Component component, List<Parameters> parameters, IScopeProvider scopeProvider) {
        String petrinetCode = PetrinetBuilder.forComponent((Component)component, parameters, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.INTERACTIVE);
        return TestClientGenerator.generate(petrinetCode);
    }

    public static String generateForInterface(Interface itf, Parameters parameters, IScopeProvider scopeProvider) {
        String petrinetCode = PetrinetBuilder.forInterface((Interface)itf, (Parameters)parameters, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.INTERACTIVE);
        return TestClientGenerator.generate(petrinetCode);
    }

    private static String generate(String petrinetCode) {
        String code = "SELF_CONTAINED = True\n" + PetrinetBuilder.getModelCode() + PetrinetBuilder.getWalkerCode();
        code = String.valueOf(code) + petrinetCode + "\n\n";
        code = String.valueOf(code) + "## test_client.py\n" + TestClientGenerator.getResourceText("/test_client.py") + "\n\n";
        return code;
    }

    private static String getResourceText(String resource) {
        InputStream stream = TestClientGenerator.class.getResourceAsStream(resource);
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }
}

