/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.internal.monitoring.Messages;
import org.eclipse.ui.internal.monitoring.MonitoringPlugin;
import org.eclipse.ui.monitoring.StackSample;

public class FilterHandler {
    private static final String DOUBLE_BACKSLASH = "\\\\";
    private final CompoundName compoundName = new CompoundName("", "");
    private final StackFrame[] filterFrames;
    private final Pattern[] filterPatterns;

    public FilterHandler(String commaSeparatedMethods) {
        String[] filters = commaSeparatedMethods.split(",");
        ArrayList<StackFrame> stackFrames = new ArrayList<StackFrame>(filters.length);
        ArrayList<Pattern> stackPatterns = new ArrayList<Pattern>(filters.length);
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (this.containsWildcards(filter)) {
                Pattern pattern = FilterHandler.createPattern(filter);
                stackPatterns.add(pattern);
            } else {
                int lastDot = filter.lastIndexOf(46);
                stackFrames.add(lastDot >= 0 ? new StackFrame(filter.substring(0, lastDot), filter.substring(lastDot + 1)) : new StackFrame("", filter));
            }
            ++n2;
        }
        stackFrames.sort(null);
        this.filterFrames = stackFrames.toArray(new StackFrame[stackFrames.size()]);
        this.filterPatterns = stackPatterns.toArray(new Pattern[stackPatterns.size()]);
    }

    public boolean shouldLogEvent(StackSample[] stackSamples, int numSamples, long displayThreadId) {
        if (this.filterFrames.length != 0 || this.filterPatterns.length != 0) {
            int i = 0;
            while (i < numSamples) {
                if (this.hasFilteredTraces(stackSamples[i].getStackTraces(), displayThreadId)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean hasFilteredTraces(ThreadInfo[] stackTraces, long displayThreadId) {
        ThreadInfo[] threadInfoArray = stackTraces;
        int n = stackTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            if (threadInfo.getThreadId() == displayThreadId) {
                StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                int n3 = stackTraceElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement element = stackTraceElementArray[n4];
                    if (this.matchesFilter(element)) {
                        return true;
                    }
                    ++n4;
                }
                return false;
            }
            ++n2;
        }
        MonitoringPlugin.logError(Messages.FilterHandler_missing_thread_error, null);
        return false;
    }

    boolean matchesFilter(StackTraceElement stackFrame) {
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        if (this.filterPatterns.length != 0) {
            this.compoundName.reset(className, methodName);
            Pattern[] patternArray = this.filterPatterns;
            int n = this.filterPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                if (pattern.matcher(this.compoundName).matches()) {
                    return true;
                }
                ++n2;
            }
        }
        int low = 0;
        int high = this.filterFrames.length;
        while (low < high) {
            int mid = low + high >>> 1;
            StackFrame filter = this.filterFrames[mid];
            int c = methodName.compareTo(filter.methodName);
            if (c == 0) {
                c = className.compareTo(filter.className);
            }
            if (c == 0) {
                return true;
            }
            if (c < 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return false;
    }

    private boolean containsWildcards(String pattern) {
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c != '.' && !Character.isJavaIdentifierPart(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Pattern createPattern(String pattern) throws PatternSyntaxException {
        int len = pattern.length();
        StringBuilder buf = new StringBuilder(len * 2);
        boolean isEscaped = false;
        int i = 0;
        while (i < len) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    if (!isEscaped) {
                        isEscaped = true;
                        break;
                    }
                    buf.append(DOUBLE_BACKSLASH);
                    isEscaped = false;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (isEscaped) {
                        buf.append(DOUBLE_BACKSLASH);
                        isEscaped = false;
                    }
                    buf.append('\\');
                    buf.append(c);
                    break;
                }
                case '?': {
                    if (!isEscaped) {
                        buf.append('.');
                        break;
                    }
                    buf.append('\\');
                    buf.append(c);
                    isEscaped = false;
                    break;
                }
                case '*': {
                    if (!isEscaped) {
                        buf.append(".*");
                        break;
                    }
                    buf.append('\\');
                    buf.append(c);
                    isEscaped = false;
                    break;
                }
                default: {
                    if (isEscaped) {
                        buf.append(DOUBLE_BACKSLASH);
                        isEscaped = false;
                    }
                    buf.append(c);
                }
            }
            ++i;
        }
        if (isEscaped) {
            buf.append(DOUBLE_BACKSLASH);
            isEscaped = false;
        }
        return Pattern.compile(buf.toString());
    }

    private static class CompoundName
    implements CharSequence {
        private String first;
        private String last;

        CompoundName(String first, String last) {
            Assert.isNotNull((Object)first);
            Assert.isNotNull((Object)last);
            this.first = first;
            this.last = last;
        }

        void reset(String first, String last) {
            Assert.isNotNull((Object)first);
            Assert.isNotNull((Object)last);
            this.first = first;
            this.last = last;
        }

        @Override
        public int length() {
            return this.first.length() + 1 + this.last.length();
        }

        @Override
        public char charAt(int index) {
            int firstLen = this.first.length();
            if (index < firstLen) {
                return this.first.charAt(index);
            }
            if (index == firstLen) {
                return '.';
            }
            return this.last.charAt(index - firstLen - 1);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            int lastOffset = this.first.length() + 1;
            if (end < lastOffset) {
                return this.first.subSequence(start, end);
            }
            if (start < lastOffset) {
                return new CompoundName(this.first.substring(start), this.last.substring(0, end - lastOffset));
            }
            return this.last.subSequence(start - lastOffset, end - lastOffset);
        }

        @Override
        public String toString() {
            return String.valueOf(this.first) + '.' + this.last;
        }
    }

    private static class StackFrame
    implements Comparable<StackFrame> {
        final String className;
        final String methodName;

        public StackFrame(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        @Override
        public int compareTo(StackFrame other) {
            int c = this.methodName.compareTo(other.methodName);
            if (c != 0) {
                return c;
            }
            return this.className.compareTo(other.className);
        }
    }
}

