/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class CompositeResourceMapping
extends ResourceMapping {
    private final ResourceMapping[] mappings;
    private final Object modelObject;
    private IProject[] projects;
    private String providerId;

    public CompositeResourceMapping(String providerId, Object modelObject, ResourceMapping[] mappings) {
        this.modelObject = modelObject;
        this.mappings = mappings;
        this.providerId = providerId;
    }

    @Override
    public boolean contains(ResourceMapping mapping) {
        ResourceMapping[] resourceMappingArray = this.mappings;
        int n = this.mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping childMapping = resourceMappingArray[n2];
            if (childMapping.contains(mapping)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ResourceMapping[] getMappings() {
        return this.mappings;
    }

    @Override
    public Object getModelObject() {
        return this.modelObject;
    }

    @Override
    public String getModelProviderId() {
        return this.providerId;
    }

    @Override
    public IProject[] getProjects() {
        if (this.projects == null) {
            HashSet<IProject> result = new HashSet<IProject>();
            ResourceMapping[] resourceMappingArray = this.mappings;
            int n = this.mappings.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceMapping mapping = resourceMappingArray[n2];
                result.addAll(Arrays.asList(mapping.getProjects()));
                ++n2;
            }
            this.projects = result.toArray(new IProject[result.size()]);
        }
        return this.projects;
    }

    @Override
    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.mappings.length);
        ArrayList result = new ArrayList();
        ResourceMapping[] resourceMappingArray = this.mappings;
        int n = this.mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            Collections.addAll(result, mapping.getTraversals(context, (IProgressMonitor)subMonitor.newChild(1)));
            ++n2;
        }
        return result.toArray(new ResourceTraversal[result.size()]);
    }
}

