/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.utils.StringBuilder2;

public abstract class CError {
    protected List<CObservedMessage> context = new ArrayList<CObservedMessage>();
    @Expose
    protected String errorDescription;
    @Expose
    protected List<String> contextError;
    @Expose
    protected String lastEventId = "";
    @Expose
    protected String umlFile = null;

    public List<CObservedMessage> getErrorContext() {
        return this.context;
    }

    public void setErrorContext(List<CObservedMessage> errorContext) {
        this.context = errorContext;
        if (!this.context.isEmpty()) {
            CObservedMessage last = this.context.get(this.context.size() - 1);
            this.lastEventId = last.getMessageId();
            this.contextError = new ArrayList<String>();
            int i = 0;
            while (i < this.context.size()) {
                this.contextError.add(this.context.get(i).toString());
                ++i;
            }
        }
    }

    public String getUMLFile() {
        return this.umlFile;
    }

    public void setUMLFile(String umlFile) {
        this.umlFile = umlFile;
    }

    protected String traceContextToText() {
        StringBuilder2 builder = new StringBuilder2();
        builder.append("Trace context that leads to error:");
        builder.newLine();
        builder.newLine();
        int i = 0;
        while (i < this.context.size()) {
            if (i == 0) {
                builder.append(this.context.get(i).printStringWithState());
            } else {
                builder.append(this.context.get(i).toString());
            }
            builder.newLine();
            ++i;
        }
        return builder.toString();
    }

    protected String traceContextToUML() {
        StringBuilder2 builder = new StringBuilder2();
        int i = 0;
        while (i < this.context.size()) {
            if (i == this.context.size() - 1) {
                builder.append(this.context.get(i).printUMLWithTime());
            } else if (i == 0) {
                builder.append(this.context.get(i).printUMLWithState());
            } else {
                builder.append(this.context.get(i).printUML());
            }
            builder.newLine();
            ++i;
        }
        return builder.toString();
    }

    public abstract String toString();

    public abstract String toUML();
}

