/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.generator.plantuml.BehaviorUmlGenerator;
import org.eclipse.comma.behavior.interfaces.generator.InterfaceFileSystemAccess;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.service.DocService;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.util.ClassProvider;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class DocumentationGeneratorTask
extends GeneratorTask {
    private static final String ERROR = "Documentation Generation error(s): ";
    protected final DocumentationGenerationTask task;
    protected final CommaFileSystemAccess umlFileSystemAccess;
    protected final CommaFileSystemAccess docFileSystemAccess;
    protected final ResourceSet resourceSet;
    protected List<Interface> sourceInterfaces;
    protected List<Signature> sourceSignatures = new ArrayList<Signature>();

    public DocumentationGeneratorTask(DocumentationGenerationTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        CommaFileSystemAccess _commaFileSystemAccess;
        this.task = task;
        this.umlFileSystemAccess = InterfaceFileSystemAccess.getUMLFileSystemAccess((String)task.getName(), (IFileSystemAccess2)fsa);
        this.docFileSystemAccess = _commaFileSystemAccess = new CommaFileSystemAccess("doc" + Character.valueOf('/'), fsa);
        this.resourceSet = this.task.eResource().getResourceSet();
    }

    public URI createResultFileURI() {
        StringConcatenation _builder = new StringConcatenation();
        String _targetFile = this.task.getTargetFile();
        _builder.append(_targetFile);
        return URI.createURI((String)_builder.toString());
    }

    @Override
    public void doGenerate() {
        this.sourceInterfaces = this.outputLocator.getInterfaces(this.task.getSource());
        Consumer<Interface> _function = new Consumer<Interface>(){

            @Override
            public void accept(Interface it) {
                DocumentationGeneratorTask.this.sourceSignatures.add(DocumentationGeneratorTask.this.getSignature(it));
            }
        };
        this.sourceInterfaces.forEach(_function);
        try {
            boolean _not;
            List<Interface> behaviors = this.sourceInterfaces;
            URI docURI = this.createDocDir();
            URI templateURI = this.createTemplateURI();
            for (Interface behavior : behaviors) {
                BehaviorUmlGenerator umlGen = new BehaviorUmlGenerator((AbstractBehavior)behavior, (IFileSystemAccess)this.umlFileSystemAccess);
                umlGen.setPrjURIForImages(this.resource.getURI());
                umlGen.doGenerate();
            }
            ClassLoader _classLoader = this.getClass().getClassLoader();
            ClassProvider classProvider = new ClassProvider(_classLoader);
            IQueryEnvironment queryEnvironment = this.createQueryEnvironment(templateURI);
            URIConverter _uRIConverter = this.resourceSet.getURIConverter();
            BasicMonitor _basicMonitor = new BasicMonitor();
            DocumentTemplate template = M2DocUtils.parse((URIConverter)_uRIConverter, (URI)templateURI, (IQueryEnvironment)queryEnvironment, (IClassProvider)classProvider, (Monitor)_basicMonitor);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            this.setVariables(variables);
            BasicMonitor _basicMonitor_1 = new BasicMonitor();
            GenerationResult genResult = M2DocUtils.generate((DocumentTemplate)template, (IReadOnlyQueryEnvironment)queryEnvironment, variables, (ResourceSet)this.resourceSet, (URI)docURI, (boolean)false, (Monitor)_basicMonitor_1);
            boolean _isEmpty = genResult.getMessages().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.errors.add(ERROR);
            }
            List _messages = genResult.getMessages();
            for (TemplateValidationMessage message : _messages) {
                this.errors.add(message.getMessage());
            }
        }
        catch (Throwable _t) {
            if (_t instanceof DocumentParserException) {
                DocumentParserException exception = (DocumentParserException)_t;
                String _message = exception.getMessage();
                String _plus = ERROR + _message;
                String _plus_1 = String.valueOf(_plus) + "\n";
                Throwable _cause = exception.getCause();
                String _plus_2 = String.valueOf(_plus_1) + _cause;
                this.errors.add(_plus_2);
            }
            if (_t instanceof DocumentGenerationException) {
                DocumentGenerationException exception_1 = (DocumentGenerationException)_t;
                String _message_1 = exception_1.getMessage();
                String _plus_3 = ERROR + _message_1;
                String _plus_4 = String.valueOf(_plus_3) + "\n";
                Throwable _cause_1 = exception_1.getCause();
                String _plus_5 = String.valueOf(_plus_4) + _cause_1;
                this.errors.add(_plus_5);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected Object setVariables(HashMap<String, Object> variables) {
        List<Signature> _xblockexpression = null;
        URI outputUri = this.getOutputURI(this.umlFileSystemAccess);
        variables.put("task", this.task);
        variables.put("myModel", this.task.eContainer().eContainer().eContainer());
        variables.put("globalTypes", StateMachineUtilities.getGlobalTypes((EObject)this.task, (IScopeProvider)this.scopeProvider));
        variables.put("outputPath", outputUri.toFileString());
        variables.put("interfaces", this.sourceInterfaces);
        _xblockexpression = variables.put("signatures", this.sourceSignatures);
        return _xblockexpression;
    }

    private IQueryEnvironment createQueryEnvironment(URI templateURI) {
        IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.registerPackage(queryEnvironment, "https://www.eclipse.org/comma/project/Project");
        this.registerPackage(queryEnvironment, "https://www.eclipse.org/comma/signature/InterfaceSignature");
        this.registerPackage(queryEnvironment, "https://www.eclipse.org/comma/types/Types");
        this.registerPackage(queryEnvironment, "https://www.eclipse.org/comma/behavior/Behavior");
        this.registerPackage(queryEnvironment, "https://www.eclipse.org/comma/behavior/interfaces/InterfaceDefinition");
        this.registerPackage(queryEnvironment, "https://www.eclipse.org/comma/expressions/Expression");
        this.registerPackage(queryEnvironment, "https://www.eclipse.org/comma/actions/Actions");
        HashMap options = new HashMap();
        M2DocUtils.prepareEnvironmentServices((IQueryEnvironment)queryEnvironment, (ResourceSet)this.resourceSet, (URI)templateURI, options);
        this.registerProjectPackageAndService(queryEnvironment);
        return queryEnvironment;
    }

    protected ServiceRegistrationResult registerProjectPackageAndService(IQueryEnvironment queryEnvironment) {
        ServiceRegistrationResult _xblockexpression = null;
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, DocService.class);
        _xblockexpression = ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        return _xblockexpression;
    }

    protected void registerPackage(IQueryEnvironment env, String packageUri) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageUri);
        env.registerEPackage(ePackage);
    }

    private URI getOutputURI(CommaFileSystemAccess commaFsa) {
        boolean _hasTrailingPathSeparator;
        boolean _not;
        URI outputDir;
        URI rURI = this.resource.getURI();
        boolean _isPlatform = rURI.isPlatform();
        if (_isPlatform) {
            IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(rURI.toPlatformString(true));
            rURI = URI.createFileURI((String)eclipseResource.getRawLocation().toOSString());
        }
        if ((outputDir = commaFsa.getOutputConfiguration()) == null) {
            throw new IllegalArgumentException("Output directory was not set.");
        }
        boolean _isRelative = outputDir.isRelative();
        if (_isRelative) {
            outputDir = outputDir.resolve(rURI);
        }
        boolean bl = _not = !(_hasTrailingPathSeparator = outputDir.hasTrailingPathSeparator());
        if (_not) {
            outputDir.appendSegment("");
        }
        return outputDir;
    }

    private URI createDocDir() {
        boolean _not;
        URI docURI = this.getOutputURI(this.docFileSystemAccess);
        String _path = docURI.path();
        File docFile = new File(_path);
        boolean _exists = docFile.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            boolean _not_1;
            boolean _mkdirs = docFile.mkdirs();
            boolean bl2 = _not_1 = !_mkdirs;
            if (_not_1) {
                String _path_1 = docFile.getPath();
                String _plus = "Could not create doc output directory: " + _path_1;
                throw new IllegalArgumentException(_plus);
            }
        }
        return this.createResultFileURI().resolve(docURI);
    }

    private URI createTemplateURI() {
        URI _xblockexpression = null;
        String template = this.task.getTemplate();
        URI _xifexpression = null;
        _xifexpression = template != null ? URI.createURI((String)template) : URI.createURI((String)"Template.docx");
        URI nameURI = _xifexpression;
        _xblockexpression = nameURI.resolve(this.task.eResource().getURI());
        return _xblockexpression;
    }
}

