/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.DoWhileRatherThanWhileFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class DoWhileRatherThanWhileCleanUpCore
extends AbstractCleanUpCore {
    public DoWhileRatherThanWhileCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public DoWhileRatherThanWhileCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.do_while_rather_than_while");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.do_while_rather_than_while")) {
            return null;
        }
        return DoWhileRatherThanWhileFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.do_while_rather_than_while")) {
            return new String[]{MultiFixMessages.DoWhileRatherThanWhileCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.do_while_rather_than_while")) {
            bld.append("do {\n");
        } else {
            bld.append("while (true) {\n");
        }
        bld.append("    if (i > 100) {\n");
        bld.append("        return;\n");
        bld.append("    }\n");
        bld.append("    i *= 2;\n");
        if (this.isEnabled("cleanup.do_while_rather_than_while")) {
            bld.append("} while (true);\n");
        } else {
            bld.append("}\n");
        }
        return bld.toString();
    }
}

