/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.CommandLineQuoting;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;

public class CommandLineShortener {
    private final String javaVersion;
    private final ILaunch launch;
    private final String[] cmdLine;
    private File processTempFilesDir;
    private final List<File> processTempFiles = new ArrayList<File>();

    public static String getJavaVersion(IVMInstall vmInstall) {
        if (vmInstall instanceof IVMInstall2) {
            IVMInstall2 install = (IVMInstall2)((Object)vmInstall);
            return install.getJavaVersion();
        }
        return null;
    }

    public CommandLineShortener(IVMInstall vmInstall, ILaunch launch, String[] cmdLine, File workingDir) {
        this(CommandLineShortener.getJavaVersion(vmInstall), launch, cmdLine, workingDir);
    }

    protected CommandLineShortener(String javaVersion, ILaunch launch, String[] cmdLine, File workingDir) {
        Assert.isNotNull((Object)javaVersion);
        Assert.isNotNull((Object)launch);
        Assert.isNotNull((Object)cmdLine);
        this.javaVersion = javaVersion;
        this.launch = launch;
        this.cmdLine = cmdLine;
        this.processTempFilesDir = workingDir != null ? workingDir : Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile();
    }

    protected void addProcessTempFile(File file) {
        this.processTempFiles.add(file);
    }

    protected File createArgumentFile(String[] cmdLine) throws CoreException {
        try {
            String timeStamp = this.getLaunchTimeStamp();
            File argumentsFile = new File(this.processTempFilesDir, String.format(".temp-%s-args-%s.txt", this.getLaunchConfigurationName(), timeStamp));
            cmdLine = this.quoteForArgfile(cmdLine);
            Files.write(argumentsFile.toPath(), Arrays.asList(cmdLine), new OpenOption[0]);
            return argumentsFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, "Cannot create argument file", (Throwable)e));
        }
    }

    String[] quoteForArgfile(String[] cmdLine) {
        String[] quotedCmdLine = new String[cmdLine.length];
        int i = 0;
        while (i < cmdLine.length) {
            String arg = cmdLine[i];
            if (CommandLineQuoting.needsQuoting(arg)) {
                StringBuilder escapedArg = new StringBuilder();
                int j = 0;
                while (j < arg.length()) {
                    char c = arg.charAt(j);
                    if (c == '\\') {
                        escapedArg.append('\\');
                    } else if (c == '\"') {
                        escapedArg.append('\\');
                    }
                    escapedArg.append(c);
                    ++j;
                }
                arg = "\"" + escapedArg.toString() + "\"";
            }
            quotedCmdLine[i] = arg;
            ++i;
        }
        return quotedCmdLine;
    }

    protected String getLaunchConfigurationName() {
        return this.launch.getLaunchConfiguration().getName();
    }

    protected String getLaunchTimeStamp() {
        String timeStamp = this.launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        if (timeStamp == null) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        return timeStamp;
    }

    public List<File> getProcessTempFiles() {
        return new ArrayList<File>(this.processTempFiles);
    }

    public File getProcessTempFilesDir() {
        return this.processTempFilesDir;
    }

    public String[] getOriginalCmdLine() {
        return this.cmdLine;
    }

    protected boolean isArgumentFileSupported() {
        return JavaCore.compareJavaVersions((String)this.javaVersion, (String)"9") >= 0;
    }

    public void setProcessTempFilesDir(File processTempFilesDir) {
        this.processTempFilesDir = processTempFilesDir;
    }

    public String[] shortenCommandLine() throws CoreException {
        ArrayList<String> fullCommandLine = new ArrayList<String>(Arrays.asList(this.cmdLine));
        ArrayList<String> shortCommandLine = new ArrayList<String>();
        shortCommandLine.add((String)fullCommandLine.remove(0));
        File argumentFile = this.createArgumentFile(fullCommandLine.toArray(new String[fullCommandLine.size()]));
        this.addProcessTempFile(argumentFile);
        shortCommandLine.add("@" + argumentFile.getAbsolutePath());
        return shortCommandLine.toArray(new String[shortCommandLine.size()]);
    }

    public boolean shouldShortenCommandLine() throws CoreException {
        if (!this.isArgumentFileSupported()) {
            return false;
        }
        if (this.cmdLine.length < 2) {
            return false;
        }
        ILaunchConfiguration configuration = this.launch.getLaunchConfiguration();
        if (configuration != null) {
            return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_ARGFILE, false);
        }
        return false;
    }
}

