/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.extensions.ProgressParams;

public class ProgressIndicatorJob
extends Job {
    private SubMonitor subMonitor;
    private int completedPercentage = 0;
    private String subTaskName;
    private boolean isCompleted = false;

    public ProgressIndicatorJob(String type) {
        super(type);
    }

    public void update(ProgressParams params) {
        if (params.isDone()) {
            this.isCompleted = true;
        } else if (params.getMessage() != null) {
            this.updateCrateName(params.getMessage());
        } else if (params.getPercentage() > this.completedPercentage) {
            this.updatePercentage(params.getPercentage());
        }
    }

    private void updateCrateName(String name) {
        if (this.subMonitor != null) {
            this.subMonitor.subTask(name);
        }
        this.subTaskName = name;
    }

    private void updatePercentage(int completedPercentage) {
        if (this.subMonitor != null) {
            this.subMonitor.worked(completedPercentage - this.completedPercentage);
        }
        this.completedPercentage = completedPercentage;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.completedPercentage > 0) {
            this.subMonitor.worked(this.completedPercentage);
        }
        try {
            this.subMonitor.beginTask(this.getName(), -1);
            if (this.subTaskName != null) {
                this.subMonitor.subTask(this.subTaskName);
            }
            while (!this.subMonitor.isCanceled() && !this.isCompleted) {
                Thread.sleep(50L);
            }
            if (this.isCompleted) {
                return Status.OK_STATUS;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return Status.CANCEL_STATUS;
    }
}

