/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;

public class CargoTestRunnerClient
implements ITestRunnerClient {
    private static final String STATUS_FAILED = "FAILED";
    private static final String TEST_PERFORMED_LINE_BEGIN = "test ";
    private static final String TEST_PERFORMED_LINE_END = "...";
    private static final String TEST_FAILURES_LINE = "failures:";
    private static final String TEST_STDOUT_LINE_BEGIN = "---- ";
    private static final String TEST_STDOUT_LINE_END = "stdout ----";
    private static final String TEST_NOTE_LINE = "note:";
    private static final String TEST_NAME_SEPARATOR = "::";
    private String fFailedTestCaseName = null;
    private StringBuilder fFailedTestStdout = new StringBuilder();
    private IProcess process;
    private ITestRunSession session;
    private InputStream inputStream;
    ProcessingState fDefaultState = new DefaultProcessingState();
    ProcessingState fTraceState = new TraceProcessingState();
    ProcessingState fCurrentState = this.fDefaultState;
    private String fLastLineDelimiter = "\n";

    public CargoTestRunnerClient(ITestRunSession session) {
        this.session = session;
    }

    private IProcess connectProcess(ILaunch launch) {
        if (this.process != null) {
            return this.process;
        }
        this.process = launch.getProcesses()[0];
        if (this.process != null && this.inputStream == null) {
            this.inputStream = CargoTestRunnerClient.toInputStream(this.process, false);
            Job.createSystem((String)"Monitor test process", monitor -> this.run(this.inputStream)).schedule(100L);
        }
        return this.process;
    }

    private static InputStream toInputStream(final IProcess process, boolean errorStream) {
        IStreamMonitor monitor;
        IStreamMonitor iStreamMonitor = monitor = errorStream ? process.getStreamsProxy().getErrorStreamMonitor() : process.getStreamsProxy().getOutputStreamMonitor();
        if (monitor == null) {
            return null;
        }
        final List<Integer> content = Collections.synchronizedList(new LinkedList());
        monitor.addListener((text, progresMonitor) -> text.chars().forEach(content::add));
        byte[] initialContent = monitor.getContents().getBytes();
        int i = initialContent.length - 1;
        while (i >= 0) {
            content.add(0, Integer.valueOf(initialContent[i]));
            --i;
        }
        return new InputStream(){

            @Override
            public int read() throws IOException {
                while (!process.isTerminated() || !content.isEmpty()) {
                    if (!content.isEmpty()) {
                        return (Integer)content.remove(0);
                    }
                    try {
                        Thread.sleep(20L, 0);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (process.isTerminated() && this.available() == 0) {
                    return -1;
                }
                if (len == 0) {
                    return 0;
                }
                int i = 0;
                do {
                    b[off + i] = (byte)this.read();
                } while (this.available() > 0 && ++i < len && off + i < b.length);
                return i;
            }

            @Override
            public int available() throws IOException {
                return content.size();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(InputStream iStream) {
        if (iStream == null) {
            return;
        }
        this.session.notifyTestSessionStarted(null);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStreamReader isReader = new InputStreamReader(iStream, StandardCharsets.UTF_8);
                try {
                    block22: {
                        BufferedReader reader = new BufferedReader(isReader);
                        try {
                            try (PushbackReader inputReader = new PushbackReader(reader);){
                                String message;
                                do {
                                    if ((message = this.readMessage(inputReader)) == null) continue;
                                    this.fCurrentState = (ProcessingState)this.fCurrentState.apply(message);
                                } while (message != null);
                                this.session.notifyTestSessionCompleted(this.session.getDuration());
                            }
                            if (reader == null) break block22;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (reader == null) throw throwable;
                            reader.close();
                            throw throwable;
                        }
                        reader.close();
                    }
                    if (isReader == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (isReader == null) throw throwable;
                    isReader.close();
                    throw throwable;
                }
                isReader.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            CorrosionPlugin.logError(e);
            this.session.notifyTestSessionAborted(null, (Exception)e);
        }
    }

    private String readMessage(PushbackReader in) throws IOException {
        int ch;
        if (in == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(128);
        while ((ch = in.read()) != -1) {
            switch (ch) {
                case 10: {
                    this.fLastLineDelimiter = "\n";
                    return buf.toString();
                }
                case 13: {
                    ch = in.read();
                    if (ch == 10) {
                        this.fLastLineDelimiter = "\r\n";
                    } else {
                        in.unread(ch);
                        this.fLastLineDelimiter = "\r";
                    }
                    return buf.toString();
                }
            }
            buf.append((char)ch);
        }
        this.fLastLineDelimiter = null;
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public void stopTest() {
        this.stopMonitoring();
    }

    public void startMonitoring() {
        this.process = this.connectProcess(this.session.getLaunch());
    }

    public void stopMonitoring() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException e) {
            CorrosionPlugin.logError(e);
        }
    }

    class DefaultProcessingState
    implements ProcessingState {
        DefaultProcessingState() {
        }

        @Override
        public ProcessingState apply(String message) {
            if (message.startsWith(CargoTestRunnerClient.TEST_PERFORMED_LINE_BEGIN) && message.contains(CargoTestRunnerClient.TEST_PERFORMED_LINE_END)) {
                String testName = message.substring(CargoTestRunnerClient.TEST_PERFORMED_LINE_BEGIN.length(), message.indexOf(CargoTestRunnerClient.TEST_PERFORMED_LINE_END)).trim();
                String testDisplayName = testName.contains(CargoTestRunnerClient.TEST_NAME_SEPARATOR) ? testName.substring(testName.lastIndexOf(CargoTestRunnerClient.TEST_NAME_SEPARATOR) + CargoTestRunnerClient.TEST_NAME_SEPARATOR.length()).trim() : testName;
                String testSuiteName = testName.contains(CargoTestRunnerClient.TEST_NAME_SEPARATOR) ? testName.substring(0, testName.lastIndexOf(CargoTestRunnerClient.TEST_NAME_SEPARATOR)).trim() : null;
                ITestSuiteElement suite = this.getOrCreateTestSuite(testSuiteName);
                ITestCaseElement testElement = CargoTestRunnerClient.this.session.newTestCase(testName, testName, suite, testDisplayName, message);
                CargoTestRunnerClient.this.session.notifyTestStarted((ITestElement)testElement);
                if (message.endsWith(CargoTestRunnerClient.STATUS_FAILED)) {
                    CargoTestRunnerClient.this.session.notifyTestFailed((ITestElement)testElement, ITestElement.Result.FAILURE, false, null);
                }
                CargoTestRunnerClient.this.session.notifyTestEnded((ITestElement)testElement, false);
                return this;
            }
            if (message.startsWith(CargoTestRunnerClient.TEST_FAILURES_LINE)) {
                return CargoTestRunnerClient.this.fTraceState;
            }
            return this;
        }

        private ITestSuiteElement getOrCreateTestSuite(String testSuiteName) {
            String[] segments;
            if (testSuiteName == null) {
                return CargoTestRunnerClient.this.session;
            }
            ITestRunSession parent = CargoTestRunnerClient.this.session;
            String[] stringArray = segments = testSuiteName.split(CargoTestRunnerClient.TEST_NAME_SEPARATOR);
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                String currentSuiteName = parent instanceof ITestRunSession ? segment : String.valueOf(parent.getTestName()) + CargoTestRunnerClient.TEST_NAME_SEPARATOR + segment;
                ITestSuiteElement currentSuite = (ITestSuiteElement)CargoTestRunnerClient.this.session.getTestElement(currentSuiteName);
                if (currentSuite == null) {
                    currentSuite = CargoTestRunnerClient.this.session.newTestSuite(currentSuiteName, currentSuiteName, null, (ITestSuiteElement)parent, segment, null);
                }
                parent = currentSuite;
                ++n2;
            }
            return parent;
        }
    }

    private static interface ProcessingState
    extends Function<String, ProcessingState> {
    }

    class TraceProcessingState
    implements ProcessingState {
        private static final String FAILURE_THREAD = "thread";
        private static final String FAILURE_PANICKED_AT_BEGIN = "panicked at";
        private static final String FAILURE_PANICKED_AT_END = "',";
        private static final String FAILURE_ASSERTION_BEGIN = "'assertion failed:";
        private static final String FAILURE_ASSERTION_LEFT = "left: ";
        private static final String FAILURE_ASSERTION_RIGHT = "right:";
        private static final String FAILURE_ASSERTION_SEPARATOR = ",";
        boolean isCollectingAFailureTrace = false;

        TraceProcessingState() {
        }

        private void reset() {
            CargoTestRunnerClient.this.fFailedTestCaseName = null;
            CargoTestRunnerClient.this.fFailedTestStdout.setLength(0);
            this.isCollectingAFailureTrace = false;
        }

        private void submit() {
            ITestElement testElement;
            if (CargoTestRunnerClient.this.fFailedTestCaseName != null && CargoTestRunnerClient.this.fFailedTestStdout.length() > 0 && (testElement = CargoTestRunnerClient.this.session.getTestElement(CargoTestRunnerClient.this.fFailedTestCaseName)) != null) {
                ITestElement.FailureTrace failureTrace = this.fillFailureTrace(CargoTestRunnerClient.this.fFailedTestStdout.toString());
                CargoTestRunnerClient.this.session.notifyTestFailed(testElement, ITestElement.Result.FAILURE, false, failureTrace);
            }
        }

        private ITestElement.FailureTrace fillFailureTrace(String trace) {
            if (trace.contains(FAILURE_THREAD) && trace.contains(FAILURE_PANICKED_AT_BEGIN) && trace.contains(FAILURE_PANICKED_AT_END)) {
                int panickedAtEmd = trace.lastIndexOf(FAILURE_PANICKED_AT_END);
                String panickedAtText = trace.substring(0, panickedAtEmd);
                String source = trace.substring(panickedAtEmd + FAILURE_PANICKED_AT_END.length()).strip();
                StringBuilder failureTrace = new StringBuilder();
                failureTrace.append(panickedAtText);
                failureTrace.append('\n').append(" at ").append(source);
                if (panickedAtText.contains(FAILURE_ASSERTION_BEGIN)) {
                    int leftIndex = trace.indexOf(FAILURE_ASSERTION_LEFT);
                    int rightIndex = trace.indexOf(FAILURE_ASSERTION_RIGHT, leftIndex);
                    if (leftIndex != -1 && rightIndex != -1) {
                        String leftValue = panickedAtText.substring(leftIndex + FAILURE_ASSERTION_LEFT.length(), panickedAtText.lastIndexOf(FAILURE_ASSERTION_SEPARATOR, rightIndex)).strip();
                        String rightValue = panickedAtText.substring(rightIndex + FAILURE_ASSERTION_RIGHT.length()).strip();
                        return new ITestElement.FailureTrace(failureTrace.toString(), leftValue, rightValue);
                    }
                }
                return new ITestElement.FailureTrace(failureTrace.toString(), null, null);
            }
            return new ITestElement.FailureTrace(trace, null, null);
        }

        @Override
        public ProcessingState apply(String message) {
            if (message.startsWith(CargoTestRunnerClient.TEST_STDOUT_LINE_BEGIN) && message.endsWith(CargoTestRunnerClient.TEST_STDOUT_LINE_END)) {
                this.submit();
                this.reset();
                CargoTestRunnerClient.this.fFailedTestCaseName = message.substring(CargoTestRunnerClient.TEST_STDOUT_LINE_BEGIN.length(), message.indexOf(CargoTestRunnerClient.TEST_STDOUT_LINE_END)).trim();
                this.isCollectingAFailureTrace = true;
                return this;
            }
            if (message.startsWith(CargoTestRunnerClient.TEST_NOTE_LINE) || message.startsWith(CargoTestRunnerClient.TEST_FAILURES_LINE)) {
                this.submit();
                this.reset();
                return this;
            }
            if (this.isCollectingAFailureTrace) {
                CargoTestRunnerClient.this.fFailedTestStdout.append(message);
                if (CargoTestRunnerClient.this.fLastLineDelimiter != null) {
                    CargoTestRunnerClient.this.fFailedTestStdout.append(CargoTestRunnerClient.this.fLastLineDelimiter);
                }
            }
            return this;
        }
    }
}

