/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.sourcelookup;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.sourcelookup.CargoProjectSourceContainer;
import org.eclipse.corrosion.sourcelookup.CargoSourceLookupMessages;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CargoProjectSourceContainerType
extends AbstractSourceContainerTypeDelegate {
    public String getMemento(ISourceContainer container) throws CoreException {
        CargoProjectSourceContainer sourceContainer = (CargoProjectSourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement("project");
        IProject project = sourceContainer.getProject();
        if (project != null) {
            element.setAttribute("name", project.getName());
        }
        element.setAttribute("referencedProjects", String.valueOf(sourceContainer.isSearchReferencedProjects()));
        document.appendChild(element);
        return this.serializeDocument(document);
    }

    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if ("project".equals(element.getNodeName())) {
                String string = element.getAttribute("name");
                IProject project = null;
                if (string != null && !string.isEmpty()) {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
                }
                String nest = element.getAttribute("referencedProjects");
                boolean ref = Boolean.parseBoolean(nest);
                return new CargoProjectSourceContainer(project, ref);
            }
            this.abort(CargoSourceLookupMessages.CargoProjectSourceContainerType_1, null);
        }
        this.abort(CargoSourceLookupMessages.CargoProjectSourceContainerType_2, null);
        return null;
    }
}

