/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.errors.CancelledException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilterMarker;
import org.eclipse.jgit.util.LfsFactory;

public class FileDiff
implements GitInfo {
    public static final Comparator<FileDiff> PATH_COMPARATOR = (left, right) -> {
        String leftPath = left.getPath();
        String rightPath = right.getPath();
        int i = leftPath.lastIndexOf(47);
        int j = rightPath.lastIndexOf(47);
        int p = leftPath.substring(0, i + 1).replace('/', '\u0001').compareTo(rightPath.substring(0, j + 1).replace('/', '\u0001'));
        if (p != 0) {
            return p;
        }
        return leftPath.substring(i + 1).compareToIgnoreCase(rightPath.substring(j + 1));
    };
    private final RevCommit commit;
    private final RevCommit base;
    private final DiffEntry diffEntry;
    private final Repository repository;

    static ObjectId[] trees(RevCommit commit, RevCommit[] parents) {
        ObjectId[] r = new ObjectId[parents.length + 1];
        int i = 0;
        while (i < r.length - 1) {
            r[i] = parents[i].getTree().getId();
            ++i;
        }
        r[r.length - 1] = commit.getTree().getId();
        return r;
    }

    public static FileDiff[] compute(Repository repository, TreeWalk walk, RevCommit commit, @Nullable IProgressMonitor monitor, TreeFilter ... markTreeFilters) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return FileDiff.compute(repository, walk, commit, commit.getParents(), monitor, markTreeFilters);
    }

    public static FileDiff[] compute(Repository repository, TreeWalk walk, RevCommit commit, RevCommit[] parents, @Nullable IProgressMonitor monitor, TreeFilter ... markTreeFilters) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        ArrayList<FileDiff> r = new ArrayList<FileDiff>();
        if (parents.length > 0) {
            walk.reset((AnyObjectId[])FileDiff.trees(commit, parents));
        } else {
            walk.reset();
            walk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            walk.addTree((AnyObjectId)commit.getTree());
        }
        if (walk.getTreeCount() <= 2) {
            FileDiff d;
            RevCommit base = parents.length == 1 ? parents[0] : null;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            List entries = DiffEntry.scan((TreeWalk)walk, (boolean)false, (TreeFilter[])markTreeFilters);
            if (progress.isCanceled()) {
                return new FileDiff[0];
            }
            progress.worked(1);
            LinkedList xentries = new LinkedList(entries);
            RenameDetector detector = new RenameDetector(repository);
            detector.addAll((Collection)entries);
            boolean cancelled = false;
            List renames = Collections.emptyList();
            try {
                renames = detector.compute(walk.getObjectReader(), (ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(1)));
            }
            catch (CancelledException e) {
                cancelled = true;
            }
            if (!cancelled) {
                progress.setWorkRemaining(renames.size());
                for (DiffEntry m : renames) {
                    d = new FileDiff(repository, commit, base, m);
                    r.add(d);
                    Iterator i = xentries.iterator();
                    while (i.hasNext()) {
                        DiffEntry n = (DiffEntry)i.next();
                        if (m.getOldPath().equals(n.getOldPath())) {
                            i.remove();
                            continue;
                        }
                        if (!m.getNewPath().equals(n.getNewPath())) continue;
                        i.remove();
                    }
                    progress.worked(1);
                }
            }
            for (DiffEntry m : xentries) {
                d = new FileDiff(repository, commit, base, m);
                r.add(d);
            }
        } else {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            int nTree = walk.getTreeCount();
            int myTree = nTree - 1;
            TreeFilterMarker treeFilterMarker = new TreeFilterMarker(markTreeFilters);
            while (walk.next()) {
                if (!progress.isCanceled()) {
                    progress.setWorkRemaining(100).worked(1);
                    if (FileDiff.matchAnyParent(walk, myTree)) continue;
                    int treeFilterMarks = treeFilterMarker.getMarks(walk);
                    FileDiffForMerges d = new FileDiffForMerges(repository, commit, treeFilterMarks);
                    d.path = walk.getPathString();
                    int m0 = 0;
                    int i = 0;
                    while (i < myTree) {
                        m0 |= walk.getRawMode(i);
                        ++i;
                    }
                    int m1 = walk.getRawMode(myTree);
                    d.change = DiffEntry.ChangeType.MODIFY;
                    if (m0 == 0 && m1 != 0) {
                        d.change = DiffEntry.ChangeType.ADD;
                    } else if (m0 != 0 && m1 == 0) {
                        d.change = DiffEntry.ChangeType.DELETE;
                    } else if (m0 != m1 && walk.idEqual(0, myTree)) {
                        d.change = DiffEntry.ChangeType.MODIFY;
                    }
                    d.blobs = new ObjectId[nTree];
                    d.modes = new FileMode[nTree];
                    int i2 = 0;
                    while (i2 < nTree) {
                        ((FileDiffForMerges)d).blobs[i2] = walk.getObjectId(i2);
                        ((FileDiffForMerges)d).modes[i2] = walk.getFileMode(i2);
                        ++i2;
                    }
                    r.add(d);
                    continue;
                }
                break;
            }
        }
        FileDiff[] tmp = new FileDiff[r.size()];
        r.toArray(tmp);
        return tmp;
    }

    private static boolean matchAnyParent(TreeWalk walk, int myTree) {
        int m = walk.getRawMode(myTree);
        int i = 0;
        while (i < myTree) {
            if (walk.getRawMode(i) == m && walk.idEqual(i, myTree)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void outputDiff(StringBuilder d, Repository db, DiffFormatter diffFmt, boolean gitFormat) throws IOException {
        if (gitFormat) {
            diffFmt.setRepository(db);
            diffFmt.format(this.diffEntry);
            return;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (ObjectReader reader = db.newObjectReader();){
            this.outputEclipseDiff(d, db, reader, diffFmt);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void outputEclipseDiff(StringBuilder d, Repository db, ObjectReader reader, DiffFormatter diffFmt) throws IOException {
        if (this.getBlobs().length != 2) {
            throw new UnsupportedOperationException("Not supported yet if the number of parents is different from one");
        }
        String projectRelativeNewPath = this.getProjectRelativePath(db, this.getNewPath());
        String projectRelativeOldPath = this.getProjectRelativePath(db, this.getOldPath());
        d.append("diff --git ").append(projectRelativeOldPath).append(" ").append(projectRelativeNewPath).append("\n");
        ObjectId id1 = this.getBlobs()[0];
        ObjectId id2 = this.getBlobs()[1];
        FileMode mode1 = this.getModes()[0];
        FileMode mode2 = this.getModes()[1];
        if (id1.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("new file mode " + mode2).append("\n");
        } else if (id2.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("deleted file mode " + mode1).append("\n");
        } else if (!mode1.equals(mode2)) {
            d.append("old mode " + mode1);
            d.append("new mode " + mode2).append("\n");
        }
        d.append("index ").append(reader.abbreviate((AnyObjectId)id1).name()).append("..").append(reader.abbreviate((AnyObjectId)id2).name()).append(mode1.equals(mode2) ? " " + mode1 : "").append("\n");
        if (id1.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("--- /dev/null\n");
        } else {
            d.append("--- ");
            d.append(this.getProjectRelativePath(db, this.getOldPath()));
            d.append("\n");
        }
        if (id2.equals((AnyObjectId)ObjectId.zeroId())) {
            d.append("+++ /dev/null\n");
        } else {
            d.append("+++ ");
            d.append(this.getProjectRelativePath(db, this.getNewPath()));
            d.append("\n");
        }
        RawText a = this.getRawText(id1, reader);
        RawText b = this.getRawText(id2, reader);
        EditList editList = MyersDiff.INSTANCE.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)a, (Sequence)b);
        diffFmt.format(editList, a, b);
    }

    private String getProjectRelativePath(Repository db, String repoPath) {
        IFile resource = ResourceUtil.getFileForLocation((Repository)db, (String)repoPath, (boolean)false);
        if (resource == null) {
            return null;
        }
        return resource.getProjectRelativePath().toString();
    }

    private RawText getRawText(ObjectId id, ObjectReader reader) throws IOException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader ldr = LfsFactory.getInstance().applySmudgeFilter(this.repository, reader.open((AnyObjectId)id, 3), LfsFactory.getAttributesForPath((Repository)this.repository, (String)this.getPath()).get("diff"));
        return new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public RevCommit getBase() {
        return this.base;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getPath() {
        if (DiffEntry.ChangeType.DELETE.equals((Object)this.diffEntry.getChangeType())) {
            return this.diffEntry.getOldPath();
        }
        return this.diffEntry.getNewPath();
    }

    public String getOldPath() {
        return this.diffEntry.getOldPath();
    }

    public String getNewPath() {
        return this.diffEntry.getNewPath();
    }

    public DiffEntry.ChangeType getChange() {
        return this.diffEntry.getChangeType();
    }

    public ObjectId[] getBlobs() {
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        if (this.diffEntry.getOldId() != null) {
            objectIds.add(this.diffEntry.getOldId().toObjectId());
        }
        if (this.diffEntry.getNewId() != null) {
            objectIds.add(this.diffEntry.getNewId().toObjectId());
        }
        return objectIds.toArray(new ObjectId[0]);
    }

    public FileMode[] getModes() {
        ArrayList<FileMode> modes = new ArrayList<FileMode>();
        if (this.diffEntry.getOldMode() != null) {
            modes.add(this.diffEntry.getOldMode());
        }
        if (this.diffEntry.getOldMode() != null) {
            modes.add(this.diffEntry.getOldMode());
        }
        return modes.toArray(new FileMode[0]);
    }

    public boolean isMarked(int index) {
        return this.diffEntry != null && this.diffEntry.isMarked(index);
    }

    public FileDiff(Repository repo, RevCommit c, DiffEntry entry) {
        this(repo, c, null, entry);
    }

    public FileDiff(Repository repo, RevCommit tip, RevCommit base, DiffEntry entry) {
        this.repository = repo;
        this.diffEntry = entry;
        this.commit = tip;
        this.base = base;
    }

    public boolean isSubmodule() {
        if (this.diffEntry == null) {
            return false;
        }
        return this.diffEntry.getOldMode() == FileMode.GITLINK || this.diffEntry.getNewMode() == FileMode.GITLINK;
    }

    public ImageDescriptor getBaseImageDescriptor() {
        if (!this.isSubmodule()) {
            return UIUtils.getEditorImage(this.getPath());
        }
        return UIIcons.REPOSITORY;
    }

    public ImageDescriptor getImageDcoration() {
        switch (this.getChange()) {
            case ADD: {
                return UIIcons.OVR_STAGED_ADD;
            }
            case DELETE: {
                return UIIcons.OVR_STAGED_REMOVE;
            }
            case RENAME: {
                return UIIcons.OVR_STAGED_RENAME;
            }
        }
        return null;
    }

    public String getGitPath() {
        return this.getPath();
    }

    public GitInfo.Source getSource() {
        return GitInfo.Source.COMMIT;
    }

    public AnyObjectId getCommitId() {
        if (DiffEntry.ChangeType.DELETE.equals((Object)this.diffEntry.getChangeType()) && this.base != null) {
            return this.base.getId();
        }
        return this.commit.getId();
    }

    private static class FileDiffForMerges
    extends FileDiff {
        private String path;
        private DiffEntry.ChangeType change;
        private ObjectId[] blobs;
        private FileMode[] modes;
        private final int treeFilterMarks;

        private FileDiffForMerges(Repository repo, RevCommit c, int treeFilterMarks) {
            super(repo, c, null);
            this.treeFilterMarks = treeFilterMarks;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getNewPath() {
            return this.path;
        }

        @Override
        public DiffEntry.ChangeType getChange() {
            return this.change;
        }

        @Override
        public ObjectId[] getBlobs() {
            return this.blobs;
        }

        @Override
        public FileMode[] getModes() {
            return this.modes;
        }

        @Override
        public boolean isMarked(int index) {
            return ((long)this.treeFilterMarks & 1L << index) != 0L;
        }
    }
}

