/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class LSPImages {
    private static ImageRegistry imageRegistry;
    private static final Map<java.awt.Color, Image> colorToImageCache;
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private static final String OBJECT = "$nl$/icons/full/obj16/";
    private static final Image EMPTY_IMAGE;
    public static final String IMG_MODULE = "IMG_MODULE";
    public static final String IMG_NAMESPACE = "IMG_NAMESPACE";
    public static final String IMG_PACKAGE = "IMG_PACKAGE";
    public static final String IMG_CLASS = "IMG_CLASS";
    public static final String IMG_METHOD = "IMG_METOHD";
    public static final String IMG_PROPERTY = "IMG_PROPERTY";
    public static final String IMG_FIELD = "IMG_FIELD";
    public static final String IMG_CONSTRUCTOR = "IMG_CONSTRUCTOR";
    public static final String IMG_ENUM = "IMG_ENUM";
    public static final String IMG_INTERACE = "IMG_INTERFACE";
    public static final String IMG_FUNCTION = "IMG_FUNCTION";
    public static final String IMG_VARIABLE = "IMG_VARIABLE";
    public static final String IMG_CONSTANT = "IMG_CONSTANT";
    public static final String IMG_TEXT = "IMG_TEXT";
    public static final String IMG_STRING = "IMG_TEXT";
    public static final String IMG_NUMBER = "IMG_NUMBER";
    public static final String IMG_BOOLEAN = "IMG_BOOLEAN";
    public static final String IMG_ARRAY = "IMG_ARRAY";
    public static final String IMG_UNIT = "IMG_UNIT";
    public static final String IMG_VALUE = "IMG_VALUE";
    public static final String IMG_KEYWORD = "IMG_KEYWORD";
    public static final String IMG_SNIPPET = "IMG_SNIPPET";
    public static final String IMG_COLOR = "IMG_COLOR";
    public static final String IMG_REFERENCE = "IMG_REFERENCE";

    static {
        colorToImageCache = new HashMap<java.awt.Color, Image>();
        EMPTY_IMAGE = new Image((Device)PlatformUI.getWorkbench().getDisplay(), 16, 16);
    }

    private LSPImages() {
    }

    public static void initalize(ImageRegistry registry) {
        imageRegistry = registry;
        LSPImages.declareRegistryImage(IMG_MODULE, "$nl$/icons/full/obj16/module.png");
        LSPImages.declareRegistryImage(IMG_NAMESPACE, "$nl$/icons/full/obj16/namespace.png");
        LSPImages.declareRegistryImage(IMG_PACKAGE, "$nl$/icons/full/obj16/package.png");
        LSPImages.declareRegistryImage(IMG_CLASS, "$nl$/icons/full/obj16/class.png");
        LSPImages.declareRegistryImage(IMG_METHOD, "$nl$/icons/full/obj16/method.png");
        LSPImages.declareRegistryImage(IMG_PROPERTY, "$nl$/icons/full/obj16/property.png");
        LSPImages.declareRegistryImage(IMG_FIELD, "$nl$/icons/full/obj16/field.png");
        LSPImages.declareRegistryImage(IMG_CONSTRUCTOR, "$nl$/icons/full/obj16/constructor.png");
        LSPImages.declareRegistryImage(IMG_ENUM, "$nl$/icons/full/obj16/enum.png");
        LSPImages.declareRegistryImage(IMG_INTERACE, "$nl$/icons/full/obj16/interface.png");
        LSPImages.declareRegistryImage(IMG_FUNCTION, "$nl$/icons/full/obj16/function.png");
        LSPImages.declareRegistryImage(IMG_VARIABLE, "$nl$/icons/full/obj16/variable.png");
        LSPImages.declareRegistryImage(IMG_CONSTANT, "$nl$/icons/full/obj16/constant.png");
        LSPImages.declareRegistryImage("IMG_TEXT", "$nl$/icons/full/obj16/string.png");
        LSPImages.declareRegistryImage(IMG_NUMBER, "$nl$/icons/full/obj16/number.png");
        LSPImages.declareRegistryImage(IMG_BOOLEAN, "$nl$/icons/full/obj16/boolean.png");
        LSPImages.declareRegistryImage(IMG_ARRAY, "$nl$/icons/full/obj16/array.png");
        LSPImages.declareRegistryImage("IMG_TEXT", "$nl$/icons/full/obj16/text.png");
        LSPImages.declareRegistryImage(IMG_UNIT, "$nl$/icons/full/obj16/unit.png");
        LSPImages.declareRegistryImage(IMG_VALUE, "$nl$/icons/full/obj16/value.png");
        LSPImages.declareRegistryImage(IMG_KEYWORD, "$nl$/icons/full/obj16/keyword.png");
        LSPImages.declareRegistryImage(IMG_SNIPPET, "$nl$/icons/full/obj16/snippet.png");
        LSPImages.declareRegistryImage(IMG_COLOR, "$nl$/icons/full/obj16/color.png");
        LSPImages.declareRegistryImage(IMG_REFERENCE, "$nl$/icons/full/obj16/reference.png");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.lsp4e");
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        imageRegistry.put(key, desc);
    }

    public static Image getImage(String key) {
        return LSPImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return LSPImages.getImageRegistry().getDescriptor(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = LanguageServerPlugin.getDefault().getImageRegistry();
        }
        return imageRegistry;
    }

    public static Image imageFromSymbolKind(SymbolKind kind) {
        if (kind == null) {
            return EMPTY_IMAGE;
        }
        switch (kind) {
            case Array: {
                return LSPImages.getImage(IMG_ARRAY);
            }
            case Boolean: {
                return LSPImages.getImage(IMG_BOOLEAN);
            }
            case Class: {
                return LSPImages.getImage(IMG_CLASS);
            }
            case Constant: {
                return LSPImages.getImage(IMG_CONSTANT);
            }
            case Constructor: {
                return LSPImages.getImage(IMG_CONSTRUCTOR);
            }
            case Enum: {
                return LSPImages.getImage(IMG_ENUM);
            }
            case Field: {
                return LSPImages.getImage(IMG_FIELD);
            }
            case File: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            case Function: {
                return LSPImages.getImage(IMG_FUNCTION);
            }
            case Interface: {
                return LSPImages.getImage(IMG_INTERACE);
            }
            case Method: {
                return LSPImages.getImage(IMG_METHOD);
            }
            case Module: {
                return LSPImages.getImage(IMG_MODULE);
            }
            case Namespace: {
                return LSPImages.getImage(IMG_NAMESPACE);
            }
            case Number: {
                return LSPImages.getImage(IMG_NUMBER);
            }
            case Package: {
                return LSPImages.getImage(IMG_PACKAGE);
            }
            case Property: {
                return LSPImages.getImage(IMG_PROPERTY);
            }
            case String: {
                return LSPImages.getImage("IMG_TEXT");
            }
            case Variable: {
                return LSPImages.getImage(IMG_VARIABLE);
            }
        }
        return EMPTY_IMAGE;
    }

    public static Image imageFromCompletionItem(CompletionItem completionItem) {
        CompletionItemKind kind = completionItem.getKind();
        switch (kind) {
            case Text: {
                return LSPImages.getImage("IMG_TEXT");
            }
            case Method: {
                return LSPImages.getImage(IMG_METHOD);
            }
            case Function: {
                return LSPImages.getImage(IMG_FUNCTION);
            }
            case Constructor: {
                return LSPImages.getImage(IMG_CONSTRUCTOR);
            }
            case Field: {
                return LSPImages.getImage(IMG_FIELD);
            }
            case Variable: {
                return LSPImages.getImage(IMG_VARIABLE);
            }
            case Class: {
                return LSPImages.getImage(IMG_CLASS);
            }
            case Interface: {
                return LSPImages.getImage(IMG_INTERACE);
            }
            case Module: {
                return LSPImages.getImage(IMG_MODULE);
            }
            case Property: {
                return LSPImages.getImage(IMG_PROPERTY);
            }
            case Unit: {
                return LSPImages.getImage(IMG_UNIT);
            }
            case Value: {
                return LSPImages.getImage(IMG_VALUE);
            }
            case Enum: {
                return LSPImages.getImage(IMG_ENUM);
            }
            case Keyword: {
                return LSPImages.getImage(IMG_KEYWORD);
            }
            case Snippet: {
                return LSPImages.getImage(IMG_SNIPPET);
            }
            case Color: {
                return LSPImages.getImageForColor(completionItem);
            }
            case File: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            case Folder: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            case Reference: {
                return LSPImages.getImage(IMG_REFERENCE);
            }
        }
        return null;
    }

    private static Image getImageForColor(CompletionItem completionItem) {
        String hexValue = null;
        String docString = LSPEclipseUtils.getDocString((Either<String, MarkupContent>)completionItem.getDocumentation());
        if (docString != null && docString.startsWith("#")) {
            hexValue = docString;
        } else if (completionItem.getLabel().startsWith("#")) {
            hexValue = completionItem.getLabel();
        }
        if (hexValue == null) {
            return null;
        }
        java.awt.Color decodedColor = null;
        try {
            decodedColor = java.awt.Color.decode(hexValue);
        }
        catch (NumberFormatException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        return colorToImageCache.computeIfAbsent(decodedColor, key -> {
            Image image = new Image((Device)Display.getDefault(), 16, 16);
            GC gc = new GC((Drawable)image);
            Color color = new Color((Device)Display.getDefault(), key.getRed(), key.getGreen(), key.getBlue(), key.getAlpha());
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 16, 16);
            color.dispose();
            gc.dispose();
            return image;
        });
    }
}

