/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.resources;

import java.io.File;
import java.io.IOException;

public abstract class PathCanonicalizationStrategy {
    private static volatile PathCanonicalizationStrategy instance;

    static {
        PathCanonicalizationStrategy.setPathCanonicalization(true);
    }

    public static String getCanonicalPath(File file) {
        return instance.getCanonicalPathInternal(file);
    }

    public static boolean resolvesSymbolicLinks() {
        return instance.resolvesSymbolicLinksInternal();
    }

    public static void setPathCanonicalization(boolean canonicalize) {
        instance = canonicalize ? new PathCanonicalizationStrategy(){

            @Override
            protected String getCanonicalPathInternal(File file) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException e) {
                    return file.getAbsolutePath();
                }
            }

            @Override
            protected boolean resolvesSymbolicLinksInternal() {
                return true;
            }
        } : new PathCanonicalizationStrategy(){

            @Override
            protected String getCanonicalPathInternal(File file) {
                return file.getAbsolutePath();
            }

            @Override
            protected boolean resolvesSymbolicLinksInternal() {
                return false;
            }
        };
    }

    protected abstract String getCanonicalPathInternal(File var1);

    protected abstract boolean resolvesSymbolicLinksInternal();
}

