/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.sourcelookup;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.sourcelookup.CargoSourceLookupMessages;
import org.eclipse.corrosion.sourcelookup.CargoSourceUtils;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class CargoAbsolutePathSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = "org.eclipse.corrosion.containerType.absolutePath";

    public boolean isValidAbsoluteFilePath(String name) {
        return this.isValidAbsoluteFilePath(new File(name));
    }

    public boolean isValidAbsoluteFilePath(File file) {
        return file.isAbsolute() && file.exists() && file.isFile();
    }

    public Object[] findSourceElements(String name) throws CoreException {
        File file;
        if (name != null && this.isValidAbsoluteFilePath(file = new File(name))) {
            return CargoSourceUtils.findSourceElements(file, this.getDirector());
        }
        return new Object[0];
    }

    public String getName() {
        return CargoSourceLookupMessages.AbsolutePathSourceContainer_0;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public int hashCode() {
        return TYPE_ID.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CargoAbsolutePathSourceContainer;
    }
}

