/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.html;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.InitializeLaunchConfigurations;

public class HTMLLanguageServer
extends ProcessStreamConnectionProvider {
    public HTMLLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(InitializeLaunchConfigurations.getNodeJsLocation());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/language-servers/node_modules/vscode-html-languageserver/dist/htmlServerMain.js"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public Object getInitializationOptions(URI rootUri) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("css", true);
        map.put("javascript", true);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("embeddedLanguages", map);
        options.put("format.enable", Boolean.valueOf(true));
        return options;
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getResult() instanceof InitializeResult) {
            HashMap<String, Map<Object, Object>> htmlOptions = new HashMap<String, Map<Object, Object>>();
            HashMap<String, Boolean> validateOptions = new HashMap<String, Boolean>();
            validateOptions.put("scripts", true);
            validateOptions.put("styles", true);
            htmlOptions.put("validate", validateOptions);
            htmlOptions.put("format", Collections.singletonMap("enable", Boolean.TRUE));
            HashMap<String, HashMap<String, Map<Object, Object>>> html = new HashMap<String, HashMap<String, Map<Object, Object>>>();
            html.put("html", htmlOptions);
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(html);
            languageServer.getWorkspaceService().didChangeConfiguration(params);
        }
    }

    public String toString() {
        return "HTML Language Server: " + super.toString();
    }
}

