/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.commonui;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils.SQLObjectComparator;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SchemaObjectsViewerContentProvider
implements IStructuredContentProvider {
    protected int _objsType;
    public static final int INDEXES_TYPE = 0;
    public static final int TRIGGERS_TYPE = 1;

    public SchemaObjectsViewerContentProvider(int type) {
        this._objsType = type;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return new Object[0];
        }
        if (inputElement instanceof Table) {
            Table table = (Table)inputElement;
            switch (this._objsType) {
                case 0: {
                    if (table.getIndex() == null) break;
                    return this.getSortedIndexes(table);
                }
                case 1: {
                    if (table.getTriggers() == null) break;
                    return this.getSortedTriggers(table);
                }
            }
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected Object[] getSortedIndexes(Table table) {
        ArrayList indexes = new ArrayList();
        indexes.addAll(table.getIndex());
        Collections.sort(indexes, new SQLObjectComparator());
        return indexes.toArray(new Index[indexes.size()]);
    }

    protected Object[] getSortedTriggers(Table table) {
        ArrayList triggers = new ArrayList();
        triggers.addAll(table.getTriggers());
        Collections.sort(triggers, new SQLObjectComparator());
        return triggers.toArray(new Trigger[triggers.size()]);
    }
}

