/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.profile.ProfileFileExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ProfilePathSelectionDialog
extends ElementTreeSelectionDialog {
    static final String PLUGIN_ID = "org.eclipse.datatools.connectivity.oda.design.ui";
    static final String TITLE = Messages.profilePage_pageTitle;
    static final String TITLE_CREATE = Messages.profileStoreCreationDialog_title;
    static final String FILTER_ALLOW_ALL = ".*";
    private static final String EXT_SEPERATOR = ".";
    private static final String EMPTY_STRING = "";
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private File topDir;
    private boolean isProfileStoreCreation = false;
    private Text txtFilter;
    private Text txtFile;
    private String txtFileContent = null;
    private String storedPath = null;
    private String defaultExtension;
    private TreeViewerFilter treeViewerFilter = new TreeViewerFilter();

    public ProfilePathSelectionDialog(Shell parent, File topDir, boolean isProfileCreation, String storedPath, String defaultExtension) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ContentProvider(isProfileCreation));
        assert (topDir != null);
        this.setValidator(new SelectionValidator());
        this.setInput(topDir.getAbsolutePath());
        this.topDir = topDir;
        this.isProfileStoreCreation = isProfileCreation;
        if (isProfileCreation) {
            this.setTitle(TITLE_CREATE);
        } else {
            this.setTitle(TITLE);
        }
        this.storedPath = storedPath;
        this.defaultExtension = defaultExtension;
    }

    protected Control createDialogArea(Composite parent) {
        this.createFilterControl(parent);
        if (ProfileFileExtension.exists((String)this.defaultExtension)) {
            this.txtFilter.setText(EXT_SEPERATOR + this.defaultExtension);
        }
        this.txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ProfilePathSelectionDialog.this.getTreeViewer().refresh();
            }
        });
        Control c = super.createDialogArea(parent);
        if (this.isProfileStoreCreation) {
            this.createFileControl(parent);
        }
        if (this.storedPath != null && this.storedPath.trim().length() > 0) {
            File f = new File(this.storedPath);
            if (!f.exists() && this.isProfileStoreCreation) {
                String newFileName = f.getName();
                f = f.getParentFile();
                this.txtFile.setText(newFileName);
            }
            int level = 1;
            File parentFile = f != null ? f.getParentFile() : null;
            while (parentFile != null && !parentFile.getAbsolutePath().equals(this.topDir.getAbsolutePath())) {
                parentFile = parentFile.getParentFile();
                ++level;
            }
            this.getTreeViewer().expandToLevel((Object)parentFile, level);
            Widget w = this.getTreeViewer().testFindItem((Object)f);
            if (w == null) {
                this.getTreeViewer().expandAll();
            }
            this.setInitialSelection(f);
        } else {
            this.getTreeViewer().expandToLevel(2);
        }
        this.getTreeViewer().addFilter((ViewerFilter)this.treeViewerFilter);
        return c;
    }

    protected Label createMessageArea(Composite composite) {
        return null;
    }

    private void createFilterControl(Composite parent) {
        Composite compositeFilter = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 360;
        gridData.horizontalIndent = 10;
        compositeFilter.setLayoutData((Object)gridData);
        FormLayout layout = new FormLayout();
        compositeFilter.setLayout((Layout)layout);
        Label filterLabel = new Label(compositeFilter, 0);
        filterLabel.setText(Messages.profilePage_button_browse_filter);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 18);
        data.left = new FormAttachment(0, 5);
        filterLabel.setLayoutData((Object)data);
        filterLabel.setToolTipText(Messages.profilePage_button_browse_filter_tooltiptext);
        this.txtFilter = new Text(compositeFilter, 2048);
        data = new FormData();
        data.top = new FormAttachment(0, 15);
        data.left = new FormAttachment((Control)filterLabel, 5, 5);
        data.right = new FormAttachment(100, -10);
        this.txtFilter.setLayoutData((Object)data);
        this.txtFilter.setToolTipText(Messages.profilePage_button_browse_filter_tooltiptext);
    }

    private void createFileControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 360;
        gridData.horizontalIndent = 10;
        composite.setLayoutData((Object)gridData);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.label.text"));
        FormData data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.left = new FormAttachment(0, 5);
        fileLabel.setLayoutData((Object)data);
        this.txtFile = new Text(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)fileLabel, 5, 5);
        data.right = new FormAttachment(100, -10);
        this.txtFile.setLayoutData((Object)data);
    }

    protected void okPressed() {
        if (this.isProfileStoreCreation) {
            this.txtFileContent = this.txtFile.getText();
            if (this.txtFileContent.trim().length() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ui_errorLabel, (String)Messages.profilePage_browse_noselection_error);
                return;
            }
        }
        super.okPressed();
    }

    private static File[] getChildren(File f, boolean isProfileCreation) {
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] result = f.listFiles(new FileFilter(){

            public boolean accept(File child) {
                return true;
            }
        });
        if (result != null) {
            Arrays.sort(result, new FileComparator());
        }
        return result == null ? new File[]{} : result;
    }

    public String[] getSelectedItems() {
        Object[] selected;
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selected = this.getResult() == null ? new Object[]{} : this.getResult();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            File f = (File)o;
            if (this.isProfileStoreCreation) {
                String relativeFilePath;
                if (this.txtFileContent != null && this.txtFileContent.length() > 0 && !this.txtFileContent.contains(EXT_SEPERATOR) && ProfileFileExtension.exists((String)this.defaultExtension)) {
                    this.txtFileContent = String.valueOf(this.txtFileContent) + EXT_SEPERATOR + this.defaultExtension;
                }
                File selectedFileParent = f.isFile() ? f.getParentFile() : f;
                File selectedFile = new File(selectedFileParent, this.txtFileContent);
                try {
                    URI filePath = selectedFile.toURI();
                    URI relative = this.topDir.toURI().relativize(filePath);
                    relativeFilePath = relative.getPath();
                }
                catch (Exception exception) {
                    relativeFilePath = selectedFile.getPath();
                }
                result.add(relativeFilePath);
            } else if (!this.isProfileStoreCreation && f.isFile()) {
                URI relative = this.topDir.toURI().relativize(f.toURI());
                result.add(relative.getPath());
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private boolean isProfileCreation = false;

        public ContentProvider(boolean isProfileCreation) {
            this.isProfileCreation = isProfileCreation;
        }

        public Object[] getChildren(Object arg) {
            if (arg instanceof File) {
                return ProfilePathSelectionDialog.getChildren((File)arg, this.isProfileCreation);
            }
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg) {
            Object[] children = this.getChildren(arg);
            return children != null ? children.length > 0 : false;
        }

        public Object[] getElements(Object arg) {
            if (arg instanceof String) {
                return new Object[]{new File((String)arg)};
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && o2.isDirectory()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isFile() && o2.isFile()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            return 1;
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object arg) {
            if (arg instanceof File) {
                if (((File)arg).isFile()) {
                    return IMG_FILE;
                }
                return IMG_FOLDER;
            }
            return null;
        }

        public String getText(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.getName().trim().length() == 0) {
                    return f.getPath();
                }
                return f.getName();
            }
            return ProfilePathSelectionDialog.EMPTY_STRING;
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private class SelectionValidator
    implements ISelectionStatusValidator {
        private SelectionValidator() {
        }

        public IStatus validate(Object[] selections) {
            if (selections != null && selections.length > 0) {
                Object[] objectArray = selections;
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof File) {
                        File selFile = (File)o;
                        if (ProfilePathSelectionDialog.this.isProfileStoreCreation || !ProfilePathSelectionDialog.this.isProfileStoreCreation && selFile.isFile()) {
                            if (ProfilePathSelectionDialog.this.isProfileStoreCreation && selFile.isFile()) {
                                ProfilePathSelectionDialog.this.txtFile.setText(selFile.getName());
                            }
                            return new Status(0, ProfilePathSelectionDialog.PLUGIN_ID, 0, ProfilePathSelectionDialog.EMPTY_STRING, null);
                        }
                    }
                    ++n2;
                }
            }
            return new Status(4, ProfilePathSelectionDialog.PLUGIN_ID, 4, ProfilePathSelectionDialog.EMPTY_STRING, null);
        }
    }

    private class TreeViewerFilter
    extends ViewerFilter {
        private static final String FILTER_SEPARATOR = ",";

        private TreeViewerFilter() {
        }

        public boolean select(Viewer arg0, Object arg1, Object arg2) {
            if (arg2 instanceof File) {
                File file = (File)arg2;
                if (file.isDirectory()) {
                    return true;
                }
                String txtFilterContent = ProfilePathSelectionDialog.this.txtFilter.getText();
                if (txtFilterContent.contains(FILTER_SEPARATOR)) {
                    String[] filters;
                    String[] stringArray = filters = txtFilterContent.split(FILTER_SEPARATOR);
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filter = stringArray[n2];
                        if (this.showFile(file, filter)) {
                            return true;
                        }
                        ++n2;
                    }
                } else {
                    return this.showFile(file, txtFilterContent);
                }
            }
            return false;
        }

        private boolean showFile(File file, String filter) {
            String fileExt;
            if (!filter.contains(ProfilePathSelectionDialog.EXT_SEPERATOR)) {
                return true;
            }
            if ((filter = filter.trim()).endsWith(ProfilePathSelectionDialog.FILTER_ALLOW_ALL)) {
                return true;
            }
            String filterExt = filter.substring(filter.lastIndexOf(ProfilePathSelectionDialog.EXT_SEPERATOR) + 1);
            String fileName = file.getName();
            return fileName.contains(ProfilePathSelectionDialog.EXT_SEPERATOR) && (fileExt = fileName.substring(fileName.lastIndexOf(ProfilePathSelectionDialog.EXT_SEPERATOR) + 1)).equals(filterExt);
        }
    }
}

