/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.internal.core.IConfigurationRegistryListener;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public final class SQLDevToolsConfigRegistryImpl
implements SQLDevToolsConfigRegistry {
    public static final SQLDevToolsConfigRegistry INSTANCE = new SQLDevToolsConfigRegistryImpl();
    private static SQLDevToolsConfiguration DEFAULT_CONFIG = SQLDevToolsConfiguration.getDefaultInstance();
    private static ArrayList _listeners = new ArrayList();
    private volatile Boolean _factoriesLoaded = Boolean.FALSE;
    private Map _products = new TreeMap();
    private Map _factoriesById = new TreeMap();
    private Map _factoriesByVendorIdentifier = new TreeMap();
    private Map _factoriesByName = new TreeMap();
    private ArrayList _debuggerFactories = new ArrayList();
    private static Object bundleStartSemaphore = new Object();
    private static BundleListener listenerBundleStart = new BundleListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            if (event.getBundle() == EditorCorePlugin.getDefault().getBundle() && event.getType() == 2) {
                Object object = bundleStartSemaphore;
                synchronized (object) {
                    bundleStartSemaphore.notify();
                }
            }
        }
    };

    public Collection getProducts() {
        this.init();
        return this._products.keySet();
    }

    public Collection getVersions(String product) {
        this.init();
        Map versions = (Map)this._products.get(product);
        if (versions == null) {
            return new TreeMap().keySet();
        }
        return versions.keySet();
    }

    public Collection getConfigurations() {
        this.init();
        return this._factoriesById.values();
    }

    public Collection getDebuggerConfigurations() {
        this.init();
        return this._debuggerFactories;
    }

    public SQLDevToolsConfiguration getConfiguration(String product, String version) {
        this.init();
        Map versions = (Map)this._products.get(product);
        if (versions == null) {
            return null;
        }
        return (SQLDevToolsConfiguration)versions.get(version);
    }

    public SQLDevToolsConfiguration getConfigurationById(String id) {
        this.init();
        return (SQLDevToolsConfiguration)this._factoriesById.get(id);
    }

    public SQLDevToolsConfiguration getConfigurationByVendorIdentifier(DatabaseVendorDefinitionId id) {
        this.init();
        return (SQLDevToolsConfiguration)this._factoriesByVendorIdentifier.get(id);
    }

    public SQLDevToolsConfiguration getConfigurationByName(String name) {
        this.init();
        return (SQLDevToolsConfiguration)this._factoriesByName.get(name);
    }

    private SQLDevToolsConfigRegistryImpl() {
    }

    private synchronized void init() {
        if (this._factoriesLoaded.booleanValue()) {
            return;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.sqltools.editor.core", "dbConfigurations");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("dbConfiguration")) {
                    String product = configElements[j].getAttribute("product");
                    String version = configElements[j].getAttribute("version");
                    String name = String.valueOf(product) + "_" + version;
                    String id = configElements[j].getAttribute("id");
                    String supportsDebugging = configElements[j].getAttribute("supportsDebugging");
                    String isDefault = configElements[j].getAttribute("default");
                    if (id == null) {
                        id = name;
                    }
                    String className = configElements[j].getAttribute("configurationClass");
                    try {
                        DatabaseVendorDefinitionId identifier;
                        SQLDevToolsConfiguration factory = (SQLDevToolsConfiguration)configElements[j].createExecutableExtension("configurationClass");
                        DatabaseVendorDefinitionId dbVendorId = new DatabaseVendorDefinitionId(product, version);
                        factory.setDatabaseVendorDefinitionId(dbVendorId);
                        if (this._products.containsKey(product)) {
                            ((Map)this._products.get(product)).put(version, factory);
                        } else {
                            TreeMap<String, SQLDevToolsConfiguration> versions = new TreeMap<String, SQLDevToolsConfiguration>();
                            versions.put(version, factory);
                            this._products.put(product, versions);
                        }
                        if (!this._factoriesById.containsKey(id)) {
                            this._factoriesById.put(id, factory);
                        }
                        if (!this._factoriesByVendorIdentifier.containsKey(identifier = new DatabaseVendorDefinitionId(product, version))) {
                            this._factoriesByVendorIdentifier.put(identifier, factory);
                        }
                        if (!this._factoriesByName.containsKey(name)) {
                            this._factoriesByName.put(name, factory);
                        }
                        if ("true".equals(supportsDebugging)) {
                            this._debuggerFactories.add(factory);
                        }
                        if ("true".equals(isDefault)) {
                            DEFAULT_CONFIG = factory;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            Status status = new Status(4, "org.eclipse.datatools.sqltools.editor.core", 4, "The error was detected when creating the database recognizer " + className, (Throwable)e);
                            EditorCorePlugin.getDefault().log((IStatus)status);
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this._factoriesLoaded = Boolean.TRUE;
        for (final IConfigurationRegistryListener l : _listeners) {
            new Thread(){

                public void run() {
                    SQLDevToolsConfigRegistryImpl.waitForEditorCorePluginStart();
                    l.configurationLoaded();
                }
            }.start();
        }
    }

    public static SQLDevToolsConfiguration getDefaultConfiguration() {
        ((SQLDevToolsConfigRegistryImpl)INSTANCE).init();
        return DEFAULT_CONFIG;
    }

    public void addConfigurationRegistryListener(final IConfigurationRegistryListener listener) {
        _listeners.add(listener);
        new Thread(){

            public void run() {
                SQLDevToolsConfigRegistryImpl.waitForEditorCorePluginStart();
                if (SQLDevToolsConfigRegistryImpl.this._factoriesLoaded.booleanValue()) {
                    listener.configurationLoaded();
                } else {
                    SQLDevToolsConfigRegistryImpl.this.init();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void waitForEditorCorePluginStart() {
        Bundle bundle = EditorCorePlugin.getDefault().getBundle();
        if (bundle.getState() != 8) {
            return;
        }
        bundle.getBundleContext().addBundleListener(listenerBundleStart);
        Object object = bundleStartSemaphore;
        synchronized (object) {
            while (bundle.getState() == 8) {
                try {
                    bundleStartSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        bundle.getBundleContext().removeBundleListener(listenerBundleStart);
    }

    public static class DBFactoryVersionComparator
    implements Comparator {
        public int compare(Object left, Object right) {
            SQLDevToolsConfiguration f1 = (SQLDevToolsConfiguration)left;
            SQLDevToolsConfiguration f2 = (SQLDevToolsConfiguration)right;
            return new DatabaseVendorDefinitionId.VersionComparator().compare(f1.getDatabaseVendorDefinitionId().getVersion(), f2.getDatabaseVendorDefinitionId().getVersion());
        }
    }
}

